default['ubuntu2204STIG']['XCCDF_result']['Manage'] = true

# R-260473 UBTU-22-213015
default['ubuntu2204STIG']['stigrule_260473']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260473']['Title'] = "Ubuntu 22.04 LTS must disable kernel core dumps so that it can fail to a secure state if system initialization fails, shutdown fails or aborts fail."
default['ubuntu2204STIG']['stigrule_260473']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_disable_ServiceName'] = 'kdump-tools'
default['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_disable_Action'] = :disable

default['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_mask_ServiceName'] = 'kdump-tools'
default['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_mask_Action'] = :mask

# R-260476 UBTU-22-214010
default['ubuntu2204STIG']['stigrule_260476']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260476']['Title'] = "Ubuntu 22.04 LTS must be configured so that the Advance Package Tool (APT) prevents the installation of patches, service packs, device drivers, or operating system components without verification they have been digitally signed using a certificate that is recognized and approved by the organization."
default['ubuntu2204STIG']['stigrule_260476']['Severity'] = 'low'
default['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Path'] = '/etc/apt/apt.conf.d/01-vendor-ubuntu'
default['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Regexp'] = '^APT::Get::AllowUnauthenticated'
default['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Line'] = 'APT::Get::AllowUnauthenticated "false";'

# R-260477 UBTU-22-214015
default['ubuntu2204STIG']['stigrule_260477']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260477']['Title'] = "Ubuntu 22.04 LTS must be configured so that the Advance Package Tool (APT) removes all software components after updated versions have been installed."
default['ubuntu2204STIG']['stigrule_260477']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path'] = '/etc/apt/apt.conf.d/50unattended-upgrades'
default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Regexp'] = '^Unattended-Upgrade::Remove-Unused-Dependencies'
default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Line'] = 'Unattended-Upgrade::Remove-Unused-Dependencies "true";'

default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path'] = '/etc/apt/apt.conf.d/50unattended-upgrades'
default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Regexp'] = '^Unattended-Upgrade::Remove-Unused-Kernel-Packages'
default['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Line'] = 'Unattended-Upgrade::Remove-Unused-Kernel-Packages "true";'

# R-260482 UBTU-22-215030
default['ubuntu2204STIG']['stigrule_260482']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260482']['Title'] = "Ubuntu 22.04 LTS must not have the \"rsh-server\" package installed."
default['ubuntu2204STIG']['stigrule_260482']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260482']['Setting']['rsh_server_PackageName'] = 'rsh-server'
default['ubuntu2204STIG']['stigrule_260482']['Setting']['rsh_server_Action'] = :remove

# R-260483 UBTU-22-215035
default['ubuntu2204STIG']['stigrule_260483']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260483']['Title'] = "Ubuntu 22.04 LTS must not have the \"telnet\" package installed."
default['ubuntu2204STIG']['stigrule_260483']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260483']['Setting']['telnetd_PackageName'] = 'telnetd'
default['ubuntu2204STIG']['stigrule_260483']['Setting']['telnetd_Action'] = :remove

# R-260514 UBTU-22-251010
default['ubuntu2204STIG']['stigrule_260514']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260514']['Title'] = "Ubuntu 22.04 LTS must have an application firewall installed in order to control remote access methods."
default['ubuntu2204STIG']['stigrule_260514']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260514']['Setting']['ufw_PackageName'] = 'ufw'
default['ubuntu2204STIG']['stigrule_260514']['Setting']['ufw_Action'] = :install

# R-260515 UBTU-22-251015
# A duplicate of 260516
# duplicate of 260516
# R-260516 UBTU-22-251020
default['ubuntu2204STIG']['stigrule_260516']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260516']['Title'] = "Ubuntu 22.04 LTS must have an application firewall enabled."
default['ubuntu2204STIG']['stigrule_260516']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_enable_ServiceName'] = 'ufw'
default['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_enable_Action'] = :enable

default['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_start_ServiceName'] = 'ufw'
default['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_start_Action'] = :start

# R-260522 UBTU-22-253010
default['ubuntu2204STIG']['stigrule_260522']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260522']['Title'] = "Ubuntu 22.04 LTS must be configured to use TCP syncookies."
default['ubuntu2204STIG']['stigrule_260522']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260522']['Setting']['net_ipv4_tcp_syncookies_Key'] = 'net.ipv4.tcp_syncookies'
default['ubuntu2204STIG']['stigrule_260522']['Setting']['net_ipv4_tcp_syncookies_Value'] = 1

default['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Path'] = '/etc/sysctl.conf'
default['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Regexp'] = '^\s*net.ipv4.tcp_syncookies'
default['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Line'] = 'net.ipv4.tcp_syncookies = 1'

# R-260523 UBTU-22-255010
default['ubuntu2204STIG']['stigrule_260523']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260523']['Title'] = "Ubuntu 22.04 LTS must have SSH installed."
default['ubuntu2204STIG']['stigrule_260523']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260523']['Setting']['ssh_PackageName'] = 'ssh'
default['ubuntu2204STIG']['stigrule_260523']['Setting']['ssh_Action'] = :install

# R-260524 UBTU-22-255015
default['ubuntu2204STIG']['stigrule_260524']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260524']['Title'] = "Ubuntu 22.04 LTS must use SSH to protect the confidentiality and integrity of transmitted information."
default['ubuntu2204STIG']['stigrule_260524']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_active_ServiceName'] = 'sshd'
default['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_active_Action'] = :enable

default['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_start_ServiceName'] = 'sshd'
default['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_start_Action'] = :start

# R-260525 UBTU-22-255020
default['ubuntu2204STIG']['stigrule_260525']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260525']['Title'] = "Ubuntu 22.04 LTS must display the Standard Mandatory DOD Notice and Consent Banner before granting any local or remote connection to the system."
default['ubuntu2204STIG']['stigrule_260525']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Regexp'] = '^\s*(?i)banner\s+'
default['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Line'] = 'banner /etc/issue.net'

default['ubuntu2204STIG']['stigrule_260525']['Setting']['_etc_issue_net_Path'] = '/etc/issue.net'
default['ubuntu2204STIG']['stigrule_260525']['Setting']['_etc_issue_net_Content'] = 'You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.
By using this IS (which includes any device attached to this IS), you consent to the following conditions:
-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.
-At any time, the USG may inspect and seize data stored on this IS.
-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.
-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.
-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details.
'

# R-260526 UBTU-22-255025
default['ubuntu2204STIG']['stigrule_260526']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260526']['Title'] = "Ubuntu 22.04 LTS must not allow unattended or automatic login via SSH."
default['ubuntu2204STIG']['stigrule_260526']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Regexp'] = '^\s*(?i)PermitEmptyPasswords\s+'
default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Line'] = 'PermitEmptyPasswords no'

default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Regexp'] = '^\s*(?i)PermitUserEnvironment\s+'
default['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Line'] = 'PermitUserEnvironment no'

# R-260527 UBTU-22-255030
default['ubuntu2204STIG']['stigrule_260527']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260527']['Title'] = "Ubuntu 22.04 LTS must be configured so that all network connections associated with SSH traffic terminate after becoming unresponsive."
default['ubuntu2204STIG']['stigrule_260527']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Regexp'] = '^\s*(?i)ClientAliveCountMax\s+'
default['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Line'] = 'ClientAliveCountMax 1'

# R-260528 UBTU-22-255035
default['ubuntu2204STIG']['stigrule_260528']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260528']['Title'] = "Ubuntu 22.04 LTS must be configured so that all network connections associated with SSH traffic are terminated after 10 minutes of becoming unresponsive."
default['ubuntu2204STIG']['stigrule_260528']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Regexp'] = '^\s*(?i)ClientAliveInterval\s+'
default['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Line'] = 'ClientAliveInterval 600'

# R-260529 UBTU-22-255040
default['ubuntu2204STIG']['stigrule_260529']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260529']['Title'] = "Ubuntu 22.04 LTS must be configured so that remote X connections are disabled, unless to fulfill documented and validated mission requirements."
default['ubuntu2204STIG']['stigrule_260529']['Severity'] = 'high'
default['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Regexp'] = '^\s*(?i)X11Forwarding\s+'
default['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Line'] = 'X11Forwarding no'

# R-260530 UBTU-22-255045
default['ubuntu2204STIG']['stigrule_260530']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260530']['Title'] = "Ubuntu 22.04 LTS SSH daemon must prevent remote hosts from connecting to the proxy display."
default['ubuntu2204STIG']['stigrule_260530']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Regexp'] = '^\s*(?i)X11UseLocalhost\s+'
default['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Line'] = 'X11UseLocalhost yes'

# R-260531 UBTU-22-255050
default['ubuntu2204STIG']['stigrule_260531']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260531']['Title'] = "Ubuntu 22.04 LTS must configure the SSH daemon to use FIPS 140-3-approved ciphers to prevent the unauthorized disclosure of information and/or detect changes to information during transmission."
default['ubuntu2204STIG']['stigrule_260531']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Regexp'] = '^\s*(?i)Ciphers\s+'
default['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Line'] = 'Ciphers aes256-ctr,aes256-gcm@openssh.com,aes192-ctr,aes128-ctr,aes128-gcm@openssh.com'

# R-260532 UBTU-22-255055
default['ubuntu2204STIG']['stigrule_260532']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260532']['Title'] = "Ubuntu 22.04 LTS must configure the SSH daemon to use Message Authentication Codes (MACs) employing FIPS 140-3-approved cryptographic hashes to prevent the unauthorized disclosure of information and/or detect changes to information during transmission."
default['ubuntu2204STIG']['stigrule_260532']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Regexp'] = '^\s*(?i)MACs\s+'
default['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Line'] = 'MACs hmac-sha2-512,hmac-sha2-512-etm@openssh.com,hmac-sha2-256,hmac-sha2-256-etm@openssh.com '

# R-260535 UBTU-22-271010
default['ubuntu2204STIG']['stigrule_260535']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260535']['Title'] = "Ubuntu 22.04 LTS must enable the graphical user logon banner to display the Standard Mandatory DOD Notice and Consent Banner before granting local access to the system via a graphical user logon."
default['ubuntu2204STIG']['stigrule_260535']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Path'] = '/etc/gdm3/greeter.dconf-defaults'
default['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Section'] = 'org/gnome/login-screen'
default['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Option'] = 'banner-message-enable'
default['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Value'] = "true"
default['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Only_if'] = "dpkg -s gdm3"

# R-260536 UBTU-22-271015
default['ubuntu2204STIG']['stigrule_260536']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260536']['Title'] = "Ubuntu 22.04 LTS must display the Standard Mandatory DOD Notice and Consent Banner before granting local access to the system via a graphical user logon."
default['ubuntu2204STIG']['stigrule_260536']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Path'] = '/etc/gdm3/greeter.dconf-defaults'
default['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Section'] = 'org/gnome/login-screen'
default['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Option'] = 'banner-message-text'
default['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Value'] = "You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.\n\nBy using this IS (which includes any device attached to this IS), you consent to the following conditions:\n\n-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.\n\n-At any time, the USG may inspect and seize data stored on this IS.\n\n-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.\n\n-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.\n\n-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details."
default['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Only_if'] = "dpkg -s gdm3"

# R-260545 UBTU-22-411025
default['ubuntu2204STIG']['stigrule_260545']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260545']['Title'] = "Ubuntu 22.04 LTS must enforce 24 hours/one day as the minimum password lifetime. Passwords for new users must have a 24 hours/one day minimum password lifetime restriction."
default['ubuntu2204STIG']['stigrule_260545']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MIN_DAYS'
default['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Line'] = 'PASS_MIN_DAYS 1'

# R-260546 UBTU-22-411030
default['ubuntu2204STIG']['stigrule_260546']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260546']['Title'] = "Ubuntu 22.04 LTS must enforce a 60-day maximum password lifetime restriction. Passwords for new users must have a 60-day maximum password lifetime restriction."
default['ubuntu2204STIG']['stigrule_260546']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MAX_DAYS'
default['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Line'] = 'PASS_MAX_DAYS 60'

# R-260552 UBTU-22-412020
default['ubuntu2204STIG']['stigrule_260552']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260552']['Title'] = "Ubuntu 22.04 LTS must limit the number of concurrent sessions to ten for all accounts and/or account types."
default['ubuntu2204STIG']['stigrule_260552']['Severity'] = 'low'
default['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Path'] = '/etc/security/limits.conf'
default['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Regexp'] = '^\* hard maxlogins'
default['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Line'] = '* hard maxlogins 10'

# R-260553 UBTU-22-412025
default['ubuntu2204STIG']['stigrule_260553']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260553']['Title'] = "Ubuntu 22.04 LTS must allow users to directly initiate a session lock for all connection types."
default['ubuntu2204STIG']['stigrule_260553']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260553']['Setting']['vlock_PackageName'] = 'vlock'
default['ubuntu2204STIG']['stigrule_260553']['Setting']['vlock_Action'] = :install

# R-260554 UBTU-22-412030
default['ubuntu2204STIG']['stigrule_260554']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260554']['Title'] = "Ubuntu 22.04 LTS must automatically exit interactive command shell user sessions after 15 minutes of inactivity."
default['ubuntu2204STIG']['stigrule_260554']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260554']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Path'] = '/etc/profile.d/99-terminal_tmout.sh'
default['ubuntu2204STIG']['stigrule_260554']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Content'] = 'TMOUT=600'

# R-260555 UBTU-22-412035
default['ubuntu2204STIG']['stigrule_260555']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260555']['Title'] = "Ubuntu 22.04 LTS default filesystem permissions must be defined in such a way that all authenticated users can read and modify only their own files."
default['ubuntu2204STIG']['stigrule_260555']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Regexp'] = '^UMASK'
default['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Line'] = 'UMASK 077'

# R-260556 UBTU-22-431010
default['ubuntu2204STIG']['stigrule_260556']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260556']['Title'] = "Ubuntu 22.04 LTS must have the \"apparmor\" package installed."
default['ubuntu2204STIG']['stigrule_260556']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260556']['Setting']['apparmor_PackageName'] = 'apparmor'
default['ubuntu2204STIG']['stigrule_260556']['Setting']['apparmor_Action'] = :install

# R-260557 UBTU-22-431015
default['ubuntu2204STIG']['stigrule_260557']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260557']['Title'] = "Ubuntu 22.04 LTS must be configured to use AppArmor."
default['ubuntu2204STIG']['stigrule_260557']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_enable_ServiceName'] = 'apparmor'
default['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_enable_Action'] = :enable

default['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_start_ServiceName'] = 'apparmor'
default['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_start_Action'] = :start

# R-260560 UBTU-22-611010
default['ubuntu2204STIG']['stigrule_260560']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260560']['Title'] = "Ubuntu 22.04 LTS must enforce password complexity by requiring at least one uppercase character be used."
default['ubuntu2204STIG']['stigrule_260560']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ucredit'
default['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Line'] = 'ucredit=-1'

# R-260561 UBTU-22-611015
default['ubuntu2204STIG']['stigrule_260561']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260561']['Title'] = "Ubuntu 22.04 LTS must enforce password complexity by requiring at least one lowercase character be used."
default['ubuntu2204STIG']['stigrule_260561']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*lcredit'
default['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Line'] = 'lcredit=-1'

# R-260562 UBTU-22-611020
default['ubuntu2204STIG']['stigrule_260562']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260562']['Title'] = "Ubuntu 22.04 LTS must enforce password complexity by requiring that at least one numeric character be used."
default['ubuntu2204STIG']['stigrule_260562']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dcredit'
default['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Line'] = 'dcredit=-1'

# R-260563 UBTU-22-611025
default['ubuntu2204STIG']['stigrule_260563']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260563']['Title'] = "Ubuntu 22.04 LTS must enforce password complexity by requiring that at least one special character be used."
default['ubuntu2204STIG']['stigrule_260563']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ocredit'
default['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Line'] = 'ocredit=-1'

# R-260564 UBTU-22-611030
default['ubuntu2204STIG']['stigrule_260564']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260564']['Title'] = "Ubuntu 22.04 LTS must prevent the use of dictionary words for passwords."
default['ubuntu2204STIG']['stigrule_260564']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dictcheck'
default['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Line'] = 'dictcheck=1'

# R-260565 UBTU-22-611035
default['ubuntu2204STIG']['stigrule_260565']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260565']['Title'] = "Ubuntu 22.04 LTS must enforce a minimum 15-character password length."
default['ubuntu2204STIG']['stigrule_260565']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*minlen'
default['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Line'] = 'minlen=15'

# R-260566 UBTU-22-611040
default['ubuntu2204STIG']['stigrule_260566']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260566']['Title'] = "Ubuntu 22.04 LTS must require the change of at least eight characters when passwords are changed."
default['ubuntu2204STIG']['stigrule_260566']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*difok'
default['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Line'] = 'difok=8'

# R-260572 UBTU-22-611070
default['ubuntu2204STIG']['stigrule_260572']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260572']['Title'] = "Ubuntu 22.04 LTS must encrypt all stored passwords with a FIPS 140-3-approved cryptographic hashing algorithm."
default['ubuntu2204STIG']['stigrule_260572']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Regexp'] = '^ENCRYPT_METHOD'
default['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Line'] = 'ENCRYPT_METHOD SHA512'

# R-260573 UBTU-22-612010
default['ubuntu2204STIG']['stigrule_260573']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260573']['Title'] = "Ubuntu 22.04 LTS must implement multifactor authentication for remote access to privileged accounts in such a way that one of the factors is provided by a device separate from the system gaining access."
default['ubuntu2204STIG']['stigrule_260573']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260573']['Setting']['libpam_pkcs11_PackageName'] = 'libpam-pkcs11'
default['ubuntu2204STIG']['stigrule_260573']['Setting']['libpam_pkcs11_Action'] = :install

# R-260574 UBTU-22-612015
default['ubuntu2204STIG']['stigrule_260574']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260574']['Title'] = "Ubuntu 22.04 LTS must accept personal identity verification (PIV) credentials."
default['ubuntu2204STIG']['stigrule_260574']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260574']['Setting']['opensc_pkcs11_PackageName'] = 'opensc-pkcs11'
default['ubuntu2204STIG']['stigrule_260574']['Setting']['opensc_pkcs11_Action'] = :install

# R-260588 UBTU-22-652010
default['ubuntu2204STIG']['stigrule_260588']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260588']['Title'] = "Ubuntu 22.04 LTS must be configured to preserve log records from failure events."
default['ubuntu2204STIG']['stigrule_260588']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_PackageName'] = 'rsyslog'
default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_Action'] = :install

default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_enable_ServiceName'] = 'rsyslog'
default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_enable_Action'] = :enable

default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_start_ServiceName'] = 'rsyslog'
default['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_start_Action'] = :start

# R-260590 UBTU-22-653010
default['ubuntu2204STIG']['stigrule_260590']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260590']['Title'] = "Ubuntu 22.04 LTS must have the \"auditd\" package installed."
default['ubuntu2204STIG']['stigrule_260590']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260590']['Setting']['auditd_PackageName'] = 'auditd'
default['ubuntu2204STIG']['stigrule_260590']['Setting']['auditd_Action'] = :install

# R-260591 UBTU-22-653015
default['ubuntu2204STIG']['stigrule_260591']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260591']['Title'] = "Ubuntu 22.04 LTS must produce audit records and reports containing information to establish when, where, what type, the source, and the outcome for all DOD-defined auditable events and actions in near real time."
default['ubuntu2204STIG']['stigrule_260591']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_ServiceName'] = 'auditd'
default['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_Action'] = :enable

default['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_ServiceName'] = 'auditd'
default['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_Action'] = :start

# R-260593 UBTU-22-653025
# Change root to an account for security personnel.
default['ubuntu2204STIG']['stigrule_260593']['Manage'] = false
default['ubuntu2204STIG']['stigrule_260593']['Title'] = "Ubuntu 22.04 LTS must alert the information system security officer (ISSO) and system administrator (SA) in the event of an audit processing failure."
default['ubuntu2204STIG']['stigrule_260593']['Severity'] = 'low'
default['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^action_mail_acct = '
default['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Line'] = 'action_mail_acct = root'

# R-260594 UBTU-22-653030
default['ubuntu2204STIG']['stigrule_260594']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260594']['Title'] = "Ubuntu 22.04 LTS must shut down by default upon audit failure."
default['ubuntu2204STIG']['stigrule_260594']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^disk_full_action = '
default['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Line'] = 'disk_full_action = HALT'

# R-260604 UBTU-22-654010
default['ubuntu2204STIG']['stigrule_260604']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260604']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the apparmor_parser command."
default['ubuntu2204STIG']['stigrule_260604']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Regexp'] = '^-a always,exit -F path=/sbin/apparmor_parser -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Line'] = '-a always,exit -F path=/sbin/apparmor_parser -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260605 UBTU-22-654015
default['ubuntu2204STIG']['stigrule_260605']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260605']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chacl command."
default['ubuntu2204STIG']['stigrule_260605']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Regexp'] = '^-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Line'] = '-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260606 UBTU-22-654020
default['ubuntu2204STIG']['stigrule_260606']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260606']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chage command."
default['ubuntu2204STIG']['stigrule_260606']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Regexp'] = '^-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chage$'
default['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Line'] = '-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chage'

# R-260607 UBTU-22-654025
default['ubuntu2204STIG']['stigrule_260607']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260607']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chcon command."
default['ubuntu2204STIG']['stigrule_260607']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Regexp'] = '^-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Line'] = '-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260608 UBTU-22-654030
default['ubuntu2204STIG']['stigrule_260608']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260608']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chfn command."
default['ubuntu2204STIG']['stigrule_260608']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Regexp'] = '^-a always,exit -F path=/usr/bin/chfn -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chfn$'
default['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Line'] = '-a always,exit -F path=/usr/bin/chfn -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chfn'

# R-260609 UBTU-22-654035
default['ubuntu2204STIG']['stigrule_260609']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260609']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chsh command."
default['ubuntu2204STIG']['stigrule_260609']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Regexp'] = '^-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Line'] = '-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-260610 UBTU-22-654040
default['ubuntu2204STIG']['stigrule_260610']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260610']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the crontab command."
default['ubuntu2204STIG']['stigrule_260610']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Regexp'] = '^-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=unset -k privileged-crontab$'
default['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Line'] = '-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=unset -k privileged-crontab'

# R-260611 UBTU-22-654045
default['ubuntu2204STIG']['stigrule_260611']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260611']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful attempts to use the fdisk command."
default['ubuntu2204STIG']['stigrule_260611']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Regexp'] = '^-w /usr/sbin/fdisk -p x -k fdisk $'
default['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Line'] = '-w /usr/sbin/fdisk -p x -k fdisk '

# R-260612 UBTU-22-654050
default['ubuntu2204STIG']['stigrule_260612']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260612']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the gpasswd command."
default['ubuntu2204STIG']['stigrule_260612']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Regexp'] = '^-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-gpasswd$'
default['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Line'] = '-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-gpasswd'

# R-260613 UBTU-22-654055
default['ubuntu2204STIG']['stigrule_260613']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260613']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful attempts to use the kmod command."
default['ubuntu2204STIG']['stigrule_260613']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Regexp'] = '^-w /bin/kmod -p x -k modules$'
default['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Line'] = '-w /bin/kmod -p x -k modules'

# R-260614 UBTU-22-654060
default['ubuntu2204STIG']['stigrule_260614']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260614']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful attempts to use modprobe command."
default['ubuntu2204STIG']['stigrule_260614']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Regexp'] = '^-w /sbin/modprobe -p x -k modules$'
default['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Line'] = '-w /sbin/modprobe -p x -k modules'

# R-260615 UBTU-22-654065
default['ubuntu2204STIG']['stigrule_260615']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260615']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the mount command."
default['ubuntu2204STIG']['stigrule_260615']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Regexp'] = '^-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount$'
default['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Line'] = '-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount'

# R-260616 UBTU-22-654070
default['ubuntu2204STIG']['stigrule_260616']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260616']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the newgrp command."
default['ubuntu2204STIG']['stigrule_260616']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Regexp'] = '^-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Line'] = '-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-260617 UBTU-22-654075
default['ubuntu2204STIG']['stigrule_260617']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260617']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the pam_timestamp_check command."
default['ubuntu2204STIG']['stigrule_260617']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Regexp'] = '^-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=unset -k privileged-pam_timestamp_check$'
default['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Line'] = '-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=unset -k privileged-pam_timestamp_check'

# R-260618 UBTU-22-654080
default['ubuntu2204STIG']['stigrule_260618']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260618']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the passwd command."
default['ubuntu2204STIG']['stigrule_260618']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Regexp'] = '^-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-passwd$'
default['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Line'] = '-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-passwd'

# R-260619 UBTU-22-654085
default['ubuntu2204STIG']['stigrule_260619']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260619']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the setfacl command."
default['ubuntu2204STIG']['stigrule_260619']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Regexp'] = '^-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Line'] = '-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260620 UBTU-22-654090
default['ubuntu2204STIG']['stigrule_260620']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260620']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the ssh-agent command."
default['ubuntu2204STIG']['stigrule_260620']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Regexp'] = '^-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh$'
default['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Line'] = '-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh'

# R-260621 UBTU-22-654095
default['ubuntu2204STIG']['stigrule_260621']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260621']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the ssh-keysign command."
default['ubuntu2204STIG']['stigrule_260621']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Regexp'] = '^-a always,exit -F path=/usr/lib/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh$'
default['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Line'] = '-a always,exit -F path=/usr/lib/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh'

# R-260622 UBTU-22-654100
default['ubuntu2204STIG']['stigrule_260622']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260622']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the su command."
default['ubuntu2204STIG']['stigrule_260622']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Regexp'] = '^-a always,exit -F path=/bin/su -F perm=x -F auid>=1000 -F auid!=unset -k privileged-priv_change$'
default['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Line'] = '-a always,exit -F path=/bin/su -F perm=x -F auid>=1000 -F auid!=unset -k privileged-priv_change'

# R-260623 UBTU-22-654105
default['ubuntu2204STIG']['stigrule_260623']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260623']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the sudo command."
default['ubuntu2204STIG']['stigrule_260623']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Regexp'] = '^-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Line'] = '-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-260624 UBTU-22-654110
default['ubuntu2204STIG']['stigrule_260624']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260624']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the sudoedit command."
default['ubuntu2204STIG']['stigrule_260624']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Regexp'] = '^-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Line'] = '-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-260625 UBTU-22-654115
default['ubuntu2204STIG']['stigrule_260625']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260625']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the umount command."
default['ubuntu2204STIG']['stigrule_260625']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Regexp'] = '^-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-umount$'
default['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Line'] = '-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-umount'

# R-260626 UBTU-22-654120
default['ubuntu2204STIG']['stigrule_260626']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260626']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the unix_update command."
default['ubuntu2204STIG']['stigrule_260626']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Regexp'] = '^-a always,exit -F path=/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Line'] = '-a always,exit -F path=/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-260627 UBTU-22-654125
default['ubuntu2204STIG']['stigrule_260627']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260627']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the usermod command."
default['ubuntu2204STIG']['stigrule_260627']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Regexp'] = '^-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=unset -k privileged-usermod$'
default['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Line'] = '-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=unset -k privileged-usermod'

# R-260628 UBTU-22-654130
default['ubuntu2204STIG']['stigrule_260628']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260628']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/group."
default['ubuntu2204STIG']['stigrule_260628']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Regexp'] = '^-w /etc/group -p wa -k usergroup_modification$'
default['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Line'] = '-w /etc/group -p wa -k usergroup_modification'

# R-260629 UBTU-22-654135
default['ubuntu2204STIG']['stigrule_260629']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260629']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/gshadow."
default['ubuntu2204STIG']['stigrule_260629']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Regexp'] = '^-w /etc/gshadow -p wa -k usergroup_modification$'
default['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Line'] = '-w /etc/gshadow -p wa -k usergroup_modification'

# R-260630 UBTU-22-654140
default['ubuntu2204STIG']['stigrule_260630']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260630']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/opasswd."
default['ubuntu2204STIG']['stigrule_260630']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Regexp'] = '^-w /etc/security/opasswd -p wa -k usergroup_modification$'
default['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Line'] = '-w /etc/security/opasswd -p wa -k usergroup_modification'

# R-260631 UBTU-22-654145
default['ubuntu2204STIG']['stigrule_260631']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260631']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/passwd."
default['ubuntu2204STIG']['stigrule_260631']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Regexp'] = '^-w /etc/passwd -p wa -k usergroup_modification$'
default['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Line'] = '-w /etc/passwd -p wa -k usergroup_modification'

# R-260632 UBTU-22-654150
default['ubuntu2204STIG']['stigrule_260632']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260632']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/shadow."
default['ubuntu2204STIG']['stigrule_260632']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Regexp'] = '^-w /etc/shadow -p wa -k usergroup_modification$'
default['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Line'] = '-w /etc/shadow -p wa -k usergroup_modification'

# R-260633 UBTU-22-654155
default['ubuntu2204STIG']['stigrule_260633']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260633']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chmod, fchmod, and fchmodat system calls."
default['ubuntu2204STIG']['stigrule_260633']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Regexp'] = '^-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Line'] = '-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_chng'

default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Regexp'] = '^-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Line'] = '-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260634 UBTU-22-654160
default['ubuntu2204STIG']['stigrule_260634']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260634']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the chown, fchown, fchownat, and lchown system calls."
default['ubuntu2204STIG']['stigrule_260634']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Regexp'] = '^-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Line'] = '-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_chng'

default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Regexp'] = '^-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_chng$'
default['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Line'] = '-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_chng'

# R-260635 UBTU-22-654165
default['ubuntu2204STIG']['stigrule_260635']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260635']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the creat, open, openat, open_by_handle_at, truncate, and ftruncate system calls."
default['ubuntu2204STIG']['stigrule_260635']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Regexp'] = '^-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access$'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Line'] = '-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access'

default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Regexp'] = '^-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access$'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Line'] = '-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access'

default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Regexp'] = '^-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access$'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Line'] = '-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access'

default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Regexp'] = '^-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access$'
default['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Line'] = '-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access'

# R-260636 UBTU-22-654170
default['ubuntu2204STIG']['stigrule_260636']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260636']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the delete_module system call."
default['ubuntu2204STIG']['stigrule_260636']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Regexp'] = '^-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Line'] = '-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng'

default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Regexp'] = '^-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Line'] = '-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng'

# R-260637 UBTU-22-654175
default['ubuntu2204STIG']['stigrule_260637']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260637']['Title'] = "Ubuntu 22.04 LTS must generate audit records for successful/unsuccessful uses of the init_module and finit_module system calls."
default['ubuntu2204STIG']['stigrule_260637']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Regexp'] = '^-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Line'] = '-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng'

default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Regexp'] = '^-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Line'] = '-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng'

# R-260638 UBTU-22-654180
default['ubuntu2204STIG']['stigrule_260638']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260638']['Title'] = "Ubuntu 22.04 LTS must generate audit records for any use of the setxattr, fsetxattr, lsetxattr, removexattr, fremovexattr, and lremovexattr system calls."
default['ubuntu2204STIG']['stigrule_260638']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod'

default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod'

default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

# R-260639 UBTU-22-654185
default['ubuntu2204STIG']['stigrule_260639']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260639']['Title'] = "Ubuntu 22.04 LTS must generate audit records for any successful/unsuccessful use of unlink, unlinkat, rename, renameat, and rmdir system calls."
default['ubuntu2204STIG']['stigrule_260639']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Regexp'] = '^-a always,exit -F arch=b64 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=unset -k delete$'
default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Line'] = '-a always,exit -F arch=b64 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=unset -k delete'

default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Regexp'] = '^-a always,exit -F arch=b32 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=unset -k delete$'
default['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Line'] = '-a always,exit -F arch=b32 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=unset -k delete'

# R-260640 UBTU-22-654190
default['ubuntu2204STIG']['stigrule_260640']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260640']['Title'] = "Ubuntu 22.04 LTS must generate audit records for all events that affect the systemd journal files."
default['ubuntu2204STIG']['stigrule_260640']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Regexp'] = '^-w /var/log/journal -p wa -k systemd_journal$'
default['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Line'] = '-w /var/log/journal -p wa -k systemd_journal'

# R-260641 UBTU-22-654195
default['ubuntu2204STIG']['stigrule_260641']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260641']['Title'] = "Ubuntu 22.04 LTS must generate audit records for the /var/log/btmp file."
default['ubuntu2204STIG']['stigrule_260641']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Regexp'] = '^-w /var/log/btmp -p wa -k logins$'
default['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Line'] = '-w /var/log/btmp -p wa -k logins'

# R-260642 UBTU-22-654200
default['ubuntu2204STIG']['stigrule_260642']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260642']['Title'] = "Ubuntu 22.04 LTS must generate audit records for the /var/log/wtmp file."
default['ubuntu2204STIG']['stigrule_260642']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Regexp'] = '^-w /var/log/wtmp -p wa -k logins$'
default['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Line'] = '-w /var/log/wtmp -p wa -k logins'

# R-260643 UBTU-22-654205
default['ubuntu2204STIG']['stigrule_260643']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260643']['Title'] = "Ubuntu 22.04 LTS must generate audit records for the /var/run/utmp file."
default['ubuntu2204STIG']['stigrule_260643']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Regexp'] = '^-w /var/run/utmp -p wa -k logins$'
default['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Line'] = '-w /var/run/utmp -p wa -k logins'

# R-260644 UBTU-22-654210
default['ubuntu2204STIG']['stigrule_260644']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260644']['Title'] = "Ubuntu 22.04 LTS must generate audit records for the use and modification of faillog file."
default['ubuntu2204STIG']['stigrule_260644']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Regexp'] = '^-w /var/log/faillog -p wa -k logins$'
default['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Line'] = '-w /var/log/faillog -p wa -k logins'

# R-260645 UBTU-22-654215
default['ubuntu2204STIG']['stigrule_260645']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260645']['Title'] = "Ubuntu 22.04 LTS must generate audit records for the use and modification of the lastlog file."
default['ubuntu2204STIG']['stigrule_260645']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Regexp'] = '^-w /var/log/lastlog -p wa -k logins$'
default['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Line'] = '-w /var/log/lastlog -p wa -k logins'

# R-260646 UBTU-22-654220
default['ubuntu2204STIG']['stigrule_260646']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260646']['Title'] = "Ubuntu 22.04 LTS must generate audit records when successful/unsuccessful attempts to modify the /etc/sudoers file occur."
default['ubuntu2204STIG']['stigrule_260646']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Regexp'] = '^-w /etc/sudoers -p wa -k privilege_modification$'
default['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Line'] = '-w /etc/sudoers -p wa -k privilege_modification'

# R-260647 UBTU-22-654225
default['ubuntu2204STIG']['stigrule_260647']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260647']['Title'] = "Ubuntu 22.04 LTS must generate audit records when successful/unsuccessful attempts to modify the /etc/sudoers.d directory occur."
default['ubuntu2204STIG']['stigrule_260647']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Regexp'] = '^-w /etc/sudoers.d -p wa -k privilege_modification$'
default['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Line'] = '-w /etc/sudoers.d -p wa -k privilege_modification'

# R-260648 UBTU-22-654230
default['ubuntu2204STIG']['stigrule_260648']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260648']['Title'] = "Ubuntu 22.04 LTS must prevent all software from executing at higher privilege levels than users executing the software and the audit system must be configured to audit the execution of privileged functions."
default['ubuntu2204STIG']['stigrule_260648']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -F key=execpriv$'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Line'] = '-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -F key=execpriv'

default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C gid!=egid -F egid=0 -F key=execpriv$'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Line'] = '-a always,exit -F arch=b64 -S execve -C gid!=egid -F egid=0 -F key=execpriv'

default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -F key=execpriv$'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Line'] = '-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -F key=execpriv'

default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C gid!=egid -F egid=0 -F key=execpriv$'
default['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Line'] = '-a always,exit -F arch=b32 -S execve -C gid!=egid -F egid=0 -F key=execpriv'

# R-260649 UBTU-22-654235
default['ubuntu2204STIG']['stigrule_260649']['Manage'] = true
default['ubuntu2204STIG']['stigrule_260649']['Title'] = "Ubuntu 22.04 LTS must generate audit records for privileged activities, nonlocal maintenance, diagnostic sessions and other system-level access."
default['ubuntu2204STIG']['stigrule_260649']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Regexp'] = '^-w /var/log/sudo.log -p wa -k maintenance$'
default['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Line'] = '-w /var/log/sudo.log -p wa -k maintenance'

# R-274862 UBTU-22-654041
default['ubuntu2204STIG']['stigrule_274862']['Manage'] = true
default['ubuntu2204STIG']['stigrule_274862']['Title'] = "Ubuntu 22.04 LTS must audit any script or executable called by cron as root or by any privileged user."
default['ubuntu2204STIG']['stigrule_274862']['Severity'] = 'medium'
default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Regexp'] = '^-w /etc/cron.d/ -p wa -k cronjobs$'
default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Line'] = '-w /etc/cron.d/ -p wa -k cronjobs'

default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Regexp'] = '^-w /var/spool/cron/ -p wa -k cronjobs$'
default['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Line'] = '-w /var/spool/cron/ -p wa -k cronjobs'

