execute 'dconf_update' do
  command 'dconf update'
  action :nothing
end
service 'ssh_restart' do
  service_name 'sshd'
  action :nothing
end
execute 'auditd_restart' do
  command 'service auditd restart'
  action :nothing
end
if node['ubuntu2204STIG']['XCCDF_result']['Manage']
  cookbook_file "#{Chef::Config[:file_cache_path]}/stig_xml.rb" do
    source 'stig_xml.rb'
  end
  cookbook_file "#{Chef::Config[:file_cache_path]}/U_CAN_Ubuntu_22-04_LTS_STIG_V2R7_Manual-xccdf.xml" do
    source 'U_CAN_Ubuntu_22-04_LTS_STIG_V2R7_Manual-xccdf.xml'
  end
  chef_handler 'Chef::Handler::StigXml' do
    source "#{Chef::Config[:file_cache_path]}/stig_xml.rb"
    arguments :stigName => 'U_CAN_Ubuntu_22-04_LTS_STIG_V2R7_Manual-xccdf.xml'
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260473','Manage')
  service 'kdump_tools_disable_260473' do
    service_name node['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_disable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_disable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260473','Manage')
  service 'kdump_tools_mask_260473' do
    service_name node['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_mask_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260473']['Setting']['kdump_tools_mask_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260476','Manage')
  _etc_apt_apt_conf_d_01_vendor_ubuntu_Path = node['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Path']
  file _etc_apt_apt_conf_d_01_vendor_ubuntu_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_01_vendor_ubuntu_Path) }
  end
  file_line '_etc_apt_apt_conf_d_01_vendor_ubuntu_260476' do
    path _etc_apt_apt_conf_d_01_vendor_ubuntu_Path
    match node['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Regexp']
    line node['ubuntu2204STIG']['stigrule_260476']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260477','Manage')
  _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path = node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path']
  file _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path) }
  end
  file_line '_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_260477' do
    path _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path
    match node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Regexp']
    line node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260477','Manage')
  _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path = node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path']
  file _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path) }
  end
  file_line '_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_260477' do
    path _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path
    match node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Regexp']
    line node['ubuntu2204STIG']['stigrule_260477']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260482','Manage')
  apt_package 'rsh_server_260482' do
    package_name node['ubuntu2204STIG']['stigrule_260482']['Setting']['rsh_server_PackageName']
    action node['ubuntu2204STIG']['stigrule_260482']['Setting']['rsh_server_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260483','Manage')
  apt_package 'telnetd_260483' do
    package_name node['ubuntu2204STIG']['stigrule_260483']['Setting']['telnetd_PackageName']
    action node['ubuntu2204STIG']['stigrule_260483']['Setting']['telnetd_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260514','Manage')
  apt_package 'ufw_260514' do
    package_name node['ubuntu2204STIG']['stigrule_260514']['Setting']['ufw_PackageName']
    action node['ubuntu2204STIG']['stigrule_260514']['Setting']['ufw_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260516','Manage')
  service 'ufw_enable_260516' do
    service_name node['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_enable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_enable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260516','Manage')
  service 'ufw_start_260516' do
    service_name node['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_start_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260516']['Setting']['ufw_start_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260522','Manage')
  sysctl 'net_ipv4_tcp_syncookies_260522' do
    key node['ubuntu2204STIG']['stigrule_260522']['Setting']['net_ipv4_tcp_syncookies_Key']
    value node['ubuntu2204STIG']['stigrule_260522']['Setting']['net_ipv4_tcp_syncookies_Value']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260522','Manage')
  _etc_sysctl_conf_Path = node['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Path']
  file _etc_sysctl_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_sysctl_conf_Path) }
  end
  file_line '_etc_sysctl_conf_260522' do
    path _etc_sysctl_conf_Path
    match node['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260522']['Setting']['_etc_sysctl_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260523','Manage')
  apt_package 'ssh_260523' do
    package_name node['ubuntu2204STIG']['stigrule_260523']['Setting']['ssh_PackageName']
    action node['ubuntu2204STIG']['stigrule_260523']['Setting']['ssh_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260524','Manage')
  service 'sshd_active_260524' do
    service_name node['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_active_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_active_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260524','Manage')
  service 'sshd_start_260524' do
    service_name node['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_start_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260524']['Setting']['sshd_start_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260525','Manage')
  file_line 'banner_260525' do
    path node['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Path']
    match node['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Regexp']
    line node['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260525']['Setting']['banner_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260525','Manage')
  file '_etc_issue_net_260525' do
    path node['ubuntu2204STIG']['stigrule_260525']['Setting']['_etc_issue_net_Path']
    content node['ubuntu2204STIG']['stigrule_260525']['Setting']['_etc_issue_net_Content']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260526','Manage')
  file_line 'PermitEmptyPasswords_260526' do
    path node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Path']
    match node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Regexp']
    line node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitEmptyPasswords_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260526','Manage')
  file_line 'PermitUserEnvironment_260526' do
    path node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Path']
    match node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Regexp']
    line node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260526']['Setting']['PermitUserEnvironment_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260527','Manage')
  file_line 'ClientAliveCountMax_260527' do
    path node['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Path']
    match node['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Regexp']
    line node['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260527']['Setting']['ClientAliveCountMax_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260528','Manage')
  file_line 'ClientAliveInterval_260528' do
    path node['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Path']
    match node['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Regexp']
    line node['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260528']['Setting']['ClientAliveInterval_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260529','Manage')
  file_line 'X11Forwarding_260529' do
    path node['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Path']
    match node['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Regexp']
    line node['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260529']['Setting']['X11Forwarding_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260530','Manage')
  file_line 'X11UseLocalhost_260530' do
    path node['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Path']
    match node['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Regexp']
    line node['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260530']['Setting']['X11UseLocalhost_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260531','Manage')
  file_line 'Ciphers_260531' do
    path node['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Path']
    match node['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Regexp']
    line node['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260531']['Setting']['Ciphers_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260532','Manage')
  file_line 'MACs_260532' do
    path node['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Path']
    match node['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Regexp']
    line node['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260532']['Setting']['MACs_Only_if']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260535','Manage')
  _etc_gdm3_greeter_dconf_defaults_enable_Path = node['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Path']
  file _etc_gdm3_greeter_dconf_defaults_enable_Path do
    action :create
    not_if { ::File.exist?(_etc_gdm3_greeter_dconf_defaults_enable_Path) }
  end
  ini_setting '_etc_gdm3_greeter_dconf_defaults_enable_260535' do
    path _etc_gdm3_greeter_dconf_defaults_enable_Path
    section node['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Section']
    setting node['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Option']
    value node['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260535']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Only_if']
    separator '='
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260536','Manage')
  _etc_gdm3_greeter_dconf_defaults_text_Path = node['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Path']
  file _etc_gdm3_greeter_dconf_defaults_text_Path do
    action :create
    not_if { ::File.exist?(_etc_gdm3_greeter_dconf_defaults_text_Path) }
  end
  ini_setting '_etc_gdm3_greeter_dconf_defaults_text_260536' do
    path _etc_gdm3_greeter_dconf_defaults_text_Path
    section node['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Section']
    setting node['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Option']
    value node['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ubuntu2204STIG']['stigrule_260536']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Only_if']
    separator '='
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260545','Manage')
  _etc_login_defs_Path = node['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_260545' do
    path _etc_login_defs_Path
    match node['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2204STIG']['stigrule_260545']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260546','Manage')
  _etc_login_defs_Path = node['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_260546' do
    path _etc_login_defs_Path
    match node['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2204STIG']['stigrule_260546']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260552','Manage')
  _etc_security_limits_conf_Path = node['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Path']
  file _etc_security_limits_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_limits_conf_Path) }
  end
  file_line '_etc_security_limits_conf_260552' do
    path _etc_security_limits_conf_Path
    match node['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260552']['Setting']['_etc_security_limits_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260553','Manage')
  apt_package 'vlock_260553' do
    package_name node['ubuntu2204STIG']['stigrule_260553']['Setting']['vlock_PackageName']
    action node['ubuntu2204STIG']['stigrule_260553']['Setting']['vlock_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260554','Manage')
  file '_etc_profile_d_99_terminal_tmout_sh_260554' do
    path node['ubuntu2204STIG']['stigrule_260554']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Path']
    content node['ubuntu2204STIG']['stigrule_260554']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Content']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260555','Manage')
  _etc_login_defs_Path = node['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_260555' do
    path _etc_login_defs_Path
    match node['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2204STIG']['stigrule_260555']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260556','Manage')
  apt_package 'apparmor_260556' do
    package_name node['ubuntu2204STIG']['stigrule_260556']['Setting']['apparmor_PackageName']
    action node['ubuntu2204STIG']['stigrule_260556']['Setting']['apparmor_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260557','Manage')
  service 'apparmor_enable_260557' do
    service_name node['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_enable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_enable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260557','Manage')
  service 'apparmor_start_260557' do
    service_name node['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_start_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260557']['Setting']['apparmor_start_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260560','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260560' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260560']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260561','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260561' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260561']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260562','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260562' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260562']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260563','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260563' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260563']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260564','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260564' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260564']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260565','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260565' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260565']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260566','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_260566' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260566']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260572','Manage')
  _etc_login_defs_Path = node['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_260572' do
    path _etc_login_defs_Path
    match node['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2204STIG']['stigrule_260572']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260573','Manage')
  apt_package 'libpam_pkcs11_260573' do
    package_name node['ubuntu2204STIG']['stigrule_260573']['Setting']['libpam_pkcs11_PackageName']
    action node['ubuntu2204STIG']['stigrule_260573']['Setting']['libpam_pkcs11_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260574','Manage')
  apt_package 'opensc_pkcs11_260574' do
    package_name node['ubuntu2204STIG']['stigrule_260574']['Setting']['opensc_pkcs11_PackageName']
    action node['ubuntu2204STIG']['stigrule_260574']['Setting']['opensc_pkcs11_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260588','Manage')
  apt_package 'rsyslog_260588' do
    package_name node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_PackageName']
    action node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260588','Manage')
  service 'rsyslog_enable_260588' do
    service_name node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_enable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_enable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260588','Manage')
  service 'rsyslog_start_260588' do
    service_name node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_start_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260588']['Setting']['rsyslog_start_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260590','Manage')
  apt_package 'auditd_260590' do
    package_name node['ubuntu2204STIG']['stigrule_260590']['Setting']['auditd_PackageName']
    action node['ubuntu2204STIG']['stigrule_260590']['Setting']['auditd_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260591','Manage')
  service 'auditd_enable_260591' do
    service_name node['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260591','Manage')
  service 'auditd_enable_260591' do
    service_name node['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_ServiceName']
    action node['ubuntu2204STIG']['stigrule_260591']['Setting']['auditd_enable_Action']
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260593','Manage')
# Change root to an account for security personnel.
  _etc_audit_auditd_conf_Path = node['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_260593' do
    path _etc_audit_auditd_conf_Path
    match node['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260593']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260594','Manage')
  _etc_audit_auditd_conf_Path = node['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_260594' do
    path _etc_audit_auditd_conf_Path
    match node['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ubuntu2204STIG']['stigrule_260594']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260604','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_260604' do
    path node['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Path']
    match node['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Regexp']
    line node['ubuntu2204STIG']['stigrule_260604']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260605','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chacl_260605' do
    path node['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Path']
    match node['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Regexp']
    line node['ubuntu2204STIG']['stigrule_260605']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260606','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chage_260606' do
    path node['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Path']
    match node['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Regexp']
    line node['ubuntu2204STIG']['stigrule_260606']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260607','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chcon_260607' do
    path node['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Path']
    match node['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Regexp']
    line node['ubuntu2204STIG']['stigrule_260607']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260608','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chfn_260608' do
    path node['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Path']
    match node['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Regexp']
    line node['ubuntu2204STIG']['stigrule_260608']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260609','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chsh_260609' do
    path node['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Path']
    match node['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Regexp']
    line node['ubuntu2204STIG']['stigrule_260609']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260610','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_crontab_260610' do
    path node['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Path']
    match node['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Regexp']
    line node['ubuntu2204STIG']['stigrule_260610']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260611','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_260611' do
    path node['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Path']
    match node['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Regexp']
    line node['ubuntu2204STIG']['stigrule_260611']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260612','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_260612' do
    path node['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Path']
    match node['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Regexp']
    line node['ubuntu2204STIG']['stigrule_260612']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260613','Manage')
  file_line '_etc_audit_rules_d_stig_rules__bin_kmod_260613' do
    path node['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Path']
    match node['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Regexp']
    line node['ubuntu2204STIG']['stigrule_260613']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260614','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_modprobe_260614' do
    path node['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Path']
    match node['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Regexp']
    line node['ubuntu2204STIG']['stigrule_260614']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260615','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_mount_260615' do
    path node['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Path']
    match node['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Regexp']
    line node['ubuntu2204STIG']['stigrule_260615']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260616','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_newgrp_260616' do
    path node['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Path']
    match node['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Regexp']
    line node['ubuntu2204STIG']['stigrule_260616']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260617','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_260617' do
    path node['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Path']
    match node['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Regexp']
    line node['ubuntu2204STIG']['stigrule_260617']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260618','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_passwd_260618' do
    path node['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Path']
    match node['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Regexp']
    line node['ubuntu2204STIG']['stigrule_260618']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260619','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_setfacl_260619' do
    path node['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Path']
    match node['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Regexp']
    line node['ubuntu2204STIG']['stigrule_260619']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260620','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_260620' do
    path node['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Path']
    match node['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Regexp']
    line node['ubuntu2204STIG']['stigrule_260620']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260621','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_260621' do
    path node['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Path']
    match node['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Regexp']
    line node['ubuntu2204STIG']['stigrule_260621']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260622','Manage')
  file_line '_etc_audit_rules_d_stig_rules__bin_su_260622' do
    path node['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Path']
    match node['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Regexp']
    line node['ubuntu2204STIG']['stigrule_260622']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260623','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_sudo_260623' do
    path node['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Path']
    match node['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Regexp']
    line node['ubuntu2204STIG']['stigrule_260623']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260624','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_260624' do
    path node['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Path']
    match node['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Regexp']
    line node['ubuntu2204STIG']['stigrule_260624']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260625','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_umount_260625' do
    path node['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Path']
    match node['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Regexp']
    line node['ubuntu2204STIG']['stigrule_260625']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260626','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_unix_update_260626' do
    path node['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Path']
    match node['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Regexp']
    line node['ubuntu2204STIG']['stigrule_260626']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260627','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_usermod_260627' do
    path node['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Path']
    match node['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Regexp']
    line node['ubuntu2204STIG']['stigrule_260627']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260628','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_group_260628' do
    path node['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Path']
    match node['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Regexp']
    line node['ubuntu2204STIG']['stigrule_260628']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260629','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_gshadow_260629' do
    path node['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Path']
    match node['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Regexp']
    line node['ubuntu2204STIG']['stigrule_260629']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260630','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_security_opasswd_260630' do
    path node['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Path']
    match node['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Regexp']
    line node['ubuntu2204STIG']['stigrule_260630']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260631','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_passwd_260631' do
    path node['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Path']
    match node['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Regexp']
    line node['ubuntu2204STIG']['stigrule_260631']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260632','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_shadow_260632' do
    path node['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Path']
    match node['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Regexp']
    line node['ubuntu2204STIG']['stigrule_260632']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260633','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_260633' do
    path node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Path']
    match node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Regexp']
    line node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260633','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_260633' do
    path node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Path']
    match node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Regexp']
    line node['ubuntu2204STIG']['stigrule_260633']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260634','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_260634' do
    path node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Path']
    match node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Regexp']
    line node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260634','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_260634' do
    path node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Path']
    match node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Regexp']
    line node['ubuntu2204STIG']['stigrule_260634']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260635','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_260635' do
    path node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Path']
    match node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Regexp']
    line node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260635','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_260635' do
    path node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Path']
    match node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Regexp']
    line node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260635','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_260635' do
    path node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Path']
    match node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Regexp']
    line node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260635','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_260635' do
    path node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Path']
    match node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Regexp']
    line node['ubuntu2204STIG']['stigrule_260635']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260636','Manage')
  file_line '_etc_audit_rules_d_stig_rules_delete_module_b32_260636' do
    path node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Path']
    match node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Regexp']
    line node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260636','Manage')
  file_line '_etc_audit_rules_d_stig_rules_delete_module_b64_260636' do
    path node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Path']
    match node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Regexp']
    line node['ubuntu2204STIG']['stigrule_260636']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260637','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_260637' do
    path node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Path']
    match node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Regexp']
    line node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260637','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_260637' do
    path node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Path']
    match node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Regexp']
    line node['ubuntu2204STIG']['stigrule_260637']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260638','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_260638' do
    path node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path']
    match node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp']
    line node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260638','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_260638' do
    path node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path']
    match node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp']
    line node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260638','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_260638' do
    path node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path']
    match node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp']
    line node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260638','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_260638' do
    path node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path']
    match node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp']
    line node['ubuntu2204STIG']['stigrule_260638']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260639','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_260639' do
    path node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Path']
    match node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Regexp']
    line node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260639','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_260639' do
    path node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Path']
    match node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Regexp']
    line node['ubuntu2204STIG']['stigrule_260639']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260640','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_journal_260640' do
    path node['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Path']
    match node['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Regexp']
    line node['ubuntu2204STIG']['stigrule_260640']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260641','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_btmp_260641' do
    path node['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Path']
    match node['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Regexp']
    line node['ubuntu2204STIG']['stigrule_260641']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260642','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_wtmp_260642' do
    path node['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Path']
    match node['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Regexp']
    line node['ubuntu2204STIG']['stigrule_260642']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260643','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_run_utmp_260643' do
    path node['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Path']
    match node['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Regexp']
    line node['ubuntu2204STIG']['stigrule_260643']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260644','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_faillog_260644' do
    path node['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Path']
    match node['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Regexp']
    line node['ubuntu2204STIG']['stigrule_260644']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260645','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_lastlog_260645' do
    path node['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Path']
    match node['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Regexp']
    line node['ubuntu2204STIG']['stigrule_260645']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260646','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_sudoers_260646' do
    path node['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Path']
    match node['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Regexp']
    line node['ubuntu2204STIG']['stigrule_260646']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260647','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_sudoers_d_260647' do
    path node['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Path']
    match node['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Regexp']
    line node['ubuntu2204STIG']['stigrule_260647']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260648','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b64_euid_260648' do
    path node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Path']
    match node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Regexp']
    line node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260648','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b64_egid_260648' do
    path node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Path']
    match node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Regexp']
    line node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260648','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b32_euid_260648' do
    path node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Path']
    match node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Regexp']
    line node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260648','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b32_egid_260648' do
    path node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Path']
    match node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Regexp']
    line node['ubuntu2204STIG']['stigrule_260648']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_260649','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_sudo_log_260649' do
    path node['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Path']
    match node['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Regexp']
    line node['ubuntu2204STIG']['stigrule_260649']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_274862','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_274862' do
    path node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Path']
    match node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Regexp']
    line node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2204STIG','stigrule_274862','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_274862' do
    path node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Path']
    match node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Regexp']
    line node['ubuntu2204STIG']['stigrule_274862']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
