execute 'dconf_update' do
  command 'dconf update'
  action :nothing
end
service 'ssh_restart' do
  service_name 'sshd'
  action :nothing
end
execute 'auditd_restart' do
  command 'service auditd restart'
  action :nothing
end
directory '/etc/dconf/db/local.d' do
  action :create
end
file '/etc/dconf/db/local.d/00-screensaver' do
  action :create_if_missing
end
directory '/etc/dconf/db/local.d/locks' do
  action :create
end
file '/etc/dconf/db/local.d/locks/00-security-settings-lock' do
  action :create_if_missing
end
if node['ubuntu2404STIG']['XCCDF_result']['Manage']
  cookbook_file "#{Chef::Config[:file_cache_path]}/stig_xml.rb" do
    source 'stig_xml.rb'
  end
  cookbook_file "#{Chef::Config[:file_cache_path]}/U_CAN_Ubuntu_24-04_LTS_STIG_V1R3_Manual-xccdf.xml" do
    source 'U_CAN_Ubuntu_24-04_LTS_STIG_V1R3_Manual-xccdf.xml'
  end
  chef_handler 'Chef::Handler::StigXml' do
    source "#{Chef::Config[:file_cache_path]}/stig_xml.rb"
    arguments :stigName => 'U_CAN_Ubuntu_24-04_LTS_STIG_V1R3_Manual-xccdf.xml'
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270645','Manage')
  apt_package 'systemd_timesyncd_270645' do
    package_name node['ubuntu2404STIG']['stigrule_270645']['Setting']['systemd_timesyncd_PackageName']
    action :purge
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270646','Manage')
  apt_package 'ntp_270646' do
    package_name node['ubuntu2404STIG']['stigrule_270646']['Setting']['ntp_PackageName']
    action :purge
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270647','Manage')
  apt_package 'telnet_270647' do
    package_name node['ubuntu2404STIG']['stigrule_270647']['Setting']['telnet_PackageName']
    action node['ubuntu2404STIG']['stigrule_270647']['Setting']['telnet_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270648','Manage')
  apt_package 'rsh_server_270648' do
    package_name node['ubuntu2404STIG']['stigrule_270648']['Setting']['rsh_server_PackageName']
    action node['ubuntu2404STIG']['stigrule_270648']['Setting']['rsh_server_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270649','Manage')
  apt_package 'aide_270649' do
    package_name node['ubuntu2404STIG']['stigrule_270649']['Setting']['aide_PackageName']
    action node['ubuntu2404STIG']['stigrule_270649']['Setting']['aide_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270653','Manage')
  apt_package 'rsyslog_270653' do
    package_name node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_PackageName']
    action node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270653','Manage')
  service 'rsyslog_enable_270653' do
    service_name node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270653','Manage')
  service 'rsyslog_start_270653' do
    service_name node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_start_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_start_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270654','Manage')
  apt_package 'ufw_270654' do
    package_name node['ubuntu2404STIG']['stigrule_270654']['Setting']['ufw_PackageName']
    action node['ubuntu2404STIG']['stigrule_270654']['Setting']['ufw_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270656','Manage')
  apt_package 'auditd_270656' do
    package_name node['ubuntu2404STIG']['stigrule_270656']['Setting']['auditd_PackageName']
    action node['ubuntu2404STIG']['stigrule_270656']['Setting']['auditd_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270657','Manage')
  service 'auditd_enable_270657' do
    service_name node['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270657','Manage')
  service 'auditd_enable_270657' do
    service_name node['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270659','Manage')
  apt_package 'apparmor_270659' do
    package_name node['ubuntu2404STIG']['stigrule_270659']['Setting']['apparmor_PackageName']
    action node['ubuntu2404STIG']['stigrule_270659']['Setting']['apparmor_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270660','Manage')
  service 'apparmor_enable_270660' do
    service_name node['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270660','Manage')
  service 'apparmor_start_270660' do
    service_name node['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_start_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_start_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270661','Manage')
  apt_package 'libpam_pwquality_270661' do
    package_name node['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_pwquality_PackageName']
    action node['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_pwquality_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270661','Manage')
  apt_package 'sssd_270661' do
    package_name node['ubuntu2404STIG']['stigrule_270661']['Setting']['sssd_PackageName']
    action node['ubuntu2404STIG']['stigrule_270661']['Setting']['sssd_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270661','Manage')
  apt_package 'libpam_sss_270661' do
    package_name node['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_sss_PackageName']
    action node['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_sss_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270661','Manage')
  apt_package 'libnss_sss_270661' do
    package_name node['ubuntu2404STIG']['stigrule_270661']['Setting']['libnss_sss_PackageName']
    action node['ubuntu2404STIG']['stigrule_270661']['Setting']['libnss_sss_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270663','Manage')
  service 'sssd_enable_270663' do
    service_name node['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270663','Manage')
  service 'sssd_enable_270663' do
    service_name node['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270664','Manage')
  apt_package 'chrony_270664' do
    package_name node['ubuntu2404STIG']['stigrule_270664']['Setting']['chrony_PackageName']
    action node['ubuntu2404STIG']['stigrule_270664']['Setting']['chrony_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270665','Manage')
  apt_package 'ssh_270665' do
    package_name node['ubuntu2404STIG']['stigrule_270665']['Setting']['ssh_PackageName']
    action node['ubuntu2404STIG']['stigrule_270665']['Setting']['ssh_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270666','Manage')
  service 'ssh_active_270666' do
    service_name node['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_active_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_active_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270666','Manage')
  service 'ssh_start_270666' do
    service_name node['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_start_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_start_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270667','Manage')
  file_line 'Ciphers_270667' do
    path node['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Path']
    match node['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Regexp']
    line node['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270668','Manage')
  file_line 'MACs_270668' do
    path node['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Path']
    match node['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270669','Manage')
  file_line 'KexAlgorithms_270669' do
    path node['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Path']
    match node['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Regexp']
    line node['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270670','Manage')
  file_line 'Ciphers_270670' do
    path node['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Path']
    match node['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Regexp']
    line node['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270671','Manage')
  file_line 'MACs_270671' do
    path node['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Path']
    match node['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270672','Manage')
  apt_package 'opensc_pkcs11_270672' do
    package_name node['ubuntu2404STIG']['stigrule_270672']['Setting']['opensc_pkcs11_PackageName']
    action node['ubuntu2404STIG']['stigrule_270672']['Setting']['opensc_pkcs11_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270673','Manage')
  apt_package 'libpam_pkcs11_270673' do
    package_name node['ubuntu2404STIG']['stigrule_270673']['Setting']['libpam_pkcs11_PackageName']
    action node['ubuntu2404STIG']['stigrule_270673']['Setting']['libpam_pkcs11_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270674','Manage')
  apt_package 'vlock_270674' do
    package_name node['ubuntu2404STIG']['stigrule_270674']['Setting']['vlock_PackageName']
    action node['ubuntu2404STIG']['stigrule_270674']['Setting']['vlock_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270677','Manage')
  _etc_security_limits_conf_Path = node['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Path']
  file _etc_security_limits_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_limits_conf_Path) }
  end
  file_line '_etc_security_limits_conf_270677' do
    path _etc_security_limits_conf_Path
    match node['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270678','Manage')
  _etc_dconf_db_local_d_00_screensaver_idle_delay_Path = node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Path']
  file _etc_dconf_db_local_d_00_screensaver_idle_delay_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_idle_delay_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_idle_delay_270678' do
    path _etc_dconf_db_local_d_00_screensaver_idle_delay_Path
    section node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Section']
    setting node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Option']
    value node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270678','Manage')
  _etc_dconf_db_local_d_00_screensaver_lock_enabled_Path = node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Path']
  file _etc_dconf_db_local_d_00_screensaver_lock_enabled_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_lock_enabled_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_lock_enabled_270678' do
    path _etc_dconf_db_local_d_00_screensaver_lock_enabled_Path
    section node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Section']
    setting node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Option']
    value node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270678','Manage')
  _etc_dconf_db_local_d_00_screensaver_lock_delay_Path = node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Path']
  file _etc_dconf_db_local_d_00_screensaver_lock_delay_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_lock_delay_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_lock_delay_270678' do
    path _etc_dconf_db_local_d_00_screensaver_lock_delay_Path
    section node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Section']
    setting node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Option']
    value node['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270679','Manage')
  _etc_dconf_db_local_d_locks_00_security_settings_lock_Path = node['ubuntu2404STIG']['stigrule_270679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_Path']
  file _etc_dconf_db_local_d_locks_00_security_settings_lock_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_00_security_settings_lock_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_00_security_settings_lock_270679' do
    path _etc_dconf_db_local_d_locks_00_security_settings_lock_Path
    line node['ubuntu2404STIG']['stigrule_270679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270680','Manage')
  file '_etc_profile_d_99_terminal_tmout_sh_270680' do
    path node['ubuntu2404STIG']['stigrule_270680']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Path']
    content node['ubuntu2404STIG']['stigrule_270680']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Content']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270684','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_passwd_270684' do
    path node['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Path']
    match node['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Regexp']
    line node['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270685','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_group_270685' do
    path node['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Path']
    match node['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Regexp']
    line node['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270686','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_shadow_270686' do
    path node['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Path']
    match node['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Regexp']
    line node['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270687','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_gshadow_270687' do
    path node['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Path']
    match node['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Regexp']
    line node['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270688','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_security_opasswd_270688' do
    path node['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Path']
    match node['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Regexp']
    line node['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270689','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b64_euid_270689' do
    path node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Path']
    match node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Regexp']
    line node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270689','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b64_egid_270689' do
    path node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Path']
    match node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Regexp']
    line node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270689','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b32_euid_270689' do
    path node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Path']
    match node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Regexp']
    line node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270689','Manage')
  file_line '_etc_audit_rules_d_stig_rules_execve_b32_egid_270689' do
    path node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Path']
    match node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Regexp']
    line node['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270691','Manage')
  file_line 'banner_270691' do
    path node['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Path']
    match node['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Regexp']
    line node['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270691','Manage')
  file '_etc_issue_net_270691' do
    path node['ubuntu2404STIG']['stigrule_270691']['Setting']['_etc_issue_net_Path']
    content node['ubuntu2404STIG']['stigrule_270691']['Setting']['_etc_issue_net_Content']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270692','Manage')
  _etc_gdm3_greeter_dconf_defaults_enable_Path = node['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Path']
  file _etc_gdm3_greeter_dconf_defaults_enable_Path do
    action :create
    not_if { ::File.exist?(_etc_gdm3_greeter_dconf_defaults_enable_Path) }
  end
  ini_setting '_etc_gdm3_greeter_dconf_defaults_enable_270692' do
    path _etc_gdm3_greeter_dconf_defaults_enable_Path
    section node['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Section']
    setting node['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Option']
    value node['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Only_if']
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270693','Manage')
  _etc_gdm3_greeter_dconf_defaults_text_Path = node['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Path']
  file _etc_gdm3_greeter_dconf_defaults_text_Path do
    action :create
    not_if { ::File.exist?(_etc_gdm3_greeter_dconf_defaults_text_Path) }
  end
  ini_setting '_etc_gdm3_greeter_dconf_defaults_text_270693' do
    path _etc_gdm3_greeter_dconf_defaults_text_Path
    section node['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Section']
    setting node['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Option']
    value node['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Only_if']
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270695','Manage')
  _etc_apt_apt_conf_d_01_vendor_ubuntu_Path = node['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Path']
  file _etc_apt_apt_conf_d_01_vendor_ubuntu_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_01_vendor_ubuntu_Path) }
  end
  file_line '_etc_apt_apt_conf_d_01_vendor_ubuntu_270695' do
    path _etc_apt_apt_conf_d_01_vendor_ubuntu_Path
    match node['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Regexp']
    line node['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270704','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270704' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270708','Manage')
  file_line 'X11Forwarding_270708' do
    path node['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Path']
    match node['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Regexp']
    line node['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270709','Manage')
  file_line 'X11UseLocalhost_270709' do
    path node['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Path']
    match node['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Regexp']
    line node['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270711','Manage')
  _etc_dconf_db_local_d_00_screensaver_media_keys_Path = node['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Path']
  file _etc_dconf_db_local_d_00_screensaver_media_keys_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_media_keys_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_media_keys_270711' do
    path _etc_dconf_db_local_d_00_screensaver_media_keys_Path
    section node['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Section']
    setting node['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Option']
    value node['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    separator '='
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270712','Manage')
  systemd_unit 'ctrl_alt_del_target_disable_270712' do
    unit_name node['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_disable_UnitName']
    action node['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_disable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270712','Manage')
  systemd_unit 'ctrl_alt_del_target_mask_270712' do
    unit_name node['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_mask_UnitName']
    action node['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_mask_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270715','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_journal_270715' do
    path node['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Path']
    match node['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Regexp']
    line node['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270716','Manage')
  _etc_login_defs_Path = node['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_270716' do
    path _etc_login_defs_Path
    match node['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270717','Manage')
  file_line 'PermitEmptyPasswords_270717' do
    path node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Path']
    match node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Regexp']
    line node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270717','Manage')
  file_line 'PermitUserEnvironment_270717' do
    path node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Path']
    match node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Regexp']
    line node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270718','Manage')
  _etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path = node['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path']
  file _etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path) }
  end
  file_line '_etc_modprobe_d_DISASTIG_conf_install_usb_storage_270718' do
    path _etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path
    line node['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_install_usb_storage_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270718','Manage')
  _etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path = node['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path']
  file _etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path) }
  end
  file_line '_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_270718' do
    path _etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path
    line node['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270722','Manage')
  file_line 'PubkeyAuthentication_270722' do
    path node['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Path']
    match node['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Regexp']
    line node['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270726','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270726' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270727','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270727' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270728','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270728' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270729','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270729' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270730','Manage')
  _etc_login_defs_Path = node['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_270730' do
    path _etc_login_defs_Path
    match node['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270731','Manage')
  _etc_login_defs_Path = node['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_270731' do
    path _etc_login_defs_Path
    match node['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270732','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270732' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270733','Manage')
  _etc_security_pwquality_conf_Path = node['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_270733' do
    path _etc_security_pwquality_conf_Path
    match node['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270736','Manage')
  _etc_sssd_sssd_conf_Path = node['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Path']
  file _etc_sssd_sssd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_sssd_sssd_conf_Path) }
  end
  file_line '_etc_sssd_sssd_conf_270736' do
    path _etc_sssd_sssd_conf_Path
    match node['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270739','Manage')
  _etc_login_defs_Path = node['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_270739' do
    path _etc_login_defs_Path
    match node['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Regexp']
    line node['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270740','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_sudo_log_270740' do
    path node['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Path']
    match node['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Regexp']
    line node['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270741','Manage')
  file_line 'UsePAM_270741' do
    path node['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Path']
    match node['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Regexp']
    line node['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270742','Manage')
  file_line 'ClientAliveCountMax_270742' do
    path node['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Path']
    match node['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Regexp']
    line node['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270743','Manage')
  file_line 'ClientAliveInterval_270743' do
    path node['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Path']
    match node['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Regexp']
    line node['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Only_if']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270746','Manage')
  service 'kdump_tools_disable_270746' do
    service_name node['ubuntu2404STIG']['stigrule_270746']['Setting']['kdump_tools_disable_ServiceName']
    action node['ubuntu2404STIG']['stigrule_270746']['Setting']['kdump_tools_disable_Action']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270753','Manage')
  sysctl 'net_ipv4_tcp_syncookies_270753' do
    key node['ubuntu2404STIG']['stigrule_270753']['Setting']['net_ipv4_tcp_syncookies_Key']
    value node['ubuntu2404STIG']['stigrule_270753']['Setting']['net_ipv4_tcp_syncookies_Value']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270753','Manage')
  _etc_sysctl_conf_Path = node['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Path']
  file _etc_sysctl_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_sysctl_conf_Path) }
  end
  file_line '_etc_sysctl_conf_270753' do
    path _etc_sysctl_conf_Path
    match node['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Regexp']
    line node['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270773','Manage')
  _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path = node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path']
  file _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path) }
  end
  file_line '_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_270773' do
    path _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path
    match node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Regexp']
    line node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270773','Manage')
  _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path = node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path']
  file _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path do
    action :create
    not_if { ::File.exist?(_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path) }
  end
  file_line '_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_270773' do
    path _etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path
    match node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Regexp']
    line node['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Line']
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270778','Manage')
  file_line '_etc_audit_rules_d_stig_rules__bin_su_270778' do
    path node['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Path']
    match node['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Regexp']
    line node['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270779','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chfn_270779' do
    path node['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Path']
    match node['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Regexp']
    line node['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270780','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_mount_270780' do
    path node['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Path']
    match node['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Regexp']
    line node['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270781','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_umount_270781' do
    path node['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Path']
    match node['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Regexp']
    line node['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270782','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_270782' do
    path node['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Path']
    match node['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Regexp']
    line node['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270783','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_270783' do
    path node['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Path']
    match node['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Regexp']
    line node['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270784','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_270784' do
    path node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path']
    match node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp']
    line node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270784','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_270784' do
    path node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path']
    match node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp']
    line node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270784','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_270784' do
    path node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path']
    match node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp']
    line node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270784','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_270784' do
    path node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path']
    match node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp']
    line node['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270785','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_270785' do
    path node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Path']
    match node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Regexp']
    line node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270785','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_270785' do
    path node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Path']
    match node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Regexp']
    line node['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270786','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_270786' do
    path node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Path']
    match node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Regexp']
    line node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270786','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_270786' do
    path node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Path']
    match node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Regexp']
    line node['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270787','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_270787' do
    path node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Path']
    match node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Regexp']
    line node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270787','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_270787' do
    path node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Path']
    match node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Regexp']
    line node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270787','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_270787' do
    path node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Path']
    match node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Regexp']
    line node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270787','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_270787' do
    path node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Path']
    match node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Regexp']
    line node['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270788','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_sudo_270788' do
    path node['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Path']
    match node['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Regexp']
    line node['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270789','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_270789' do
    path node['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Path']
    match node['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Regexp']
    line node['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270790','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chsh_270790' do
    path node['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Path']
    match node['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Regexp']
    line node['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270791','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_newgrp_270791' do
    path node['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Path']
    match node['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Regexp']
    line node['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270792','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chcon_270792' do
    path node['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Path']
    match node['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Regexp']
    line node['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270793','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_270793' do
    path node['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Path']
    match node['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Regexp']
    line node['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270794','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_setfacl_270794' do
    path node['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Path']
    match node['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Regexp']
    line node['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270795','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chacl_270795' do
    path node['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Path']
    match node['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Regexp']
    line node['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270796','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_faillog_270796' do
    path node['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Path']
    match node['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Regexp']
    line node['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270797','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_lastlog_270797' do
    path node['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Path']
    match node['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Regexp']
    line node['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270798','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_passwd_270798' do
    path node['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Path']
    match node['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Regexp']
    line node['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270799','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_unix_update_270799' do
    path node['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Path']
    match node['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Regexp']
    line node['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270800','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_270800' do
    path node['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Path']
    match node['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Regexp']
    line node['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270801','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_chage_270801' do
    path node['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Path']
    match node['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Regexp']
    line node['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270802','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_usermod_270802' do
    path node['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Path']
    match node['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Regexp']
    line node['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270803','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_bin_crontab_270803' do
    path node['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Path']
    match node['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Regexp']
    line node['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270804','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_270804' do
    path node['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Path']
    match node['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Regexp']
    line node['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270805','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_270805' do
    path node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Path']
    match node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Regexp']
    line node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270805','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_270805' do
    path node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Path']
    match node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Regexp']
    line node['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270806','Manage')
  file_line '_etc_audit_rules_d_stig_rules_delete_module_b32_270806' do
    path node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Path']
    match node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Regexp']
    line node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270806','Manage')
  file_line '_etc_audit_rules_d_stig_rules_delete_module_b64_270806' do
    path node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Path']
    match node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Regexp']
    line node['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270807','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_sudoers_270807' do
    path node['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Path']
    match node['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Regexp']
    line node['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270808','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_sudoers_d_270808' do
    path node['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Path']
    match node['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Regexp']
    line node['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270809','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_270809' do
    path node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Path']
    match node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Regexp']
    line node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270809','Manage')
  file_line '_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_270809' do
    path node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Path']
    match node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Regexp']
    line node['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270810','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_wtmp_270810' do
    path node['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Path']
    match node['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Regexp']
    line node['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270811','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_run_utmp_270811' do
    path node['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Path']
    match node['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Regexp']
    line node['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270812','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_log_btmp_270812' do
    path node['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Path']
    match node['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Regexp']
    line node['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270813','Manage')
  file_line '_etc_audit_rules_d_stig_rules__sbin_modprobe_270813' do
    path node['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Path']
    match node['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Regexp']
    line node['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270814','Manage')
  file_line '_etc_audit_rules_d_stig_rules__bin_kmod_270814' do
    path node['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Path']
    match node['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Regexp']
    line node['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270815','Manage')
  file_line '_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_270815' do
    path node['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Path']
    match node['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Regexp']
    line node['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_270832','Manage')
  file_line '_etc_audit_rules_d_audit_rules_e2_270832' do
    path node['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Path']
    match node['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Regexp']
    line node['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_274870','Manage')
  file_line '_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_274870' do
    path node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Path']
    match node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Regexp']
    line node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node.exist?('ubuntu2404STIG','stigrule_274870','Manage')
  file_line '_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_274870' do
    path node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Path']
    match node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Regexp']
    line node['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
