default['ubuntu2404STIG']['XCCDF_result']['Manage'] = true

# R-270645 UBTU-24-100010
default['ubuntu2404STIG']['stigrule_270645']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270645']['Title'] = "Ubuntu 24.04 LTS must not have the \"systemd-timesyncd\" package installed."
default['ubuntu2404STIG']['stigrule_270645']['Severity'] = 'low'
default['ubuntu2404STIG']['stigrule_270645']['Setting']['systemd_timesyncd_PackageName'] = 'systemd-timesyncd'
default['ubuntu2404STIG']['stigrule_270645']['Setting']['systemd_timesyncd_Action'] = :remove

# R-270646 UBTU-24-100020
default['ubuntu2404STIG']['stigrule_270646']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270646']['Title'] = "Ubuntu 24.04 LTS must not have the \"ntp\" package installed."
default['ubuntu2404STIG']['stigrule_270646']['Severity'] = 'low'
default['ubuntu2404STIG']['stigrule_270646']['Setting']['ntp_PackageName'] = 'ntp'
default['ubuntu2404STIG']['stigrule_270646']['Setting']['ntp_Action'] = :remove

# R-270647 UBTU-24-100030
default['ubuntu2404STIG']['stigrule_270647']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270647']['Title'] = "Ubuntu 24.04 LTS must not have the telnet package installed."
default['ubuntu2404STIG']['stigrule_270647']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270647']['Setting']['telnet_PackageName'] = 'telnet'
default['ubuntu2404STIG']['stigrule_270647']['Setting']['telnet_Action'] = :remove

# R-270648 UBTU-24-100040
default['ubuntu2404STIG']['stigrule_270648']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270648']['Title'] = "Ubuntu 24.04 LTS must not have the rsh-server package installed."
default['ubuntu2404STIG']['stigrule_270648']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270648']['Setting']['rsh_server_PackageName'] = 'rsh-server'
default['ubuntu2404STIG']['stigrule_270648']['Setting']['rsh_server_Action'] = :remove

# R-270649 UBTU-24-100100
default['ubuntu2404STIG']['stigrule_270649']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270649']['Title'] = "Ubuntu 24.04 LTS must use a file integrity tool to verify correct operation of all security functions."
default['ubuntu2404STIG']['stigrule_270649']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270649']['Setting']['aide_PackageName'] = 'aide'
default['ubuntu2404STIG']['stigrule_270649']['Setting']['aide_Action'] = :install

# R-270653 UBTU-24-100200
default['ubuntu2404STIG']['stigrule_270653']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270653']['Title'] = "Ubuntu 24.04 LTS must be configured to preserve log records from failure events."
default['ubuntu2404STIG']['stigrule_270653']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_PackageName'] = 'rsyslog'
default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_Action'] = :install

default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_enable_ServiceName'] = 'rsyslog'
default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_enable_Action'] = :enable

default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_start_ServiceName'] = 'rsyslog'
default['ubuntu2404STIG']['stigrule_270653']['Setting']['rsyslog_start_Action'] = :start

# R-270654 UBTU-24-100300
default['ubuntu2404STIG']['stigrule_270654']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270654']['Title'] = "Ubuntu 24.04 LTS must have an application firewall installed in order to control remote access methods."
default['ubuntu2404STIG']['stigrule_270654']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270654']['Setting']['ufw_PackageName'] = 'ufw'
default['ubuntu2404STIG']['stigrule_270654']['Setting']['ufw_Action'] = :install

# R-270656 UBTU-24-100400
default['ubuntu2404STIG']['stigrule_270656']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270656']['Title'] = "Ubuntu 24.04 LTS must have the \"auditd\" package installed."
default['ubuntu2404STIG']['stigrule_270656']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270656']['Setting']['auditd_PackageName'] = 'auditd'
default['ubuntu2404STIG']['stigrule_270656']['Setting']['auditd_Action'] = :install

# R-270657 UBTU-24-100410
default['ubuntu2404STIG']['stigrule_270657']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270657']['Title'] = "Ubuntu 24.04 LTS must produce audit records and reports containing information to establish when, where, what type, the source, and the outcome for all DOD-defined auditable events and actions in near real time."
default['ubuntu2404STIG']['stigrule_270657']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_ServiceName'] = 'auditd'
default['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_Action'] = :enable

default['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_ServiceName'] = 'auditd'
default['ubuntu2404STIG']['stigrule_270657']['Setting']['auditd_enable_Action'] = :start

# R-270659 UBTU-24-100500
default['ubuntu2404STIG']['stigrule_270659']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270659']['Title'] = "Ubuntu 24.04 LTS must have AppArmor installed."
default['ubuntu2404STIG']['stigrule_270659']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270659']['Setting']['apparmor_PackageName'] = 'apparmor'
default['ubuntu2404STIG']['stigrule_270659']['Setting']['apparmor_Action'] = :install

# R-270660 UBTU-24-100510
default['ubuntu2404STIG']['stigrule_270660']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270660']['Title'] = "Ubuntu 24.04 LTS must be configured to use AppArmor."
default['ubuntu2404STIG']['stigrule_270660']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_enable_ServiceName'] = 'apparmor'
default['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_enable_Action'] = :enable

default['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_start_ServiceName'] = 'apparmor'
default['ubuntu2404STIG']['stigrule_270660']['Setting']['apparmor_start_Action'] = :start

# R-270661 UBTU-24-100600
default['ubuntu2404STIG']['stigrule_270661']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270661']['Title'] = "Ubuntu 24.04 LTS must have the \"libpam-pwquality\" package installed."
default['ubuntu2404STIG']['stigrule_270661']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_pwquality_PackageName'] = 'libpam-pwquality'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_pwquality_Action'] = :install

# R-270661 UBTU-24-100600
default['ubuntu2404STIG']['stigrule_270661']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270661']['Title'] = "Ubuntu 24.04 LTS must have the \"libpam-pwquality\" package installed."
default['ubuntu2404STIG']['stigrule_270661']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['sssd_PackageName'] = 'sssd'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['sssd_Action'] = :install

default['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_sss_PackageName'] = 'libpam-sss'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['libpam_sss_Action'] = :install

default['ubuntu2404STIG']['stigrule_270661']['Setting']['libnss_sss_PackageName'] = 'libnss-sss'
default['ubuntu2404STIG']['stigrule_270661']['Setting']['libnss_sss_Action'] = :install

# R-270663 UBTU-24-100660
default['ubuntu2404STIG']['stigrule_270663']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270663']['Title'] = "Ubuntu 24.04 LTS must use the \"SSSD\" package for multifactor authentication services."
default['ubuntu2404STIG']['stigrule_270663']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_ServiceName'] = 'sssd'
default['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_Action'] = :enable

default['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_ServiceName'] = 'sssd'
default['ubuntu2404STIG']['stigrule_270663']['Setting']['sssd_enable_Action'] = :start

# R-270664 UBTU-24-100700
default['ubuntu2404STIG']['stigrule_270664']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270664']['Title'] = "Ubuntu 24.04 LTS must have the \"chrony\" package installed."
default['ubuntu2404STIG']['stigrule_270664']['Severity'] = 'low'
default['ubuntu2404STIG']['stigrule_270664']['Setting']['chrony_PackageName'] = 'chrony'
default['ubuntu2404STIG']['stigrule_270664']['Setting']['chrony_Action'] = :install

# R-270665 UBTU-24-100800
default['ubuntu2404STIG']['stigrule_270665']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270665']['Title'] = "Ubuntu 24.04 LTS must have SSH installed."
default['ubuntu2404STIG']['stigrule_270665']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270665']['Setting']['ssh_PackageName'] = 'ssh'
default['ubuntu2404STIG']['stigrule_270665']['Setting']['ssh_Action'] = :install

# R-270666 UBTU-24-100810
default['ubuntu2404STIG']['stigrule_270666']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270666']['Title'] = "Ubuntu 24.04 LTS must use SSH to protect the confidentiality and integrity of transmitted information."
default['ubuntu2404STIG']['stigrule_270666']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_active_ServiceName'] = 'ssh'
default['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_active_Action'] = :enable

default['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_start_ServiceName'] = 'ssh'
default['ubuntu2404STIG']['stigrule_270666']['Setting']['ssh_start_Action'] = :start

# R-270667 UBTU-24-100820
default['ubuntu2404STIG']['stigrule_270667']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270667']['Title'] = "Ubuntu 24.04 LTS must configure the SSH daemon to use FIPS 140-3 approved ciphers to prevent the unauthorized disclosure of information and/or detect changes to information during transmission."
default['ubuntu2404STIG']['stigrule_270667']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Regexp'] = '^\s*(?i)Ciphers\s+'
default['ubuntu2404STIG']['stigrule_270667']['Setting']['Ciphers_Line'] = 'Ciphers aes256-gcm@openssh.com,aes128-gcm@openssh.com,aes256-ctr,aes128-ctr'

# R-270668 UBTU-24-100830
default['ubuntu2404STIG']['stigrule_270668']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270668']['Title'] = "Ubuntu 24.04 LTS must configure the SSH daemon to use Message Authentication Codes (MACs) employing FIPS 140-3 approved cryptographic hashes to prevent the unauthorized disclosure of information and/or detect changes to information during transmission."
default['ubuntu2404STIG']['stigrule_270668']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Regexp'] = '^\s*(?i)MACs\s+'
default['ubuntu2404STIG']['stigrule_270668']['Setting']['MACs_Line'] = 'MACs hmac-sha2-512-etm@openssh.com,hmac-sha2-256-etm@openssh.com,hmac-sha2-512,hmac-sha2-256'

# R-270669 UBTU-24-100840
default['ubuntu2404STIG']['stigrule_270669']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270669']['Title'] = "Ubuntu 24.04 LTS SSH server must be configured to use only FIPS 140-3 validated key exchange algorithms."
default['ubuntu2404STIG']['stigrule_270669']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Regexp'] = '^\s*(?i)KexAlgorithms\s+'
default['ubuntu2404STIG']['stigrule_270669']['Setting']['KexAlgorithms_Line'] = 'KexAlgorithms ecdh-sha2-nistp521,ecdh-sha2-nistp384,ecdh-sha2-nistp256,diffie-hellman-group-exchange-sha256,diffie-hellman-group16-sha512,diffie-hellman-group14-sha256'

# R-270670 UBTU-24-100850
default['ubuntu2404STIG']['stigrule_270670']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270670']['Title'] = "Ubuntu 24.04 LTS must configure the SSH client to use FIPS 140-3 approved ciphers to prevent the unauthorized disclosure of information and/or detect changes to information during transmission."
default['ubuntu2404STIG']['stigrule_270670']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Path'] = '/etc/ssh/ssh_config'
default['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Regexp'] = '^\s*(?i)Ciphers\s+'
default['ubuntu2404STIG']['stigrule_270670']['Setting']['Ciphers_Line'] = 'Ciphers aes256-gcm@openssh.com,aes128-gcm@openssh.com,aes256-ctr,aes128-ctr'

# R-270671 UBTU-24-100860
default['ubuntu2404STIG']['stigrule_270671']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270671']['Title'] = "Ubuntu 24.04 LTS SSH client must be configured to use only Message Authentication Codes (MACs) employing FIPS 140-3 validated cryptographic hash algorithms."
default['ubuntu2404STIG']['stigrule_270671']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Path'] = '/etc/ssh/ssh_config'
default['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Regexp'] = '^\s*(?i)MACs\s+'
default['ubuntu2404STIG']['stigrule_270671']['Setting']['MACs_Line'] = 'MACs hmac-sha2-512-etm@openssh.com,hmac-sha2-256-etm@openssh.com,hmac-sha2-512,hmac-sha2-256'

# R-270672 UBTU-24-100900
default['ubuntu2404STIG']['stigrule_270672']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270672']['Title'] = "Ubuntu 24.04 LTS must accept Personal Identity Verification (PIV) credentials."
default['ubuntu2404STIG']['stigrule_270672']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270672']['Setting']['opensc_pkcs11_PackageName'] = 'opensc-pkcs11'
default['ubuntu2404STIG']['stigrule_270672']['Setting']['opensc_pkcs11_Action'] = :install

# R-270673 UBTU-24-100910
default['ubuntu2404STIG']['stigrule_270673']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270673']['Title'] = "Ubuntu 24.04 LTS must accept Personal Identity Verification (PIV) credentials managed through the Privileged Access Management (PAM)  framework."
default['ubuntu2404STIG']['stigrule_270673']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270673']['Setting']['libpam_pkcs11_PackageName'] = 'libpam-pkcs11'
default['ubuntu2404STIG']['stigrule_270673']['Setting']['libpam_pkcs11_Action'] = :install

# R-270674 UBTU-24-101000
default['ubuntu2404STIG']['stigrule_270674']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270674']['Title'] = "Ubuntu 24.04 LTS must allow users to directly initiate a session lock for all connection types."
default['ubuntu2404STIG']['stigrule_270674']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270674']['Setting']['vlock_PackageName'] = 'vlock'
default['ubuntu2404STIG']['stigrule_270674']['Setting']['vlock_Action'] = :install

# R-270677 UBTU-24-200000
default['ubuntu2404STIG']['stigrule_270677']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270677']['Title'] = "Ubuntu 24.04 LTS must limit the number of concurrent sessions to 10 for all accounts and/or account types."
default['ubuntu2404STIG']['stigrule_270677']['Severity'] = 'low'
default['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Path'] = '/etc/security/limits.conf'
default['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Regexp'] = '^\* hard maxlogins'
default['ubuntu2404STIG']['stigrule_270677']['Setting']['_etc_security_limits_conf_Line'] = '* hard maxlogins 10'

# R-270678 UBTU-24-200020
default['ubuntu2404STIG']['stigrule_270678']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270678']['Title'] = "Ubuntu 24.04 LTS must initiate a graphical session lock after 10 minutes of inactivity."
default['ubuntu2404STIG']['stigrule_270678']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Section'] = 'org/gnome/desktop/session'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Option'] = 'idle-delay'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_idle_delay_Value'] = "uint32 900"

default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Section'] = 'org/gnome/desktop/screensaver'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Option'] = 'lock-enabled'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_enabled_Value'] = "true"

default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Section'] = 'org/gnome/desktop/screensaver'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Option'] = 'lock-delay'
default['ubuntu2404STIG']['stigrule_270678']['Setting']['_etc_dconf_db_local_d_00_screensaver_lock_delay_Value'] = "uint32 600"

# R-270679 UBTU-24-200040
default['ubuntu2404STIG']['stigrule_270679']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270679']['Title'] = "Ubuntu 24.04 LTS must prevent a user from overriding the disabling of the graphical user interface automount function."
default['ubuntu2404STIG']['stigrule_270679']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_Path'] = '/etc/dconf/db/local.d/locks/00-security-settings-lock'
default['ubuntu2404STIG']['stigrule_270679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_Line'] = '/org/gnome/desktop/media-handling/automount-open'

# R-270680 UBTU-24-200060
default['ubuntu2404STIG']['stigrule_270680']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270680']['Title'] = "Ubuntu 24.04 LTS must automatically terminate a user session after inactivity timeouts have expired."
default['ubuntu2404STIG']['stigrule_270680']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270680']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Path'] = '/etc/profile.d/99-terminal_tmout.sh'
default['ubuntu2404STIG']['stigrule_270680']['Setting']['_etc_profile_d_99_terminal_tmout_sh_Content'] = 'TMOUT=600'

# R-270684 UBTU-24-200280
default['ubuntu2404STIG']['stigrule_270684']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270684']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/passwd."
default['ubuntu2404STIG']['stigrule_270684']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Regexp'] = '^-w /etc/passwd -p wa -k usergroup_modification$'
default['ubuntu2404STIG']['stigrule_270684']['Setting']['_etc_audit_rules_d_stig_rules__etc_passwd_Line'] = '-w /etc/passwd -p wa -k usergroup_modification'

# R-270685 UBTU-24-200290
default['ubuntu2404STIG']['stigrule_270685']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270685']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/group."
default['ubuntu2404STIG']['stigrule_270685']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Regexp'] = '^-w /etc/group -p wa -k usergroup_modification$'
default['ubuntu2404STIG']['stigrule_270685']['Setting']['_etc_audit_rules_d_stig_rules__etc_group_Line'] = '-w /etc/group -p wa -k usergroup_modification'

# R-270686 UBTU-24-200300
default['ubuntu2404STIG']['stigrule_270686']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270686']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/shadow."
default['ubuntu2404STIG']['stigrule_270686']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Regexp'] = '^-w /etc/shadow -p wa -k usergroup_modification$'
default['ubuntu2404STIG']['stigrule_270686']['Setting']['_etc_audit_rules_d_stig_rules__etc_shadow_Line'] = '-w /etc/shadow -p wa -k usergroup_modification'

# R-270687 UBTU-24-200310
default['ubuntu2404STIG']['stigrule_270687']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270687']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/gshadow."
default['ubuntu2404STIG']['stigrule_270687']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Regexp'] = '^-w /etc/gshadow -p wa -k usergroup_modification$'
default['ubuntu2404STIG']['stigrule_270687']['Setting']['_etc_audit_rules_d_stig_rules__etc_gshadow_Line'] = '-w /etc/gshadow -p wa -k usergroup_modification'

# R-270688 UBTU-24-200320
default['ubuntu2404STIG']['stigrule_270688']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270688']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/opasswd."
default['ubuntu2404STIG']['stigrule_270688']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Regexp'] = '^-w /etc/security/opasswd -p wa -k usergroup_modification$'
default['ubuntu2404STIG']['stigrule_270688']['Setting']['_etc_audit_rules_d_stig_rules__etc_security_opasswd_Line'] = '-w /etc/security/opasswd -p wa -k usergroup_modification'

# R-270689 UBTU-24-200580
default['ubuntu2404STIG']['stigrule_270689']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270689']['Title'] = "Ubuntu 24.04 LTS must prevent all software from executing at higher privilege levels than users executing the software and the audit system must be configured to audit the execution of privileged functions."
default['ubuntu2404STIG']['stigrule_270689']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -F key=execpriv$'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_euid_Line'] = '-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -F key=execpriv'

default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C gid!=egid -F egid=0 -F key=execpriv$'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b64_egid_Line'] = '-a always,exit -F arch=b64 -S execve -C gid!=egid -F egid=0 -F key=execpriv'

default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -F key=execpriv$'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_euid_Line'] = '-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -F key=execpriv'

default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C gid!=egid -F egid=0 -F key=execpriv$'
default['ubuntu2404STIG']['stigrule_270689']['Setting']['_etc_audit_rules_d_stig_rules_execve_b32_egid_Line'] = '-a always,exit -F arch=b32 -S execve -C gid!=egid -F egid=0 -F key=execpriv'

# R-270691 UBTU-24-200640
default['ubuntu2404STIG']['stigrule_270691']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270691']['Title'] = "Ubuntu 24.04 LTS must display the Standard Mandatory DOD Notice and Consent Banner before granting access to via an SSH logon."
default['ubuntu2404STIG']['stigrule_270691']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Regexp'] = '^\s*(?i)banner\s+'
default['ubuntu2404STIG']['stigrule_270691']['Setting']['banner_Line'] = 'banner /etc/issue.net'

default['ubuntu2404STIG']['stigrule_270691']['Setting']['_etc_issue_net_Path'] = '/etc/issue.net'
default['ubuntu2404STIG']['stigrule_270691']['Setting']['_etc_issue_net_Content'] = 'You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.
By using this IS (which includes any device attached to this IS), you consent to the following conditions:
-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.
-At any time, the USG may inspect and seize data stored on this IS.
-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.
-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.
-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details.
'

# R-270692 UBTU-24-200650
default['ubuntu2404STIG']['stigrule_270692']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270692']['Title'] = "Ubuntu 24.04 LTS must enable the graphical user logon banner to display the Standard Mandatory DOD Notice and Consent Banner before granting local access to the system via a graphical user logon."
default['ubuntu2404STIG']['stigrule_270692']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Path'] = '/etc/gdm3/greeter.dconf-defaults'
default['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Section'] = 'org/gnome/login-screen'
default['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Option'] = 'banner-message-enable'
default['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Value'] = "true"
default['ubuntu2404STIG']['stigrule_270692']['Setting']['_etc_gdm3_greeter_dconf_defaults_enable_Only_if'] = "dpkg -s gdm3"

# R-270693 UBTU-24-200660
default['ubuntu2404STIG']['stigrule_270693']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270693']['Title'] = "Ubuntu 24.04 LTS must display the Standard Mandatory DOD Notice and Consent Banner before granting local access to the system via a graphical user logon."
default['ubuntu2404STIG']['stigrule_270693']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Path'] = '/etc/gdm3/greeter.dconf-defaults'
default['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Section'] = 'org/gnome/login-screen'
default['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Option'] = 'banner-message-text'
default['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Value'] = "You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.\n\nBy using this IS (which includes any device attached to this IS), you consent to the following conditions:\n\n-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.\n\n-At any time, the USG may inspect and seize data stored on this IS.\n\n-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.\n\n-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.\n\n-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details."
default['ubuntu2404STIG']['stigrule_270693']['Setting']['_etc_gdm3_greeter_dconf_defaults_text_Only_if'] = "dpkg -s gdm3"

# R-270695 UBTU-24-300001
default['ubuntu2404STIG']['stigrule_270695']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270695']['Title'] = "Ubuntu 24.04 LTS Advance Package Tool (APT) must be configured to prevent the installation of patches, service packs, device drivers, or Ubuntu 24.04 LTS components without verification they have been digitally signed using a certificate that is recognized and approved by the organization."
default['ubuntu2404STIG']['stigrule_270695']['Severity'] = 'low'
default['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Path'] = '/etc/apt/apt.conf.d/01-vendor-ubuntu'
default['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Regexp'] = '^APT::Get::AllowUnauthenticated'
default['ubuntu2404STIG']['stigrule_270695']['Setting']['_etc_apt_apt_conf_d_01_vendor_ubuntu_Line'] = 'APT::Get::AllowUnauthenticated "false";'

# R-270704 UBTU-24-300014
default['ubuntu2404STIG']['stigrule_270704']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270704']['Title'] = "Ubuntu 24.04 LTS must prevent the use of dictionary words for passwords."
default['ubuntu2404STIG']['stigrule_270704']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dictcheck'
default['ubuntu2404STIG']['stigrule_270704']['Setting']['_etc_security_pwquality_conf_Line'] = 'dictcheck=1'

# R-270708 UBTU-24-300022
default['ubuntu2404STIG']['stigrule_270708']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270708']['Title'] = "Ubuntu 24.04 LTS must be configured so that remote X connections are disabled, unless to fulfill documented and validated mission requirements."
default['ubuntu2404STIG']['stigrule_270708']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Regexp'] = '^\s*(?i)X11Forwarding\s+'
default['ubuntu2404STIG']['stigrule_270708']['Setting']['X11Forwarding_Line'] = 'X11Forwarding no'

# R-270709 UBTU-24-300023
default['ubuntu2404STIG']['stigrule_270709']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270709']['Title'] = "Ubuntu 24.04 LTS SSH daemon must prevent remote hosts from connecting to the proxy display."
default['ubuntu2404STIG']['stigrule_270709']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Regexp'] = '^\s*(?i)X11UseLocalhost\s+'
default['ubuntu2404STIG']['stigrule_270709']['Setting']['X11UseLocalhost_Line'] = 'X11UseLocalhost yes'

# R-270711 UBTU-24-300025
default['ubuntu2404STIG']['stigrule_270711']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270711']['Title'] = "Ubuntu 24.04 LTS must disable the x86 Ctrl-Alt-Delete key sequence if a graphical user interface is installed."
default['ubuntu2404STIG']['stigrule_270711']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Section'] = 'org/gnome/settings-daemon/plugins/media-keys'
default['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Option'] = 'logout'
default['ubuntu2404STIG']['stigrule_270711']['Setting']['_etc_dconf_db_local_d_00_screensaver_media_keys_Value'] = "['']"

# R-270712 UBTU-24-300026
default['ubuntu2404STIG']['stigrule_270712']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270712']['Title'] = "Ubuntu 24.04 LTS must disable the x86 Ctrl-Alt-Delete key sequence."
default['ubuntu2404STIG']['stigrule_270712']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_disable_UnitName'] = 'ctrl-alt-del.target'
default['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_disable_Action'] = :disable

default['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_mask_UnitName'] = 'ctrl-alt-del.target'
default['ubuntu2404STIG']['stigrule_270712']['Setting']['ctrl_alt_del_target_mask_Action'] = [:mask, :stop]

# R-270715 UBTU-24-300029
default['ubuntu2404STIG']['stigrule_270715']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270715']['Title'] = "Ubuntu 24.04 LTS must generate audit records for all events that affect the systemd journal files."
default['ubuntu2404STIG']['stigrule_270715']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Regexp'] = '^-w /var/log/journal -p wa -k systemd_journal$'
default['ubuntu2404STIG']['stigrule_270715']['Setting']['_etc_audit_rules_d_stig_rules__var_log_journal_Line'] = '-w /var/log/journal -p wa -k systemd_journal'

# R-270716 UBTU-24-300030
default['ubuntu2404STIG']['stigrule_270716']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270716']['Title'] = "Ubuntu 24.04 LTS default filesystem permissions must be defined in such a way that all authenticated users can read and modify only their own files."
default['ubuntu2404STIG']['stigrule_270716']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Regexp'] = '^UMASK'
default['ubuntu2404STIG']['stigrule_270716']['Setting']['_etc_login_defs_Line'] = 'UMASK 077'

# R-270717 UBTU-24-300031
default['ubuntu2404STIG']['stigrule_270717']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270717']['Title'] = "Ubuntu 24.04 LTS must not allow unattended or automatic login via SSH."
default['ubuntu2404STIG']['stigrule_270717']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Regexp'] = '^\s*(?i)PermitEmptyPasswords\s+'
default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitEmptyPasswords_Line'] = 'PermitEmptyPasswords no'

default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Regexp'] = '^\s*(?i)PermitUserEnvironment\s+'
default['ubuntu2404STIG']['stigrule_270717']['Setting']['PermitUserEnvironment_Line'] = 'PermitUserEnvironment no'

# R-270718 UBTU-24-300039
default['ubuntu2404STIG']['stigrule_270718']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270718']['Title'] = "Ubuntu 24.04 LTS must disable automatic mounting of Universal Serial Bus (USB) mass storage driver."
default['ubuntu2404STIG']['stigrule_270718']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_install_usb_storage_Path'] = '/etc/modprobe.d/DISASTIG.conf'
default['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_install_usb_storage_Line'] = 'install usb-storage /bin/false'

default['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Path'] = '/etc/modprobe.d/DISASTIG.conf'
default['ubuntu2404STIG']['stigrule_270718']['Setting']['_etc_modprobe_d_DISASTIG_conf_blacklist_usb_storage_Line'] = 'blacklist usb-storage'

# R-270722 UBTU-24-400030
default['ubuntu2404STIG']['stigrule_270722']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270722']['Title'] = "Ubuntu 24.04 LTS must implement smart card logins for multifactor authentication for local and network access to privileged and nonprivileged accounts over SSH."
default['ubuntu2404STIG']['stigrule_270722']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Regexp'] = '^\s*(?i)PubkeyAuthentication\s+'
default['ubuntu2404STIG']['stigrule_270722']['Setting']['PubkeyAuthentication_Line'] = 'PubkeyAuthentication yes'

# R-270726 UBTU-24-400260
default['ubuntu2404STIG']['stigrule_270726']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270726']['Title'] = "Ubuntu 24.04 LTS must enforce password complexity by requiring that at least one uppercase character be used."
default['ubuntu2404STIG']['stigrule_270726']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ucredit'
default['ubuntu2404STIG']['stigrule_270726']['Setting']['_etc_security_pwquality_conf_Line'] = 'ucredit=-1'

# R-270727 UBTU-24-400270
default['ubuntu2404STIG']['stigrule_270727']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270727']['Title'] = "Ubuntu 24.04 LTS must enforce password complexity by requiring that at least one lowercase character be used."
default['ubuntu2404STIG']['stigrule_270727']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*lcredit'
default['ubuntu2404STIG']['stigrule_270727']['Setting']['_etc_security_pwquality_conf_Line'] = 'lcredit=-1'

# R-270728 UBTU-24-400280
default['ubuntu2404STIG']['stigrule_270728']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270728']['Title'] = "Ubuntu 24.04 LTS must enforce password complexity by requiring that at least one numeric character be used."
default['ubuntu2404STIG']['stigrule_270728']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dcredit'
default['ubuntu2404STIG']['stigrule_270728']['Setting']['_etc_security_pwquality_conf_Line'] = 'dcredit=-1'

# R-270729 UBTU-24-400290
default['ubuntu2404STIG']['stigrule_270729']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270729']['Title'] = "Ubuntu 24.04 LTS must require the change of at least eight characters when passwords are changed."
default['ubuntu2404STIG']['stigrule_270729']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*difok'
default['ubuntu2404STIG']['stigrule_270729']['Setting']['_etc_security_pwquality_conf_Line'] = 'difok=8'

# R-270730 UBTU-24-400300
default['ubuntu2404STIG']['stigrule_270730']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270730']['Title'] = "Ubuntu 24.04 LTS must enforce 24 hours/1 day as the minimum password lifetime. Passwords for new users must have a 24 hours/1 day minimum password lifetime restriction."
default['ubuntu2404STIG']['stigrule_270730']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MIN_DAYS'
default['ubuntu2404STIG']['stigrule_270730']['Setting']['_etc_login_defs_Line'] = 'PASS_MIN_DAYS 1'

# R-270731 UBTU-24-400310
default['ubuntu2404STIG']['stigrule_270731']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270731']['Title'] = "Ubuntu 24.04 LTS must enforce a 60-day maximum password lifetime restriction. Passwords for new users must have a 60-day maximum password lifetime restriction."
default['ubuntu2404STIG']['stigrule_270731']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MAX_DAYS'
default['ubuntu2404STIG']['stigrule_270731']['Setting']['_etc_login_defs_Line'] = 'PASS_MAX_DAYS 60'

# R-270732 UBTU-24-400320
default['ubuntu2404STIG']['stigrule_270732']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270732']['Title'] = "Ubuntu 24.04 LTS must enforce a minimum 15-character password length."
default['ubuntu2404STIG']['stigrule_270732']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*minlen'
default['ubuntu2404STIG']['stigrule_270732']['Setting']['_etc_security_pwquality_conf_Line'] = 'minlen=15'

# R-270733 UBTU-24-400330
default['ubuntu2404STIG']['stigrule_270733']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270733']['Title'] = "Ubuntu 24.04 LTS must enforce password complexity by requiring that at least one special character be used."
default['ubuntu2404STIG']['stigrule_270733']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ocredit'
default['ubuntu2404STIG']['stigrule_270733']['Setting']['_etc_security_pwquality_conf_Line'] = 'ocredit=-1'

# R-270736 UBTU-24-400370
default['ubuntu2404STIG']['stigrule_270736']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270736']['Title'] = "Ubuntu 24.04 LTS must map the authenticated identity to the user or group account for PKI-based authentication."
default['ubuntu2404STIG']['stigrule_270736']['Severity'] = 'high'
default['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Path'] = '/etc/sssd/sssd.conf'
default['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Regexp'] = '^\s*ldap_user_certificate'
default['ubuntu2404STIG']['stigrule_270736']['Setting']['_etc_sssd_sssd_conf_Line'] = 'ldap_user_certificate=userCertificate;binary'

# R-270739 UBTU-24-400400
default['ubuntu2404STIG']['stigrule_270739']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270739']['Title'] = "Ubuntu 24.04 LTS must encrypt all stored passwords with a FIPS 140-3 approved cryptographic hashing algorithm."
default['ubuntu2404STIG']['stigrule_270739']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Regexp'] = '^ENCRYPT_METHOD'
default['ubuntu2404STIG']['stigrule_270739']['Setting']['_etc_login_defs_Line'] = 'ENCRYPT_METHOD SHA512'

# R-270740 UBTU-24-500010
default['ubuntu2404STIG']['stigrule_270740']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270740']['Title'] = "Ubuntu 24.04 LTS must generate audit records for privileged activities, nonlocal maintenance, diagnostic sessions, and other system-level access."
default['ubuntu2404STIG']['stigrule_270740']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Regexp'] = '^-w /var/log/sudo.log -p wa -k maintenance$'
default['ubuntu2404STIG']['stigrule_270740']['Setting']['_etc_audit_rules_d_stig_rules__var_log_sudo_log_Line'] = '-w /var/log/sudo.log -p wa -k maintenance'

# R-270741 UBTU-24-500050
default['ubuntu2404STIG']['stigrule_270741']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270741']['Title'] = "Ubuntu 24.04 LTS must use strong authenticators in establishing nonlocal maintenance and diagnostic sessions."
default['ubuntu2404STIG']['stigrule_270741']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Regexp'] = '^\s*(?i)UsePAM\s+'
default['ubuntu2404STIG']['stigrule_270741']['Setting']['UsePAM_Line'] = 'UsePAM yes'

# R-270742 UBTU-24-600000
default['ubuntu2404STIG']['stigrule_270742']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270742']['Title'] = "Ubuntu 24.04 LTS must immediately terminate all network connections associated with SSH traffic after a period of inactivity."
default['ubuntu2404STIG']['stigrule_270742']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Regexp'] = '^\s*(?i)ClientAliveCountMax\s+'
default['ubuntu2404STIG']['stigrule_270742']['Setting']['ClientAliveCountMax_Line'] = 'ClientAliveCountMax 1'

# R-270743 UBTU-24-600010
default['ubuntu2404STIG']['stigrule_270743']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270743']['Title'] = "Ubuntu 24.04 LTS must immediately terminate all network connections associated with SSH traffic at the end of the session or after 10 minutes of inactivity."
default['ubuntu2404STIG']['stigrule_270743']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Path'] = '/etc/ssh/sshd_config'
default['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Regexp'] = '^\s*(?i)ClientAliveInterval\s+'
default['ubuntu2404STIG']['stigrule_270743']['Setting']['ClientAliveInterval_Line'] = 'ClientAliveInterval 600'

# R-270746 UBTU-24-600070
default['ubuntu2404STIG']['stigrule_270746']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270746']['Title'] = "Ubuntu 24.04 LTS must disable kernel core dumps."
default['ubuntu2404STIG']['stigrule_270746']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270746']['Setting']['kdump_tools_disable_ServiceName'] = 'kdump-tools'
default['ubuntu2404STIG']['stigrule_270746']['Setting']['kdump_tools_disable_Action'] = :disable

# R-270753 UBTU-24-600190
default['ubuntu2404STIG']['stigrule_270753']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270753']['Title'] = "Ubuntu 24.04 LTS must be configured to use TCP syncookies."
default['ubuntu2404STIG']['stigrule_270753']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270753']['Setting']['net_ipv4_tcp_syncookies_Key'] = 'net.ipv4.tcp_syncookies'
default['ubuntu2404STIG']['stigrule_270753']['Setting']['net_ipv4_tcp_syncookies_Value'] = 1

default['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Path'] = '/etc/sysctl.conf'
default['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Regexp'] = '^\s*net.ipv4.tcp_syncookies'
default['ubuntu2404STIG']['stigrule_270753']['Setting']['_etc_sysctl_conf_Line'] = 'net.ipv4.tcp_syncookies = 1'

# R-270773 UBTU-24-700320
default['ubuntu2404STIG']['stigrule_270773']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270773']['Title'] = "Ubuntu 24.04 LTS must be configured so that Advance Package Tool (APT) removes all software components after updated versions have been installed."
default['ubuntu2404STIG']['stigrule_270773']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Path'] = '/etc/apt/apt.conf.d/50unattended-upgrades'
default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Regexp'] = '^Unattended-Upgrade::Remove-Unused-Dependencies'
default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Dependencies_Line'] = 'Unattended-Upgrade::Remove-Unused-Dependencies "true";'

default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Path'] = '/etc/apt/apt.conf.d/50unattended-upgrades'
default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Regexp'] = '^Unattended-Upgrade::Remove-Unused-Kernel-Packages'
default['ubuntu2404STIG']['stigrule_270773']['Setting']['_etc_apt_apt_conf_d_50unattended_upgrades_Remove_Unused_Kernel_Packages_Line'] = 'Unattended-Upgrade::Remove-Unused-Kernel-Packages "true";'

# R-270778 UBTU-24-900070
default['ubuntu2404STIG']['stigrule_270778']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270778']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the su command."
default['ubuntu2404STIG']['stigrule_270778']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Regexp'] = '^-a always,exit -F path=/bin/su -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-priv_change$'
default['ubuntu2404STIG']['stigrule_270778']['Setting']['_etc_audit_rules_d_stig_rules__bin_su_Line'] = '-a always,exit -F path=/bin/su -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-priv_change'

# R-270779 UBTU-24-900080
default['ubuntu2404STIG']['stigrule_270779']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270779']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chfn command."
default['ubuntu2404STIG']['stigrule_270779']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Regexp'] = '^-a always,exit -F path=/usr/bin/chfn -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-chfn$'
default['ubuntu2404STIG']['stigrule_270779']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chfn_Line'] = '-a always,exit -F path=/usr/bin/chfn -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-chfn'

# R-270780 UBTU-24-900090
default['ubuntu2404STIG']['stigrule_270780']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270780']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the mount command."
default['ubuntu2404STIG']['stigrule_270780']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Regexp'] = '^-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-mount$'
default['ubuntu2404STIG']['stigrule_270780']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_mount_Line'] = '-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-mount'

# R-270781 UBTU-24-900100
default['ubuntu2404STIG']['stigrule_270781']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270781']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the umount command."
default['ubuntu2404STIG']['stigrule_270781']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Regexp'] = '^-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-umount$'
default['ubuntu2404STIG']['stigrule_270781']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_umount_Line'] = '-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-umount'

# R-270782 UBTU-24-900110
default['ubuntu2404STIG']['stigrule_270782']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270782']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the ssh-agent command."
default['ubuntu2404STIG']['stigrule_270782']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Regexp'] = '^-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-ssh$'
default['ubuntu2404STIG']['stigrule_270782']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_ssh_agent_Line'] = '-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-ssh'

# R-270783 UBTU-24-900120
default['ubuntu2404STIG']['stigrule_270783']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270783']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the ssh-keysign command."
default['ubuntu2404STIG']['stigrule_270783']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Regexp'] = '^-a always,exit -F path=/usr/lib/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-ssh$'
default['ubuntu2404STIG']['stigrule_270783']['Setting']['_etc_audit_rules_d_stig_rules__usr_lib_openssh_ssh_keysign_Line'] = '-a always,exit -F path=/usr/lib/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-ssh'

# R-270784 UBTU-24-900130
default['ubuntu2404STIG']['stigrule_270784']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270784']['Title'] = "Ubuntu 24.04 LTS must generate audit records for any use of the setxattr, fsetxattr, lsetxattr, removexattr, fremovexattr, and lremovexattr system calls."
default['ubuntu2404STIG']['stigrule_270784']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=-1 -k perm_mod$'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=-1 -k perm_mod'

default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b32_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=-1 -k perm_mod$'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_1_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=-1 -k perm_mod'

default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ubuntu2404STIG']['stigrule_270784']['Setting']['_etc_audit_rules_d_stig_rules_b64_setxattr_fsetxattr_lsetxattr_removexattr_fremovexattr_lremovexattr_2_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

# R-270785 UBTU-24-900140
default['ubuntu2404STIG']['stigrule_270785']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270785']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chown, fchown, fchownat, and lchown system calls."
default['ubuntu2404STIG']['stigrule_270785']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Regexp'] = '^-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b32_chown_fchown_fchownat_lchown_Line'] = '-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=-1 -k perm_chng'

default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Regexp'] = '^-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270785']['Setting']['_etc_audit_rules_d_stig_rules_b64_chown_fchown_fchownat_lchown_Line'] = '-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270786 UBTU-24-900150
default['ubuntu2404STIG']['stigrule_270786']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270786']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chmod, fchmod, and fchmodat system calls."
default['ubuntu2404STIG']['stigrule_270786']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Regexp'] = '^-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b32_chmod_fchmod_fchmodat_Line'] = '-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=-1 -k perm_chng'

default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Regexp'] = '^-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270786']['Setting']['_etc_audit_rules_d_stig_rules_b64_chmod_fchmod_fchmodat_Line'] = '-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270787 UBTU-24-900160
default['ubuntu2404STIG']['stigrule_270787']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270787']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the creat, open, openat, open_by_handle_at, truncate, and ftruncate system calls."
default['ubuntu2404STIG']['stigrule_270787']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Regexp'] = '^-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=-1 -k perm_access$'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EPERM_Line'] = '-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=-1 -k perm_access'

default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Regexp'] = '^-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=-1 -k perm_access$'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b32_creat_open_openat_open_by_handle_at_truncate_ftruncate_EACCES_Line'] = '-a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=-1 -k perm_access'

default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Regexp'] = '^-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=-1 -k perm_access$'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EPERM_Line'] = '-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=-1 -k perm_access'

default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Regexp'] = '^-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=-1 -k perm_access$'
default['ubuntu2404STIG']['stigrule_270787']['Setting']['_etc_audit_rules_d_stig_rules_b64_creat_open_openat_open_by_handle_at_truncate_ftruncat_EACCES_Line'] = '-a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=-1 -k perm_access'

# R-270788 UBTU-24-900170
default['ubuntu2404STIG']['stigrule_270788']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270788']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the sudo command."
default['ubuntu2404STIG']['stigrule_270788']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Regexp'] = '^-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd$'
default['ubuntu2404STIG']['stigrule_270788']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudo_Line'] = '-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd'

# R-270789 UBTU-24-900180
default['ubuntu2404STIG']['stigrule_270789']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270789']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the sudoedit command."
default['ubuntu2404STIG']['stigrule_270789']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Regexp'] = '^-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd$'
default['ubuntu2404STIG']['stigrule_270789']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_sudoedit_Line'] = '-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd'

# R-270790 UBTU-24-900190
default['ubuntu2404STIG']['stigrule_270790']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270790']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chsh command."
default['ubuntu2404STIG']['stigrule_270790']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Regexp'] = '^-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd$'
default['ubuntu2404STIG']['stigrule_270790']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chsh_Line'] = '-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd'

# R-270791 UBTU-24-900200
default['ubuntu2404STIG']['stigrule_270791']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270791']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the newgrp command."
default['ubuntu2404STIG']['stigrule_270791']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Regexp'] = '^-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd$'
default['ubuntu2404STIG']['stigrule_270791']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_newgrp_Line'] = '-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=-1 -k priv_cmd'

# R-270792 UBTU-24-900210
default['ubuntu2404STIG']['stigrule_270792']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270792']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chcon command."
default['ubuntu2404STIG']['stigrule_270792']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Regexp'] = '^-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270792']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chcon_Line'] = '-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270793 UBTU-24-900220
default['ubuntu2404STIG']['stigrule_270793']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270793']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the apparmor_parser command."
default['ubuntu2404STIG']['stigrule_270793']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Regexp'] = '^-a always,exit -F path=/sbin/apparmor_parser -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270793']['Setting']['_etc_audit_rules_d_stig_rules__sbin_apparmor_parser_Line'] = '-a always,exit -F path=/sbin/apparmor_parser -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270794 UBTU-24-900230
default['ubuntu2404STIG']['stigrule_270794']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270794']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the setfacl command."
default['ubuntu2404STIG']['stigrule_270794']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Regexp'] = '^-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270794']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_setfacl_Line'] = '-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270795 UBTU-24-900240
default['ubuntu2404STIG']['stigrule_270795']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270795']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chacl command."
default['ubuntu2404STIG']['stigrule_270795']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Regexp'] = '^-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng$'
default['ubuntu2404STIG']['stigrule_270795']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chacl_Line'] = '-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=-1 -k perm_chng'

# R-270796 UBTU-24-900250
default['ubuntu2404STIG']['stigrule_270796']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270796']['Title'] = "Ubuntu 24.04 LTS must generate audit records for the use and modification of faillog file."
default['ubuntu2404STIG']['stigrule_270796']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Regexp'] = '^-w /var/log/faillog -p wa -k logins$'
default['ubuntu2404STIG']['stigrule_270796']['Setting']['_etc_audit_rules_d_stig_rules__var_log_faillog_Line'] = '-w /var/log/faillog -p wa -k logins'

# R-270797 UBTU-24-900260
default['ubuntu2404STIG']['stigrule_270797']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270797']['Title'] = "Ubuntu 24.04 LTS must generate audit records for the use and modification of the lastlog file."
default['ubuntu2404STIG']['stigrule_270797']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Regexp'] = '^-w /var/log/lastlog -p wa -k logins$'
default['ubuntu2404STIG']['stigrule_270797']['Setting']['_etc_audit_rules_d_stig_rules__var_log_lastlog_Line'] = '-w /var/log/lastlog -p wa -k logins'

# R-270798 UBTU-24-900270
default['ubuntu2404STIG']['stigrule_270798']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270798']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the passwd command."
default['ubuntu2404STIG']['stigrule_270798']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Regexp'] = '^-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-passwd$'
default['ubuntu2404STIG']['stigrule_270798']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_passwd_Line'] = '-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-passwd'

# R-270799 UBTU-24-900280
default['ubuntu2404STIG']['stigrule_270799']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270799']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the unix_update command."
default['ubuntu2404STIG']['stigrule_270799']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Regexp'] = '^-a always,exit -F path=/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-unix-update$'
default['ubuntu2404STIG']['stigrule_270799']['Setting']['_etc_audit_rules_d_stig_rules__sbin_unix_update_Line'] = '-a always,exit -F path=/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-unix-update'

# R-270800 UBTU-24-900290
default['ubuntu2404STIG']['stigrule_270800']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270800']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the gpasswd command."
default['ubuntu2404STIG']['stigrule_270800']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Regexp'] = '^-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-gpasswd$'
default['ubuntu2404STIG']['stigrule_270800']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_gpasswd_Line'] = '-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-gpasswd'

# R-270801 UBTU-24-900300
default['ubuntu2404STIG']['stigrule_270801']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270801']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the chage command."
default['ubuntu2404STIG']['stigrule_270801']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Regexp'] = '^-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-chage$'
default['ubuntu2404STIG']['stigrule_270801']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_chage_Line'] = '-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-chage'

# R-270802 UBTU-24-900310
default['ubuntu2404STIG']['stigrule_270802']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270802']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the usermod command."
default['ubuntu2404STIG']['stigrule_270802']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Regexp'] = '^-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-usermod$'
default['ubuntu2404STIG']['stigrule_270802']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_usermod_Line'] = '-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-usermod'

# R-270803 UBTU-24-900320
default['ubuntu2404STIG']['stigrule_270803']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270803']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the crontab command."
default['ubuntu2404STIG']['stigrule_270803']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Regexp'] = '^-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-crontab$'
default['ubuntu2404STIG']['stigrule_270803']['Setting']['_etc_audit_rules_d_stig_rules__usr_bin_crontab_Line'] = '-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-crontab'

# R-270804 UBTU-24-900330
default['ubuntu2404STIG']['stigrule_270804']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270804']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the pam_timestamp_check command."
default['ubuntu2404STIG']['stigrule_270804']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Regexp'] = '^-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-pam_timestamp_check$'
default['ubuntu2404STIG']['stigrule_270804']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_pam_timestamp_check_Line'] = '-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=-1 -k privileged-pam_timestamp_check'

# R-270805 UBTU-24-900340
default['ubuntu2404STIG']['stigrule_270805']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270805']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the init_module and finit_module syscalls."
default['ubuntu2404STIG']['stigrule_270805']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Regexp'] = '^-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=-1 -k module_chng$'
default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b32_init_module_finit_module_Line'] = '-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=-1 -k module_chng'

default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Regexp'] = '^-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=-1 -k module_chng$'
default['ubuntu2404STIG']['stigrule_270805']['Setting']['_etc_audit_rules_d_stig_rules_b64_init_module_finit_module_Line'] = '-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=-1 -k module_chng'

# R-270806 UBTU-24-900350
default['ubuntu2404STIG']['stigrule_270806']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270806']['Title'] = "Ubuntu 24.04 LTS must generate audit records for successful/unsuccessful uses of the delete_module syscall."
default['ubuntu2404STIG']['stigrule_270806']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Regexp'] = '^-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=-1 -k module_chng$'
default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b32_Line'] = '-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=-1 -k module_chng'

default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Regexp'] = '^-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=-1 -k module_chng$'
default['ubuntu2404STIG']['stigrule_270806']['Setting']['_etc_audit_rules_d_stig_rules_delete_module_b64_Line'] = '-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=-1 -k module_chng'

# R-270807 UBTU-24-900510
default['ubuntu2404STIG']['stigrule_270807']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270807']['Title'] = "Ubuntu 24.04 LTS must generate audit records when successful/unsuccessful attempts to modify the /etc/sudoers file occur."
default['ubuntu2404STIG']['stigrule_270807']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Regexp'] = '^-w /etc/sudoers -p wa -k privilege_modification$'
default['ubuntu2404STIG']['stigrule_270807']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_Line'] = '-w /etc/sudoers -p wa -k privilege_modification'

# R-270808 UBTU-24-900520
default['ubuntu2404STIG']['stigrule_270808']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270808']['Title'] = "Ubuntu 24.04 LTS must generate audit records when successful/unsuccessful attempts to modify the /etc/sudoers.d directory occur."
default['ubuntu2404STIG']['stigrule_270808']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Regexp'] = '^-w /etc/sudoers.d -p wa -k privilege_modification$'
default['ubuntu2404STIG']['stigrule_270808']['Setting']['_etc_audit_rules_d_stig_rules__etc_sudoers_d_Line'] = '-w /etc/sudoers.d -p wa -k privilege_modification'

# R-270809 UBTU-24-900540
default['ubuntu2404STIG']['stigrule_270809']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270809']['Title'] = "Ubuntu 24.04 LTS must generate audit records for any successful/unsuccessful use of unlink, unlinkat, rename, renameat, and rmdir system calls."
default['ubuntu2404STIG']['stigrule_270809']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Regexp'] = '^-a always,exit -F arch=b64 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=-1 -k delete$'
default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b64_unlink_unlinkat_rename_renameat_rmdir_Line'] = '-a always,exit -F arch=b64 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=-1 -k delete'

default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Regexp'] = '^-a always,exit -F arch=b32 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=-1 -k delete$'
default['ubuntu2404STIG']['stigrule_270809']['Setting']['_etc_audit_rules_d_stig_rules_b32_unlink_unlinkat_rename_renameat_rmdir_Line'] = '-a always,exit -F arch=b32 -S unlink,unlinkat,rename,renameat,rmdir -F auid>=1000 -F auid!=-1 -k delete'

# R-270810 UBTU-24-900590
default['ubuntu2404STIG']['stigrule_270810']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270810']['Title'] = "Ubuntu 24.04 LTS must generate audit records for the /var/log/wtmp file."
default['ubuntu2404STIG']['stigrule_270810']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Regexp'] = '^-w /var/log/wtmp -p wa -k logins$'
default['ubuntu2404STIG']['stigrule_270810']['Setting']['_etc_audit_rules_d_stig_rules__var_log_wtmp_Line'] = '-w /var/log/wtmp -p wa -k logins'

# R-270811 UBTU-24-900600
default['ubuntu2404STIG']['stigrule_270811']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270811']['Title'] = "Ubuntu 24.04 LTS must generate audit records for the /var/run/utmp file."
default['ubuntu2404STIG']['stigrule_270811']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Regexp'] = '^-w /var/run/utmp -p wa -k logins$'
default['ubuntu2404STIG']['stigrule_270811']['Setting']['_etc_audit_rules_d_stig_rules__var_run_utmp_Line'] = '-w /var/run/utmp -p wa -k logins'

# R-270812 UBTU-24-900610
default['ubuntu2404STIG']['stigrule_270812']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270812']['Title'] = "Ubuntu 24.04 LTS must generate audit records for the /var/log/btmp file."
default['ubuntu2404STIG']['stigrule_270812']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Regexp'] = '^-w /var/log/btmp -p wa -k logins$'
default['ubuntu2404STIG']['stigrule_270812']['Setting']['_etc_audit_rules_d_stig_rules__var_log_btmp_Line'] = '-w /var/log/btmp -p wa -k logins'

# R-270813 UBTU-24-900730
default['ubuntu2404STIG']['stigrule_270813']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270813']['Title'] = "Ubuntu 24.04 LTS must generate audit records when successful/unsuccessful attempts to use modprobe command."
default['ubuntu2404STIG']['stigrule_270813']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Regexp'] = '^-w /sbin/modprobe -p x -k modules$'
default['ubuntu2404STIG']['stigrule_270813']['Setting']['_etc_audit_rules_d_stig_rules__sbin_modprobe_Line'] = '-w /sbin/modprobe -p x -k modules'

# R-270814 UBTU-24-900740
default['ubuntu2404STIG']['stigrule_270814']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270814']['Title'] = "Ubuntu 24.04 LTS must generate audit records when successful/unsuccessful attempts to use the kmod command."
default['ubuntu2404STIG']['stigrule_270814']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Regexp'] = '^-w /bin/kmod -p x -k modules$'
default['ubuntu2404STIG']['stigrule_270814']['Setting']['_etc_audit_rules_d_stig_rules__bin_kmod_Line'] = '-w /bin/kmod -p x -k modules'

# R-270815 UBTU-24-900750
default['ubuntu2404STIG']['stigrule_270815']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270815']['Title'] = "Ubuntu 24.04 LTS must generate audit records when successful/unsuccessful attempts to use the fdisk command."
default['ubuntu2404STIG']['stigrule_270815']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Regexp'] = '^-w /usr/sbin/fdisk -p x -k fdisk $'
default['ubuntu2404STIG']['stigrule_270815']['Setting']['_etc_audit_rules_d_stig_rules__usr_sbin_fdisk_Line'] = '-w /usr/sbin/fdisk -p x -k fdisk '

# R-270832 UBTU-24-909000
default['ubuntu2404STIG']['stigrule_270832']['Manage'] = true
default['ubuntu2404STIG']['stigrule_270832']['Title'] = "Ubuntu 24.04 LTS audit system must protect auditing rules from unauthorized change."
default['ubuntu2404STIG']['stigrule_270832']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Regexp'] = '^-e 2$'
default['ubuntu2404STIG']['stigrule_270832']['Setting']['_etc_audit_rules_d_audit_rules_e2_Line'] = '-e 2'

# R-274870 UBTU-24-200270
default['ubuntu2404STIG']['stigrule_274870']['Manage'] = true
default['ubuntu2404STIG']['stigrule_274870']['Title'] = "Ubuntu 24.04 LTS must audit any script or executable called by cron as root or by any privileged user."
default['ubuntu2404STIG']['stigrule_274870']['Severity'] = 'medium'
default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Regexp'] = '^-w /etc/cron.d/ -p wa -k cronjobs$'
default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__etc_cron_d__cronjobs_Line'] = '-w /etc/cron.d/ -p wa -k cronjobs'

default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Regexp'] = '^-w /var/spool/cron/ -p wa -k cronjobs$'
default['ubuntu2404STIG']['stigrule_274870']['Setting']['_etc_audit_rules_d_stig_rules__var_spool_cron__cronjobs_Line'] = '-w /var/spool/cron/ -p wa -k cronjobs'

