default['ol9STIG']['XCCDF_result']['Manage'] = true

# R-271441 OL09-00-000025
default['ol9STIG']['stigrule_271441']['Manage'] = true
default['ol9STIG']['stigrule_271441']['Title'] = "OL 9 must require authentication to access emergency mode."
default['ol9STIG']['stigrule_271441']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Path'] = '/usr/lib/systemd/system/emergency.service'
default['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Section'] = 'Service'
default['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Option'] = 'ExecStart'
default['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Value'] = "-/usr/lib/systemd/systemd-sulogin-shell emergency"

# R-271442 OL09-00-000030
default['ol9STIG']['stigrule_271442']['Manage'] = true
default['ol9STIG']['stigrule_271442']['Title'] = "OL 9 must require authentication to access single-user mode."
default['ol9STIG']['stigrule_271442']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Path'] = '/usr/lib/systemd/system/rescue.service'
default['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Section'] = 'Service'
default['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Option'] = 'ExecStart'
default['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Value'] = "-/usr/lib/systemd/systemd-sulogin-shell rescue"

# R-271443 OL09-00-000040
default['ol9STIG']['stigrule_271443']['Manage'] = true
default['ol9STIG']['stigrule_271443']['Title'] = "OL 9 must be configured to disable the Asynchronous Transfer Mode (ATM) kernel module."
default['ol9STIG']['stigrule_271443']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_install_atm__bin_false_Path'] = '/etc/modprobe.d/atm.conf'
default['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_install_atm__bin_false_Line'] = 'install atm /bin/false'

default['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_blacklist_atm_Path'] = '/etc/modprobe.d/atm.conf'
default['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_blacklist_atm_Line'] = 'blacklist atm'

# R-271444 OL09-00-000041
default['ol9STIG']['stigrule_271444']['Manage'] = true
default['ol9STIG']['stigrule_271444']['Title'] = "OL 9 must be configured to disable the Controller Area Network (CAN) kernel module."
default['ol9STIG']['stigrule_271444']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_install_can__bin_false_Path'] = '/etc/modprobe.d/can.conf'
default['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_install_can__bin_false_Line'] = 'install can /bin/false'

default['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_blacklist_can_Path'] = '/etc/modprobe.d/can.conf'
default['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_blacklist_can_Line'] = 'blacklist can'

# R-271445 OL09-00-000042
default['ol9STIG']['stigrule_271445']['Manage'] = true
default['ol9STIG']['stigrule_271445']['Title'] = "OL 9 must be configured to disable the FireWire kernel module."
default['ol9STIG']['stigrule_271445']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path'] = '/etc/modprobe.d/firewire-core.conf'
default['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Line'] = 'install firewire-core /bin/false'

default['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path'] = '/etc/modprobe.d/firewire-core.conf'
default['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Line'] = 'blacklist firewire-core'

# R-271446 OL09-00-000043
default['ol9STIG']['stigrule_271446']['Manage'] = true
default['ol9STIG']['stigrule_271446']['Title'] = "OL 9 must disable the Stream Control Transmission Protocol (SCTP) kernel module."
default['ol9STIG']['stigrule_271446']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path'] = '/etc/modprobe.d/sctp.conf'
default['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_install_sctp__bin_false_Line'] = 'install sctp /bin/false'

default['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_blacklist_sctp_Path'] = '/etc/modprobe.d/sctp.conf'
default['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_blacklist_sctp_Line'] = 'blacklist sctp'

# R-271447 OL09-00-000044
default['ol9STIG']['stigrule_271447']['Manage'] = true
default['ol9STIG']['stigrule_271447']['Title'] = "OL 9 must disable the Transparent Inter Process Communication (TIPC) kernel module."
default['ol9STIG']['stigrule_271447']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path'] = '/etc/modprobe.d/tipc.conf'
default['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_install_tipc__bin_false_Line'] = 'install tipc /bin/false'

default['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_blacklist_tipc_Path'] = '/etc/modprobe.d/tipc.conf'
default['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_blacklist_tipc_Line'] = 'blacklist tipc'

# R-271448 OL09-00-000045
default['ol9STIG']['stigrule_271448']['Manage'] = true
default['ol9STIG']['stigrule_271448']['Title'] = "OL 9 must disable mounting of cramfs."
default['ol9STIG']['stigrule_271448']['Severity'] = 'low'
default['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path'] = '/etc/modprobe.d/cramfs.conf'
default['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Line'] = 'install cramfs /bin/false'

default['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path'] = '/etc/modprobe.d/cramfs.conf'
default['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_blacklist_cramfs_Line'] = 'blacklist cramfs'

# R-271449 OL09-00-000046
default['ol9STIG']['stigrule_271449']['Manage'] = true
default['ol9STIG']['stigrule_271449']['Title'] = "OL 9 Bluetooth must be disabled."
default['ol9STIG']['stigrule_271449']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path'] = '/etc/modprobe.d/bluetooth.conf'
default['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Line'] = 'install bluetooth /bin/false'

default['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path'] = '/etc/modprobe.d/bluetooth.conf'
default['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Line'] = 'blacklist bluetooth'

# R-271450 OL09-00-000047
default['ol9STIG']['stigrule_271450']['Manage'] = true
default['ol9STIG']['stigrule_271450']['Title'] = "OL 9 must be configured to disable USB mass storage."
default['ol9STIG']['stigrule_271450']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path'] = '/etc/modprobe.d/usb-storage.conf'
default['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Line'] = 'install usb-storage /bin/false'

default['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path'] = '/etc/modprobe.d/usb-storage.conf'
default['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Line'] = 'blacklist usb-storage'

# R-271452 OL09-00-000060
default['ol9STIG']['stigrule_271452']['Manage'] = true
default['ol9STIG']['stigrule_271452']['Title'] = "OL 9 must use a Linux Security Module configured to enforce limits on system services."
default['ol9STIG']['stigrule_271452']['Severity'] = 'high'
default['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Path'] = '/etc/selinux/config'
default['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Regexp'] = '^SELINUX='
default['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Line'] = 'SELINUX=enforcing'

# R-271453 OL09-00-000065
default['ol9STIG']['stigrule_271453']['Manage'] = true
default['ol9STIG']['stigrule_271453']['Title'] = "OL 9 must enable the SELinux targeted policy."
default['ol9STIG']['stigrule_271453']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Path'] = '/etc/selinux/config'
default['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Regexp'] = '^SELINUXTYPE='
default['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Line'] = 'SELINUXTYPE=targeted'

# R-271455 OL09-00-000090
default['ol9STIG']['stigrule_271455']['Manage'] = true
default['ol9STIG']['stigrule_271455']['Title'] = "OL 9 must display the Standard Mandatory DOD Notice and Consent Banner before granting local or remote access to the system via a command line user logon."
default['ol9STIG']['stigrule_271455']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271455']['Setting']['_etc_issue_Path'] = '/etc/issue'
default['ol9STIG']['stigrule_271455']['Setting']['_etc_issue_Content'] = 'You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.
By using this IS (which includes any device attached to this IS), you consent to the following conditions:
-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.
-At any time, the USG may inspect and seize data stored on this IS.
-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.
-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.
-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details.
'

# R-271456 OL09-00-000100
default['ol9STIG']['stigrule_271456']['Manage'] = true
default['ol9STIG']['stigrule_271456']['Title'] = "OL 9 must not have the nfs-utils package installed."
default['ol9STIG']['stigrule_271456']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271456']['Setting']['nfs_utils_PackageName'] = 'nfs-utils'
default['ol9STIG']['stigrule_271456']['Setting']['nfs_utils_Action'] = :remove

# R-271457 OL09-00-000105
default['ol9STIG']['stigrule_271457']['Manage'] = true
default['ol9STIG']['stigrule_271457']['Title'] = "OL 9 must not install packages from the Extra Packages for Enterprise Linux (EPEL) repository."
default['ol9STIG']['stigrule_271457']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271457']['Setting']['epel_release_PackageName'] = 'epel-release'
default['ol9STIG']['stigrule_271457']['Setting']['epel_release_Action'] = :remove

# R-271458 OL09-00-000110
default['ol9STIG']['stigrule_271458']['Manage'] = true
default['ol9STIG']['stigrule_271458']['Title'] = "OL 9 must not have the telnet-server package installed."
default['ol9STIG']['stigrule_271458']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271458']['Setting']['telnet_server_PackageName'] = 'telnet-server'
default['ol9STIG']['stigrule_271458']['Setting']['telnet_server_Action'] = :remove

# R-271459 OL09-00-000115
default['ol9STIG']['stigrule_271459']['Manage'] = true
default['ol9STIG']['stigrule_271459']['Title'] = "OL 9 must not have the gssproxy package installed."
default['ol9STIG']['stigrule_271459']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271459']['Setting']['gssproxy_PackageName'] = 'gssproxy'
default['ol9STIG']['stigrule_271459']['Setting']['gssproxy_Action'] = :remove

# R-271460 OL09-00-000120
default['ol9STIG']['stigrule_271460']['Manage'] = true
default['ol9STIG']['stigrule_271460']['Title'] = "OL 9 must not have the iprutils package installed."
default['ol9STIG']['stigrule_271460']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271460']['Setting']['iprutils_PackageName'] = 'iprutils'
default['ol9STIG']['stigrule_271460']['Setting']['iprutils_Action'] = :remove

# R-271461 OL09-00-000125
default['ol9STIG']['stigrule_271461']['Manage'] = true
default['ol9STIG']['stigrule_271461']['Title'] = "OL 9 must not have the tuned package installed."
default['ol9STIG']['stigrule_271461']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271461']['Setting']['tuned_PackageName'] = 'tuned'
default['ol9STIG']['stigrule_271461']['Setting']['tuned_Action'] = :remove

# R-271462 OL09-00-000130
default['ol9STIG']['stigrule_271462']['Manage'] = true
default['ol9STIG']['stigrule_271462']['Title'] = "OL 9 must not have a File Transfer Protocol (FTP) server package installed."
default['ol9STIG']['stigrule_271462']['Severity'] = 'high'
default['ol9STIG']['stigrule_271462']['Setting']['vsftpd_PackageName'] = 'vsftpd'
default['ol9STIG']['stigrule_271462']['Setting']['vsftpd_Action'] = :remove

# R-271463 OL09-00-000135
default['ol9STIG']['stigrule_271463']['Manage'] = true
default['ol9STIG']['stigrule_271463']['Title'] = "OL 9 must not have a Trivial File Transfer Protocol (TFTP) server package installed."
default['ol9STIG']['stigrule_271463']['Severity'] = 'high'
default['ol9STIG']['stigrule_271463']['Setting']['tftp_PackageName'] = 'tftp'
default['ol9STIG']['stigrule_271463']['Setting']['tftp_Action'] = :remove

# R-271464 OL09-00-000140
default['ol9STIG']['stigrule_271464']['Manage'] = true
default['ol9STIG']['stigrule_271464']['Title'] = "OL 9 must not have the quagga package installed."
default['ol9STIG']['stigrule_271464']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271464']['Setting']['quagga_PackageName'] = 'quagga'
default['ol9STIG']['stigrule_271464']['Setting']['quagga_Action'] = :remove

# R-271466 OL09-00-000150
default['ol9STIG']['stigrule_271466']['Manage'] = true
default['ol9STIG']['stigrule_271466']['Title'] = "OL 9 must not have the sendmail package installed."
default['ol9STIG']['stigrule_271466']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271466']['Setting']['sendmail_PackageName'] = 'sendmail'
default['ol9STIG']['stigrule_271466']['Setting']['sendmail_Action'] = :remove

# R-271467 OL09-00-000200
default['ol9STIG']['stigrule_271467']['Manage'] = true
default['ol9STIG']['stigrule_271467']['Title'] = "OL 9 must have policycoreutils package installed."
default['ol9STIG']['stigrule_271467']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271467']['Setting']['policycoreutils_PackageName'] = 'policycoreutils'
default['ol9STIG']['stigrule_271467']['Setting']['policycoreutils_Action'] = :install

# R-271468 OL09-00-000210
default['ol9STIG']['stigrule_271468']['Manage'] = true
default['ol9STIG']['stigrule_271468']['Title'] = "OL 9 policycoreutils-python-utils package must be installed."
default['ol9STIG']['stigrule_271468']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271468']['Setting']['policycoreutils_python_utils_PackageName'] = 'policycoreutils-python-utils'
default['ol9STIG']['stigrule_271468']['Setting']['policycoreutils_python_utils_Action'] = :install

# R-271469 OL09-00-000220
default['ol9STIG']['stigrule_271469']['Manage'] = true
default['ol9STIG']['stigrule_271469']['Title'] = "OL 9 must have the firewalld package installed."
default['ol9STIG']['stigrule_271469']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271469']['Setting']['firewalld_PackageName'] = 'firewalld'
default['ol9STIG']['stigrule_271469']['Setting']['firewalld_Action'] = :install

# R-271470 OL09-00-000221
default['ol9STIG']['stigrule_271470']['Manage'] = true
default['ol9STIG']['stigrule_271470']['Title'] = "OL 9 must be configured so that the firewalld service is active."
default['ol9STIG']['stigrule_271470']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271470']['Setting']['firewalld_enable_ServiceName'] = 'firewalld'
default['ol9STIG']['stigrule_271470']['Setting']['firewalld_enable_Action'] = :enable

default['ol9STIG']['stigrule_271470']['Setting']['firewalld_start_ServiceName'] = 'firewalld'
default['ol9STIG']['stigrule_271470']['Setting']['firewalld_start_Action'] = :start

# R-271474 OL09-00-000230
default['ol9STIG']['stigrule_271474']['Manage'] = true
default['ol9STIG']['stigrule_271474']['Title'] = "OL 9 must have the sudo package installed."
default['ol9STIG']['stigrule_271474']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271474']['Setting']['sudo_PackageName'] = 'sudo'
default['ol9STIG']['stigrule_271474']['Setting']['sudo_Action'] = :install

# R-271477 OL09-00-000240
default['ol9STIG']['stigrule_271477']['Manage'] = true
default['ol9STIG']['stigrule_271477']['Title'] = "OL 9 must have the crypto-policies package installed."
default['ol9STIG']['stigrule_271477']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271477']['Setting']['crypto_policies_PackageName'] = 'crypto-policies'
default['ol9STIG']['stigrule_271477']['Setting']['crypto_policies_Action'] = :install

# R-271482 OL09-00-000250
default['ol9STIG']['stigrule_271482']['Manage'] = true
default['ol9STIG']['stigrule_271482']['Title'] = "OL 9 networked systems must have SSH installed."
default['ol9STIG']['stigrule_271482']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271482']['Setting']['openssh_server_PackageName'] = 'openssh-server'
default['ol9STIG']['stigrule_271482']['Setting']['openssh_server_Action'] = :install

# R-271483 OL09-00-000251
default['ol9STIG']['stigrule_271483']['Manage'] = true
default['ol9STIG']['stigrule_271483']['Title'] = "OL 9 networked systems must have and implement SSH to protect the confidentiality and integrity of transmitted and received information, as well as information during preparation for transmission."
default['ol9STIG']['stigrule_271483']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271483']['Setting']['sshd_enable_ServiceName'] = 'sshd'
default['ol9STIG']['stigrule_271483']['Setting']['sshd_enable_Action'] = :enable

# R-271487 OL09-00-000256
default['ol9STIG']['stigrule_271487']['Manage'] = true
default['ol9STIG']['stigrule_271487']['Title'] = "OL 9 must display the Standard Mandatory DOD Notice and Consent Banner before granting local or remote access to the system via a SSH logon."
default['ol9STIG']['stigrule_271487']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271487']['Setting']['banner_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271487']['Setting']['banner_Regexp'] = '^\s*(?i)banner\s+'
default['ol9STIG']['stigrule_271487']['Setting']['banner_Line'] = 'banner /etc/issue'

# R-271488 OL09-00-000260
default['ol9STIG']['stigrule_271488']['Manage'] = true
default['ol9STIG']['stigrule_271488']['Title'] = "OL 9 must have the openssh-clients package installed."
default['ol9STIG']['stigrule_271488']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271488']['Setting']['openssh_clients_PackageName'] = 'openssh-clients'
default['ol9STIG']['stigrule_271488']['Setting']['openssh_clients_Action'] = :install

# R-271491 OL09-00-000270
default['ol9STIG']['stigrule_271491']['Manage'] = true
default['ol9STIG']['stigrule_271491']['Title'] = "OL 9 must have the openssl-pkcs11 package installed."
default['ol9STIG']['stigrule_271491']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271491']['Setting']['openssl_pkcs11_PackageName'] = 'openssl-pkcs11'
default['ol9STIG']['stigrule_271491']['Setting']['openssl_pkcs11_Action'] = :install

# R-271493 OL09-00-000285
default['ol9STIG']['stigrule_271493']['Manage'] = true
default['ol9STIG']['stigrule_271493']['Title'] = "OL 9 must have the SSSD package installed."
default['ol9STIG']['stigrule_271493']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271493']['Setting']['sssd_PackageName'] = 'sssd'
default['ol9STIG']['stigrule_271493']['Setting']['sssd_Action'] = :install

# R-271494 OL09-00-000286
default['ol9STIG']['stigrule_271494']['Manage'] = true
default['ol9STIG']['stigrule_271494']['Title'] = "OL 9 must use the SSSD package for multifactor authentication services."
default['ol9STIG']['stigrule_271494']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271494']['Setting']['sssd_enable_ServiceName'] = 'sssd'
default['ol9STIG']['stigrule_271494']['Setting']['sssd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271494']['Setting']['sssd_start_ServiceName'] = 'sssd'
default['ol9STIG']['stigrule_271494']['Setting']['sssd_start_Action'] = :start

# R-271495 OL09-00-000290
default['ol9STIG']['stigrule_271495']['Manage'] = true
default['ol9STIG']['stigrule_271495']['Title'] = "OL 9 must have the s-nail package installed."
default['ol9STIG']['stigrule_271495']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271495']['Setting']['s_nail_PackageName'] = 's-nail'
default['ol9STIG']['stigrule_271495']['Setting']['s_nail_Action'] = :install

# R-271501 OL09-00-000310
default['ol9STIG']['stigrule_271501']['Manage'] = true
default['ol9STIG']['stigrule_271501']['Title'] = "OL 9 must have the chrony package installed."
default['ol9STIG']['stigrule_271501']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271501']['Setting']['chrony_PackageName'] = 'chrony'
default['ol9STIG']['stigrule_271501']['Setting']['chrony_Action'] = :install

# R-271502 OL09-00-000311
default['ol9STIG']['stigrule_271502']['Manage'] = true
default['ol9STIG']['stigrule_271502']['Title'] = "OL 9 must enable the chronyd service."
default['ol9STIG']['stigrule_271502']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271502']['Setting']['chronyd_enable_ServiceName'] = 'chronyd'
default['ol9STIG']['stigrule_271502']['Setting']['chronyd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271502']['Setting']['chronyd_start_ServiceName'] = 'chronyd'
default['ol9STIG']['stigrule_271502']['Setting']['chronyd_start_Action'] = :start

# R-271503 OL09-00-000320
default['ol9STIG']['stigrule_271503']['Manage'] = true
default['ol9STIG']['stigrule_271503']['Title'] = "OL 9 must have the USBGuard package installed."
default['ol9STIG']['stigrule_271503']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271503']['Setting']['usbguard_PackageName'] = 'usbguard'
default['ol9STIG']['stigrule_271503']['Setting']['usbguard_Action'] = :install

# R-271504 OL09-00-000321
default['ol9STIG']['stigrule_271504']['Manage'] = false
default['ol9STIG']['stigrule_271504']['Title'] = "OL 9 must enable the USBGuard package."
default['ol9STIG']['stigrule_271504']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271504']['Setting']['usbguard_enable_ServiceName'] = 'usbguard'
default['ol9STIG']['stigrule_271504']['Setting']['usbguard_enable_Action'] = :enable

default['ol9STIG']['stigrule_271504']['Setting']['usbguard_start_ServiceName'] = 'usbguard'
default['ol9STIG']['stigrule_271504']['Setting']['usbguard_start_Action'] = :start

# R-271506 OL09-00-000340
default['ol9STIG']['stigrule_271506']['Manage'] = true
default['ol9STIG']['stigrule_271506']['Title'] = "OL 9 must have the fapolicy module installed."
default['ol9STIG']['stigrule_271506']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271506']['Setting']['fapolicyd_PackageName'] = 'fapolicyd'
default['ol9STIG']['stigrule_271506']['Setting']['fapolicyd_Action'] = :install

# R-271507 OL09-00-000341
default['ol9STIG']['stigrule_271507']['Manage'] = true
default['ol9STIG']['stigrule_271507']['Title'] = "OL 9 must enable the fapolicy module."
default['ol9STIG']['stigrule_271507']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_enable_ServiceName'] = 'fapolicyd'
default['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_start_ServiceName'] = 'fapolicyd'
default['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_start_Action'] = :start

# R-271508 OL09-00-000350
default['ol9STIG']['stigrule_271508']['Manage'] = true
default['ol9STIG']['stigrule_271508']['Title'] = "OL 9 must have the rsyslog package installed."
default['ol9STIG']['stigrule_271508']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271508']['Setting']['rsyslog_PackageName'] = 'rsyslog'
default['ol9STIG']['stigrule_271508']['Setting']['rsyslog_Action'] = :install

# R-271509 OL09-00-000351
default['ol9STIG']['stigrule_271509']['Manage'] = true
default['ol9STIG']['stigrule_271509']['Title'] = "OL 9 must be configured so that the rsyslog service is active."
default['ol9STIG']['stigrule_271509']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271509']['Setting']['rsyslog_enable_ServiceName'] = 'rsyslog'
default['ol9STIG']['stigrule_271509']['Setting']['rsyslog_enable_Action'] = :enable

default['ol9STIG']['stigrule_271509']['Setting']['rsyslog_start_ServiceName'] = 'rsyslog'
default['ol9STIG']['stigrule_271509']['Setting']['rsyslog_start_Action'] = :start

# R-271510 OL09-00-000355
default['ol9STIG']['stigrule_271510']['Manage'] = true
default['ol9STIG']['stigrule_271510']['Title'] = "OL 9 must have the packages required for encrypting offloaded audit logs installed."
default['ol9STIG']['stigrule_271510']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271510']['Setting']['rsyslog_gnutls_PackageName'] = 'rsyslog-gnutls'
default['ol9STIG']['stigrule_271510']['Setting']['rsyslog_gnutls_Action'] = :install

# R-271511 OL09-00-000360
default['ol9STIG']['stigrule_271511']['Manage'] = true
default['ol9STIG']['stigrule_271511']['Title'] = "OL 9 must enable the hardware random number generator entropy gatherer service."
default['ol9STIG']['stigrule_271511']['Severity'] = 'low'
default['ol9STIG']['stigrule_271511']['Setting']['rng_tools_PackageName'] = 'rng-tools'
default['ol9STIG']['stigrule_271511']['Setting']['rng_tools_Action'] = :install

default['ol9STIG']['stigrule_271511']['Setting']['rngd_enable_ServiceName'] = 'rngd'
default['ol9STIG']['stigrule_271511']['Setting']['rngd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271511']['Setting']['rngd_start_ServiceName'] = 'rngd'
default['ol9STIG']['stigrule_271511']['Setting']['rngd_start_Action'] = :start

# R-271512 OL09-00-000370
default['ol9STIG']['stigrule_271512']['Manage'] = true
default['ol9STIG']['stigrule_271512']['Title'] = "OL 9 must have the rng-tools package installed."
default['ol9STIG']['stigrule_271512']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271512']['Setting']['rng_tools_PackageName'] = 'rng-tools'
default['ol9STIG']['stigrule_271512']['Setting']['rng_tools_Action'] = :install

# R-271513 OL09-00-000380
default['ol9STIG']['stigrule_271513']['Manage'] = true
default['ol9STIG']['stigrule_271513']['Title'] = "OL 9 must have the nss-tools package installed."
default['ol9STIG']['stigrule_271513']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271513']['Setting']['nss_tools_PackageName'] = 'nss-tools'
default['ol9STIG']['stigrule_271513']['Setting']['nss_tools_Action'] = :install

# R-271514 OL09-00-000390
default['ol9STIG']['stigrule_271514']['Manage'] = true
default['ol9STIG']['stigrule_271514']['Title'] = "OL 9 must have the pcsc-lite package installed."
default['ol9STIG']['stigrule_271514']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271514']['Setting']['pcsc_lite_PackageName'] = 'pcsc-lite'
default['ol9STIG']['stigrule_271514']['Setting']['pcsc_lite_Action'] = :install

# R-271515 OL09-00-000400
default['ol9STIG']['stigrule_271515']['Manage'] = true
default['ol9STIG']['stigrule_271515']['Title'] = "OL 9 must have the opensc package installed."
default['ol9STIG']['stigrule_271515']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271515']['Setting']['opensc_PackageName'] = 'opensc'
default['ol9STIG']['stigrule_271515']['Setting']['opensc_Action'] = :install

# R-271516 OL09-00-000401
default['ol9STIG']['stigrule_271516']['Manage'] = true
default['ol9STIG']['stigrule_271516']['Title'] = "OL 9 must be configured so that the pcscd service is active."
default['ol9STIG']['stigrule_271516']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271516']['Setting']['pcscd_enable_ServiceName'] = 'pcscd'
default['ol9STIG']['stigrule_271516']['Setting']['pcscd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271516']['Setting']['pcscd_start_ServiceName'] = 'pcscd'
default['ol9STIG']['stigrule_271516']['Setting']['pcscd_start_Action'] = :start

# R-271517 OL09-00-000410
default['ol9STIG']['stigrule_271517']['Manage'] = true
default['ol9STIG']['stigrule_271517']['Title'] = "OL 9 must have the libreswan package installed."
default['ol9STIG']['stigrule_271517']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271517']['Setting']['libreswan_PackageName'] = 'libreswan'
default['ol9STIG']['stigrule_271517']['Setting']['libreswan_Action'] = :install

# R-271518 OL09-00-000430
default['ol9STIG']['stigrule_271518']['Manage'] = false
default['ol9STIG']['stigrule_271518']['Title'] = "OL 9 must have the gnutls-utils package installed."
default['ol9STIG']['stigrule_271518']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271518']['Setting']['gnutls_utils_PackageName'] = 'gnutls-utils'
default['ol9STIG']['stigrule_271518']['Setting']['gnutls_utils_Action'] = :install

# R-271519 OL09-00-000440
default['ol9STIG']['stigrule_271519']['Manage'] = true
default['ol9STIG']['stigrule_271519']['Title'] = "OL 9 must have the audit package installed."
default['ol9STIG']['stigrule_271519']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271519']['Setting']['audit_PackageName'] = 'audit'
default['ol9STIG']['stigrule_271519']['Setting']['audit_Action'] = :install

# R-271520 OL09-00-000441
default['ol9STIG']['stigrule_271520']['Manage'] = true
default['ol9STIG']['stigrule_271520']['Title'] = "OL 9 audit service must be enabled."
default['ol9STIG']['stigrule_271520']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271520']['Setting']['auditd_enable_ServiceName'] = 'auditd'
default['ol9STIG']['stigrule_271520']['Setting']['auditd_enable_Action'] = :enable

default['ol9STIG']['stigrule_271520']['Setting']['auditd_start_ServiceName'] = 'auditd'
default['ol9STIG']['stigrule_271520']['Setting']['auditd_start_Action'] = :start

# R-271521 OL09-00-000450
default['ol9STIG']['stigrule_271521']['Manage'] = true
default['ol9STIG']['stigrule_271521']['Title'] = "OL 9 must have the audispd-plugins package installed."
default['ol9STIG']['stigrule_271521']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271521']['Setting']['audispd_plugins_PackageName'] = 'audispd-plugins'
default['ol9STIG']['stigrule_271521']['Setting']['audispd_plugins_Action'] = :install

# R-271522 OL09-00-000495
default['ol9STIG']['stigrule_271522']['Manage'] = true
default['ol9STIG']['stigrule_271522']['Title'] = "OL 9 must remove all software components after updated versions have been installed."
default['ol9STIG']['stigrule_271522']['Severity'] = 'low'
default['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Path'] = '/etc/dnf/dnf.conf'
default['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Section'] = 'main'
default['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Option'] = 'clean_requirements_on_remove'
default['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Value'] = "1"

# R-271523 OL09-00-000496
default['ol9STIG']['stigrule_271523']['Manage'] = true
default['ol9STIG']['stigrule_271523']['Title'] = "OL 9 must check the GPG signature of locally installed software packages before installation."
default['ol9STIG']['stigrule_271523']['Severity'] = 'high'
default['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Path'] = '/etc/dnf/dnf.conf'
default['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Section'] = 'main'
default['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Option'] = 'localpkg_gpgcheck'
default['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Value'] = "1"

# R-271524 OL09-00-000497
default['ol9STIG']['stigrule_271524']['Manage'] = true
default['ol9STIG']['stigrule_271524']['Title'] = "OL 9 must check the GPG signature of software packages originating from external software repositories before installation."
default['ol9STIG']['stigrule_271524']['Severity'] = 'high'
default['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Path'] = '/etc/dnf/dnf.conf'
default['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Section'] = 'main'
default['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Option'] = 'gpgcheck'
default['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Value'] = "1"

# R-271527 OL09-00-000500
default['ol9STIG']['stigrule_271527']['Manage'] = true
default['ol9STIG']['stigrule_271527']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/sudoers."
default['ol9STIG']['stigrule_271527']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Regexp'] = '^-w /etc/sudoers -p wa -k identity$'
default['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Line'] = '-w /etc/sudoers -p wa -k identity'

# R-271528 OL09-00-000505
default['ol9STIG']['stigrule_271528']['Manage'] = true
default['ol9STIG']['stigrule_271528']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/sudoers.d/ directory."
default['ol9STIG']['stigrule_271528']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Regexp'] = '^-w /etc/sudoers.d/ -p wa -k identity$'
default['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Line'] = '-w /etc/sudoers.d/ -p wa -k identity'

# R-271529 OL09-00-000510
default['ol9STIG']['stigrule_271529']['Manage'] = true
default['ol9STIG']['stigrule_271529']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/group."
default['ol9STIG']['stigrule_271529']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Regexp'] = '^-w /etc/group -p wa -k identity$'
default['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Line'] = '-w /etc/group -p wa -k identity'

# R-271530 OL09-00-000515
default['ol9STIG']['stigrule_271530']['Manage'] = true
default['ol9STIG']['stigrule_271530']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/gshadow."
default['ol9STIG']['stigrule_271530']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Regexp'] = '^-w /etc/gshadow -p wa -k identity$'
default['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Line'] = '-w /etc/gshadow -p wa -k identity'

# R-271531 OL09-00-000520
default['ol9STIG']['stigrule_271531']['Manage'] = true
default['ol9STIG']['stigrule_271531']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/opasswd."
default['ol9STIG']['stigrule_271531']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Regexp'] = '^-w /etc/security/opasswd -p wa -k identity$'
default['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Line'] = '-w /etc/security/opasswd -p wa -k identity'

# R-271532 OL09-00-000525
default['ol9STIG']['stigrule_271532']['Manage'] = true
default['ol9STIG']['stigrule_271532']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/passwd."
default['ol9STIG']['stigrule_271532']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Regexp'] = '^-w /etc/passwd -p wa -k identity$'
default['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Line'] = '-w /etc/passwd -p wa -k identity'

# R-271533 OL09-00-000530
default['ol9STIG']['stigrule_271533']['Manage'] = true
default['ol9STIG']['stigrule_271533']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /etc/shadow."
default['ol9STIG']['stigrule_271533']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Regexp'] = '^-w /etc/shadow -p wa -k identity$'
default['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Line'] = '-w /etc/shadow -p wa -k identity'

# R-271534 OL09-00-000535
default['ol9STIG']['stigrule_271534']['Manage'] = true
default['ol9STIG']['stigrule_271534']['Title'] = "OL 9 must audit all uses of the unix_update command."
default['ol9STIG']['stigrule_271534']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Regexp'] = '^-a always,exit -F path=/usr/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Line'] = '-a always,exit -F path=/usr/sbin/unix_update -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271535 OL09-00-000540
default['ol9STIG']['stigrule_271535']['Manage'] = true
default['ol9STIG']['stigrule_271535']['Title'] = "OL 9 must audit all uses of the su command."
default['ol9STIG']['stigrule_271535']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Regexp'] = '^-a always,exit -F path=/usr/bin/su -F perm=x -F auid>=1000 -F auid!=unset -k privileged-priv_change$'
default['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Line'] = '-a always,exit -F path=/usr/bin/su -F perm=x -F auid>=1000 -F auid!=unset -k privileged-priv_change'

# R-271536 OL09-00-000545
default['ol9STIG']['stigrule_271536']['Manage'] = true
default['ol9STIG']['stigrule_271536']['Title'] = "OL 9 must audit all uses of the setxattr, fsetxattr, lsetxattr, removexattr, fremovexattr, and lremovexattr system calls."
default['ol9STIG']['stigrule_271536']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Regexp'] = '^-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Line'] = '-a always,exit -F arch=b32 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Regexp'] = '^-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod$'
default['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Line'] = '-a always,exit -F arch=b64 -S setxattr,fsetxattr,lsetxattr,removexattr,fremovexattr,lremovexattr -F auid=0 -k perm_mod'

# R-271537 OL09-00-000550
default['ol9STIG']['stigrule_271537']['Manage'] = true
default['ol9STIG']['stigrule_271537']['Title'] = "OL 9 must audit all uses of the chage command."
default['ol9STIG']['stigrule_271537']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Regexp'] = '^-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chage$'
default['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Line'] = '-a always,exit -F path=/usr/bin/chage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-chage'

# R-271538 OL09-00-000555
default['ol9STIG']['stigrule_271538']['Manage'] = true
default['ol9STIG']['stigrule_271538']['Title'] = "OL 9 must audit all uses of the chcon command."
default['ol9STIG']['stigrule_271538']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Regexp'] = '^-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Line'] = '-a always,exit -F path=/usr/bin/chcon -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271539 OL09-00-000560
default['ol9STIG']['stigrule_271539']['Manage'] = true
default['ol9STIG']['stigrule_271539']['Title'] = "OL 9 must audit all uses of the setfacl command."
default['ol9STIG']['stigrule_271539']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Regexp'] = '^-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Line'] = '-a always,exit -F path=/usr/bin/setfacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271540 OL09-00-000565
default['ol9STIG']['stigrule_271540']['Manage'] = true
default['ol9STIG']['stigrule_271540']['Title'] = "OL 9 must audit all uses of the chsh command."
default['ol9STIG']['stigrule_271540']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Regexp'] = '^-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Line'] = '-a always,exit -F path=/usr/bin/chsh -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-271541 OL09-00-000570
default['ol9STIG']['stigrule_271541']['Manage'] = true
default['ol9STIG']['stigrule_271541']['Title'] = "OL 9 must audit all uses of the crontab command."
default['ol9STIG']['stigrule_271541']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Regexp'] = '^-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=unset -k privileged-crontab$'
default['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Line'] = '-a always,exit -F path=/usr/bin/crontab -F perm=x -F auid>=1000 -F auid!=unset -k privileged-crontab'

# R-271542 OL09-00-000575
default['ol9STIG']['stigrule_271542']['Manage'] = true
default['ol9STIG']['stigrule_271542']['Title'] = "OL 9 must audit all uses of the gpasswd command."
default['ol9STIG']['stigrule_271542']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Regexp'] = '^-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-gpasswd$'
default['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Line'] = '-a always,exit -F path=/usr/bin/gpasswd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-gpasswd'

# R-271543 OL09-00-000580
default['ol9STIG']['stigrule_271543']['Manage'] = true
default['ol9STIG']['stigrule_271543']['Title'] = "OL 9 must audit all uses of the newgrp command."
default['ol9STIG']['stigrule_271543']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Regexp'] = '^-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Line'] = '-a always,exit -F path=/usr/bin/newgrp -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-271544 OL09-00-000585
default['ol9STIG']['stigrule_271544']['Manage'] = true
default['ol9STIG']['stigrule_271544']['Title'] = "OL 9 must audit all uses of the pam_timestamp_check command."
default['ol9STIG']['stigrule_271544']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Regexp'] = '^-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=unset -k privileged-pam_timestamp_check$'
default['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Line'] = '-a always,exit -F path=/usr/sbin/pam_timestamp_check -F perm=x -F auid>=1000 -F auid!=unset -k privileged-pam_timestamp_check'

# R-271545 OL09-00-000590
default['ol9STIG']['stigrule_271545']['Manage'] = true
default['ol9STIG']['stigrule_271545']['Title'] = "OL 9 must audit all uses of the passwd command."
default['ol9STIG']['stigrule_271545']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Regexp'] = '^-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-passwd$'
default['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Line'] = '-a always,exit -F path=/usr/bin/passwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-passwd'

# R-271546 OL09-00-000595
default['ol9STIG']['stigrule_271546']['Manage'] = true
default['ol9STIG']['stigrule_271546']['Title'] = "OL 9 must audit all uses of the postdrop command."
default['ol9STIG']['stigrule_271546']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Regexp'] = '^-a always,exit -F path=/usr/sbin/postdrop -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Line'] = '-a always,exit -F path=/usr/sbin/postdrop -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271547 OL09-00-000600
default['ol9STIG']['stigrule_271547']['Manage'] = true
default['ol9STIG']['stigrule_271547']['Title'] = "OL 9 must audit all uses of the postqueue command."
default['ol9STIG']['stigrule_271547']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Regexp'] = '^-a always,exit -F path=/usr/sbin/postqueue -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Line'] = '-a always,exit -F path=/usr/sbin/postqueue -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271548 OL09-00-000605
default['ol9STIG']['stigrule_271548']['Manage'] = true
default['ol9STIG']['stigrule_271548']['Title'] = "OL 9 must audit all uses of the ssh-agent command."
default['ol9STIG']['stigrule_271548']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Regexp'] = '^-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh$'
default['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Line'] = '-a always,exit -F path=/usr/bin/ssh-agent -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh'

# R-271549 OL09-00-000610
default['ol9STIG']['stigrule_271549']['Manage'] = true
default['ol9STIG']['stigrule_271549']['Title'] = "OL 9 must audit all uses of the ssh-keysign command."
default['ol9STIG']['stigrule_271549']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Regexp'] = '^-a always,exit -F path=/usr/libexec/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh$'
default['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Line'] = '-a always,exit -F path=/usr/libexec/openssh/ssh-keysign -F perm=x -F auid>=1000 -F auid!=unset -k privileged-ssh'

# R-271550 OL09-00-000615
default['ol9STIG']['stigrule_271550']['Manage'] = true
default['ol9STIG']['stigrule_271550']['Title'] = "OL 9 must audit all uses of the sudoedit command."
default['ol9STIG']['stigrule_271550']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Regexp'] = '^-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Line'] = '-a always,exit -F path=/usr/bin/sudoedit -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-271551 OL09-00-000620
default['ol9STIG']['stigrule_271551']['Manage'] = true
default['ol9STIG']['stigrule_271551']['Title'] = "OL 9 must audit all uses of the unix_chkpwd command."
default['ol9STIG']['stigrule_271551']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Regexp'] = '^-a always,exit -F path=/usr/sbin/unix_chkpwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Line'] = '-a always,exit -F path=/usr/sbin/unix_chkpwd -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271552 OL09-00-000625
default['ol9STIG']['stigrule_271552']['Manage'] = true
default['ol9STIG']['stigrule_271552']['Title'] = "OL 9 must audit all uses of the userhelper command."
default['ol9STIG']['stigrule_271552']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Regexp'] = '^-a always,exit -F path=/usr/sbin/userhelper -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Line'] = '-a always,exit -F path=/usr/sbin/userhelper -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271553 OL09-00-000630
default['ol9STIG']['stigrule_271553']['Manage'] = true
default['ol9STIG']['stigrule_271553']['Title'] = "OL 9 must audit all uses of the mount command."
default['ol9STIG']['stigrule_271553']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Regexp'] = '^-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount$'
default['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Line'] = '-a always,exit -F path=/usr/bin/mount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount'

# R-271554 OL09-00-000635
default['ol9STIG']['stigrule_271554']['Manage'] = true
default['ol9STIG']['stigrule_271554']['Title'] = "OL 9 must audit all uses of the truncate, ftruncate, creat, open, openat, and open_by_handle_at system calls."
default['ol9STIG']['stigrule_271554']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Regexp'] = '^-a always,exit -F arch=b32 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access$'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Line'] = '-a always,exit -F arch=b32 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access'

default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Regexp'] = '^-a always,exit -F arch=b64 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access$'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Line'] = '-a always,exit -F arch=b64 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=unset -k perm_access'

default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Regexp'] = '^-a always,exit -F arch=b32 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access$'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Line'] = '-a always,exit -F arch=b32 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access'

default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Regexp'] = '^-a always,exit -F arch=b64 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access$'
default['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Line'] = '-a always,exit -F arch=b64 -S truncate,ftruncate,creat,open,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=unset -k perm_access'

# R-271555 OL09-00-000640
default['ol9STIG']['stigrule_271555']['Manage'] = true
default['ol9STIG']['stigrule_271555']['Title'] = "OL 9 must audit all uses of the chmod, fchmod, and fchmodat system calls."
default['ol9STIG']['stigrule_271555']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Regexp'] = '^-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Line'] = '-a always,exit -F arch=b32 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Regexp'] = '^-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Line'] = '-a always,exit -F arch=b64 -S chmod,fchmod,fchmodat -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271556 OL09-00-000645
default['ol9STIG']['stigrule_271556']['Manage'] = true
default['ol9STIG']['stigrule_271556']['Title'] = "OL 9 must audit all uses of the chown, fchown, fchownat, and lchown system calls."
default['ol9STIG']['stigrule_271556']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Regexp'] = '^-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Line'] = '-a always,exit -F arch=b32 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Regexp'] = '^-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Line'] = '-a always,exit -F arch=b64 -S chown,fchown,fchownat,lchown -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271557 OL09-00-000650
default['ol9STIG']['stigrule_271557']['Manage'] = true
default['ol9STIG']['stigrule_271557']['Title'] = "OL 9 must audit all uses of the semanage command."
default['ol9STIG']['stigrule_271557']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Regexp'] = '^-a always,exit -F path=/usr/sbin/semanage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Line'] = '-a always,exit -F path=/usr/sbin/semanage -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271558 OL09-00-000655
default['ol9STIG']['stigrule_271558']['Manage'] = true
default['ol9STIG']['stigrule_271558']['Title'] = "OL 9 must audit all uses of the setfiles command."
default['ol9STIG']['stigrule_271558']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Regexp'] = '^-a always,exit -F path=/usr/sbin/setfiles -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Line'] = '-a always,exit -F path=/usr/sbin/setfiles -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271559 OL09-00-000660
default['ol9STIG']['stigrule_271559']['Manage'] = true
default['ol9STIG']['stigrule_271559']['Title'] = "OL 9 must audit all uses of the setsebool command."
default['ol9STIG']['stigrule_271559']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Regexp'] = '^-a always,exit -F path=/usr/sbin/setsebool -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update$'
default['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Line'] = '-a always,exit -F path=/usr/sbin/setsebool -F perm=x -F auid>=1000 -F auid!=unset -k privileged-unix-update'

# R-271560 OL09-00-000665
default['ol9STIG']['stigrule_271560']['Manage'] = true
default['ol9STIG']['stigrule_271560']['Title'] = "OL 9 must audit all uses of the chacl command."
default['ol9STIG']['stigrule_271560']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Regexp'] = '^-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Line'] = '-a always,exit -F path=/usr/bin/chacl -F perm=x -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271561 OL09-00-000670
default['ol9STIG']['stigrule_271561']['Manage'] = true
default['ol9STIG']['stigrule_271561']['Title'] = "OL 9 must audit all uses of the sudo command."
default['ol9STIG']['stigrule_271561']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Regexp'] = '^-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd$'
default['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Line'] = '-a always,exit -F path=/usr/bin/sudo -F perm=x -F auid>=1000 -F auid!=unset -k priv_cmd'

# R-271562 OL09-00-000675
default['ol9STIG']['stigrule_271562']['Manage'] = true
default['ol9STIG']['stigrule_271562']['Title'] = "OL 9 must audit all uses of the usermod command."
default['ol9STIG']['stigrule_271562']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Regexp'] = '^-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=unset -k privileged-usermod$'
default['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Line'] = '-a always,exit -F path=/usr/sbin/usermod -F perm=x -F auid>=1000 -F auid!=unset -k privileged-usermod'

# R-271563 OL09-00-000680
default['ol9STIG']['stigrule_271563']['Manage'] = true
default['ol9STIG']['stigrule_271563']['Title'] = "OL 9 must audit all uses of the rename, unlink, rmdir, renameat, and unlinkat system calls."
default['ol9STIG']['stigrule_271563']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Regexp'] = '^-a always,exit -F arch=b32 -S rename,unlink,rmdir,renameat,unlinkat -F success=1 -F auid>=1000 -F auid!=unset -k delete$'
default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Line'] = '-a always,exit -F arch=b32 -S rename,unlink,rmdir,renameat,unlinkat -F success=1 -F auid>=1000 -F auid!=unset -k delete'

default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Regexp'] = '^-a always,exit -F arch=b64 -S rename,unlink,rmdir,renameat,unlinkat -F success=1 -F auid>=1000 -F auid!=unset -k delete$'
default['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Line'] = '-a always,exit -F arch=b64 -S rename,unlink,rmdir,renameat,unlinkat -F success=1 -F auid>=1000 -F auid!=unset -k delete'

# R-271564 OL09-00-000685
default['ol9STIG']['stigrule_271564']['Manage'] = true
default['ol9STIG']['stigrule_271564']['Title'] = "OL 9 must audit all uses of the delete_module system call."
default['ol9STIG']['stigrule_271564']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Regexp'] = '^-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Line'] = '-a always,exit -F arch=b32 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng'

default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Regexp'] = '^-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Line'] = '-a always,exit -F arch=b64 -S delete_module -F auid>=1000 -F auid!=unset -k module_chng'

# R-271565 OL09-00-000690
default['ol9STIG']['stigrule_271565']['Manage'] = true
default['ol9STIG']['stigrule_271565']['Title'] = "OL 9 must audit all uses of the init_module and finit_module system calls."
default['ol9STIG']['stigrule_271565']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Regexp'] = '^-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Line'] = '-a always,exit -F arch=b32 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng'

default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Regexp'] = '^-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng$'
default['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Line'] = '-a always,exit -F arch=b64 -S init_module,finit_module -F auid>=1000 -F auid!=unset -k module_chng'

# R-271566 OL09-00-000695
default['ol9STIG']['stigrule_271566']['Manage'] = true
default['ol9STIG']['stigrule_271566']['Title'] = "OL 9 must audit all uses of the kmod command."
default['ol9STIG']['stigrule_271566']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Regexp'] = '^-a always,exit -F path=/usr/bin/kmod -F perm=x -F auid>=1000 -F auid!=unset -k modules$'
default['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Line'] = '-a always,exit -F path=/usr/bin/kmod -F perm=x -F auid>=1000 -F auid!=unset -k modules'

# R-271567 OL09-00-000700
default['ol9STIG']['stigrule_271567']['Manage'] = true
default['ol9STIG']['stigrule_271567']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /var/log/lastlog."
default['ol9STIG']['stigrule_271567']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Regexp'] = '^-w /var/log/lastlog -p wa -k logins$'
default['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Line'] = '-w /var/log/lastlog -p wa -k logins'

# R-271568 OL09-00-000705
default['ol9STIG']['stigrule_271568']['Manage'] = true
default['ol9STIG']['stigrule_271568']['Title'] = "OL 9 must audit all uses of umount system calls."
default['ol9STIG']['stigrule_271568']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Regexp'] = '^-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount$'
default['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Line'] = '-a always,exit -F path=/usr/bin/umount -F perm=x -F auid>=1000 -F auid!=unset -k privileged-mount'

# R-271570 OL09-00-000715
default['ol9STIG']['stigrule_271570']['Manage'] = true
default['ol9STIG']['stigrule_271570']['Title'] = "OL 9 must audit uses of the execve system call."
default['ol9STIG']['stigrule_271570']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 key=execpriv$'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Line'] = '-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 key=execpriv'

default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 key=execpriv $'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Line'] = '-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 key=execpriv '

default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Regexp'] = '^-a always,exit -F arch=b32 -S execve -C gid!=egid -F euid=0 key=execpriv$'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Line'] = '-a always,exit -F arch=b32 -S execve -C gid!=egid -F euid=0 key=execpriv'

default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Regexp'] = '^-a always,exit -F arch=b64 -S execve -C gid!=egid -F euid=0 key=execpriv$'
default['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Line'] = '-a always,exit -F arch=b64 -S execve -C gid!=egid -F euid=0 key=execpriv'

# R-271571 OL09-00-000720
default['ol9STIG']['stigrule_271571']['Manage'] = true
default['ol9STIG']['stigrule_271571']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /var/log/faillock."
default['ol9STIG']['stigrule_271571']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Regexp'] = '^-w /var/log/faillock -p wa -k logins$'
default['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Line'] = '-w /var/log/faillock -p wa -k logins'

# R-271572 OL09-00-000725
default['ol9STIG']['stigrule_271572']['Manage'] = true
default['ol9STIG']['stigrule_271572']['Title'] = "OL 9 must generate audit records for all account creations, modifications, disabling, and termination events that affect /var/log/tallylog."
default['ol9STIG']['stigrule_271572']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Regexp'] = '^-w /var/log/tallylog -p wa -k logins$'
default['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Line'] = '-w /var/log/tallylog -p wa -k logins'

# R-271573 OL09-00-000730
default['ol9STIG']['stigrule_271573']['Manage'] = true
default['ol9STIG']['stigrule_271573']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the init command generate an audit record."
default['ol9STIG']['stigrule_271573']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Regexp'] = '^-a always,exit -F path=/usr/sbin/init -F perm=x -F auid>=1000 -F auid!=unset -k privileged-init$'
default['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Line'] = '-a always,exit -F path=/usr/sbin/init -F perm=x -F auid>=1000 -F auid!=unset -k privileged-init'

# R-271574 OL09-00-000735
default['ol9STIG']['stigrule_271574']['Manage'] = true
default['ol9STIG']['stigrule_271574']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the poweroff command generate an audit record."
default['ol9STIG']['stigrule_271574']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Regexp'] = '^-a always,exit -F path=/usr/sbin/poweroff -F perm=x -F auid>=1000 -F auid!=unset -k privileged-poweroff$'
default['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Line'] = '-a always,exit -F path=/usr/sbin/poweroff -F perm=x -F auid>=1000 -F auid!=unset -k privileged-poweroff'

# R-271575 OL09-00-000740
default['ol9STIG']['stigrule_271575']['Manage'] = true
default['ol9STIG']['stigrule_271575']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the reboot command generate an audit record."
default['ol9STIG']['stigrule_271575']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Regexp'] = '^-a always,exit -F path=/usr/sbin/reboot -F perm=x -F auid>=1000 -F auid!=unset -k privileged-reboot$'
default['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Line'] = '-a always,exit -F path=/usr/sbin/reboot -F perm=x -F auid>=1000 -F auid!=unset -k privileged-reboot'

# R-271576 OL09-00-000745
default['ol9STIG']['stigrule_271576']['Manage'] = true
default['ol9STIG']['stigrule_271576']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the shutdown command generate an audit record."
default['ol9STIG']['stigrule_271576']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Regexp'] = '^-a always,exit -F path=/usr/sbin/shutdown -F perm=x -F auid>=1000 -F auid!=unset -k privileged-shutdown$'
default['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Line'] = '-a always,exit -F path=/usr/sbin/shutdown -F perm=x -F auid>=1000 -F auid!=unset -k privileged-shutdown'

# R-271578 OL09-00-000755
default['ol9STIG']['stigrule_271578']['Manage'] = true
default['ol9STIG']['stigrule_271578']['Title'] = "OL 9 must label all offloaded audit logs before sending them to the central log server."
default['ol9STIG']['stigrule_271578']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^name_format = '
default['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Line'] = 'name_format = hostname'

# R-271579 OL09-00-000760
default['ol9STIG']['stigrule_271579']['Manage'] = true
default['ol9STIG']['stigrule_271579']['Title'] = "OL 9 audit system must take appropriate action when an error writing to the audit storage volume occurs."
default['ol9STIG']['stigrule_271579']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^disk_error_action = '
default['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Line'] = 'disk_error_action = HALT'

# R-271580 OL09-00-000765
default['ol9STIG']['stigrule_271580']['Manage'] = true
default['ol9STIG']['stigrule_271580']['Title'] = "OL 9 audit system must take appropriate action when the audit storage volume is full."
default['ol9STIG']['stigrule_271580']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^disk_full_action = '
default['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Line'] = 'disk_full_action = HALT'

# R-271581 OL09-00-000770
default['ol9STIG']['stigrule_271581']['Manage'] = true
default['ol9STIG']['stigrule_271581']['Title'] = "OL 9 audit system must take appropriate action when the audit files have reached maximum size."
default['ol9STIG']['stigrule_271581']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^max_log_file_action = '
default['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Line'] = 'max_log_file_action = ROTATE'

# R-271582 OL09-00-000775
default['ol9STIG']['stigrule_271582']['Manage'] = true
default['ol9STIG']['stigrule_271582']['Title'] = "OL 9 must periodically flush audit records to disk to prevent the loss of audit records."
default['ol9STIG']['stigrule_271582']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^freq = '
default['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Line'] = 'freq = 100'

# R-271586 OL09-00-000800
default['ol9STIG']['stigrule_271586']['Manage'] = true
default['ol9STIG']['stigrule_271586']['Title'] = "OL 9 audit system must audit local events."
default['ol9STIG']['stigrule_271586']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^local_events = '
default['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Line'] = 'local_events = yes'

# R-271589 OL09-00-000815
default['ol9STIG']['stigrule_271589']['Manage'] = true
default['ol9STIG']['stigrule_271589']['Title'] = "OL 9 must forward mail from postmaster to the root account using a postfix alias."
default['ol9STIG']['stigrule_271589']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Path'] = '/etc/aliases'
default['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Regexp'] = '^postmaster:'
default['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Line'] = 'postmaster: root'

# R-271590 OL09-00-000820
default['ol9STIG']['stigrule_271590']['Manage'] = true
default['ol9STIG']['stigrule_271590']['Title'] = "OL 9 must take appropriate action when a critical audit processing failure occurs."
default['ol9STIG']['stigrule_271590']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Regexp'] = '^-f 2$'
default['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Line'] = '-f 2'

# R-271591 OL09-00-000825
default['ol9STIG']['stigrule_271591']['Manage'] = true
default['ol9STIG']['stigrule_271591']['Title'] = "The OL 9 system administrator (SA) and/or information system security officer (ISSO) (at a minimum) must be alerted of an audit processing failure event."
default['ol9STIG']['stigrule_271591']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^action_mail_acct = '
default['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Line'] = 'action_mail_acct = root'

# R-271593 OL09-00-000835
default['ol9STIG']['stigrule_271593']['Manage'] = true
default['ol9STIG']['stigrule_271593']['Title'] = "OL 9 must produce audit records containing information to establish the identity of any individual or process associated with the event."
default['ol9STIG']['stigrule_271593']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^log_format = '
default['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Line'] = 'log_format = ENRICHED'

# R-271594 OL09-00-000840
default['ol9STIG']['stigrule_271594']['Manage'] = true
default['ol9STIG']['stigrule_271594']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the umount system call generate an audit record."
default['ol9STIG']['stigrule_271594']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Regexp'] = '^-a always,exit -F arch=b32 -S umount -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Line'] = '-a always,exit -F arch=b32 -S umount -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Regexp'] = '^-a always,exit -F arch=b64 -S umount -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Line'] = '-a always,exit -F arch=b64 -S umount -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271595 OL09-00-000845
default['ol9STIG']['stigrule_271595']['Manage'] = true
default['ol9STIG']['stigrule_271595']['Title'] = "OL 9 must be configured so that successful/unsuccessful uses of the umount2 system call generate an audit record."
default['ol9STIG']['stigrule_271595']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Regexp'] = '^-a always,exit -F arch=b32 -S umount2 -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Line'] = '-a always,exit -F arch=b32 -S umount2 -F auid>=1000 -F auid!=unset -k perm_mod'

default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Regexp'] = '^-a always,exit -F arch=b64 -S umount2 -F auid>=1000 -F auid!=unset -k perm_mod$'
default['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Line'] = '-a always,exit -F arch=b64 -S umount2 -F auid>=1000 -F auid!=unset -k perm_mod'

# R-271597 OL09-00-000855
default['ol9STIG']['stigrule_271597']['Manage'] = true
default['ol9STIG']['stigrule_271597']['Title'] = "OL 9 must be configured to offload audit records onto a different system from the system being audited via syslog."
default['ol9STIG']['stigrule_271597']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Path'] = '/etc/audit/plugins.d/syslog.conf'
default['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Regexp'] = '^active = '
default['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Line'] = 'active = yes'

# R-271598 OL09-00-000860
default['ol9STIG']['stigrule_271598']['Manage'] = true
default['ol9STIG']['stigrule_271598']['Title'] = "OL 9 must take appropriate action when the internal event queue is full."
default['ol9STIG']['stigrule_271598']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^overflow_action = '
default['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Line'] = 'overflow_action = syslog'

# R-271599 OL09-00-000865
default['ol9STIG']['stigrule_271599']['Manage'] = true
default['ol9STIG']['stigrule_271599']['Title'] = "OL 9 must take action when allocated audit record storage volume reaches 75 percent of the repository maximum audit record storage capacity."
default['ol9STIG']['stigrule_271599']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Regexp'] = '^space_left = '
default['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Line'] = 'space_left = 25%'

# R-271600 OL09-00-000870
default['ol9STIG']['stigrule_271600']['Manage'] = true
default['ol9STIG']['stigrule_271600']['Title'] = "OL 9 must notify the system administrator (SA) and information system security officer (ISSO) (at a minimum) when allocated audit record storage volume reaches 75 percent utilization."
default['ol9STIG']['stigrule_271600']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Regexp'] = '^space_left_action = '
default['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Line'] = 'space_left_action = email'

# R-271601 OL09-00-000875
default['ol9STIG']['stigrule_271601']['Manage'] = true
default['ol9STIG']['stigrule_271601']['Title'] = "OL 9 must take action when allocated audit record storage volume reaches 95 percent of the audit record storage capacity."
default['ol9STIG']['stigrule_271601']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Regexp'] = '^admin_space_left = '
default['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Line'] = 'admin_space_left = 25%'

# R-271602 OL09-00-000880
default['ol9STIG']['stigrule_271602']['Manage'] = true
default['ol9STIG']['stigrule_271602']['Title'] = "OL 9 must write audit records to disk."
default['ol9STIG']['stigrule_271602']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Regexp'] = '^write_logs = '
default['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Line'] = 'write_logs = yes'

# R-271603 OL09-00-000885
default['ol9STIG']['stigrule_271603']['Manage'] = true
default['ol9STIG']['stigrule_271603']['Title'] = "OL 9 must act when allocated audit record storage volume reaches 95 percent of the repository maximum audit record storage capacity."
default['ol9STIG']['stigrule_271603']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Path'] = '/etc/audit/auditd.conf'
default['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Regexp'] = '^admin_space_left_action = '
default['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Line'] = 'admin_space_left_action = single'

# R-271607 OL09-00-000925
default['ol9STIG']['stigrule_271607']['Manage'] = true
default['ol9STIG']['stigrule_271607']['Title'] = "OL 9 must enable certificate-based smart card authentication."
default['ol9STIG']['stigrule_271607']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Path'] = '/etc/sssd/sssd.conf'
default['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Section'] = 'pam'
default['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Option'] = 'pam_cert_auth'
default['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Value'] = "True"

# R-271609 OL09-00-000935
default['ol9STIG']['stigrule_271609']['Manage'] = true
default['ol9STIG']['stigrule_271609']['Title'] = "OL 9 must prohibit the use of cached authenticators after one day."
default['ol9STIG']['stigrule_271609']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Path'] = '/etc/sssd/sssd.conf'
default['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Section'] = 'pam'
default['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Option'] = 'offline_credentials_expiration'
default['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Value'] = "1"

# R-271610 OL09-00-000940
default['ol9STIG']['stigrule_271610']['Manage'] = true
default['ol9STIG']['stigrule_271610']['Title'] = "OL 9 must use the CAC smart card driver."
default['ol9STIG']['stigrule_271610']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Path'] = '/etc/opensc.conf'
default['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Regexp'] = '^\s*card_drivers\s*='
default['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Line'] = 'card_drivers = cac;'

# R-271613 OL09-00-001005
default['ol9STIG']['stigrule_271613']['Manage'] = true
default['ol9STIG']['stigrule_271613']['Title'] = "OL 9 must enforce password complexity by requiring that at least one uppercase character be used."
default['ol9STIG']['stigrule_271613']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ucredit'
default['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Line'] = 'ucredit = -1'

# R-271615 OL09-00-001015
default['ol9STIG']['stigrule_271615']['Manage'] = true
default['ol9STIG']['stigrule_271615']['Title'] = "OL 9 must enforce password complexity by requiring that at least one lowercase character be used."
default['ol9STIG']['stigrule_271615']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*lcredit'
default['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Line'] = 'lcredit = -1'

# R-271616 OL09-00-001020
default['ol9STIG']['stigrule_271616']['Manage'] = true
default['ol9STIG']['stigrule_271616']['Title'] = "OL 9 must enforce password complexity by requiring that at least one numeric character be used."
default['ol9STIG']['stigrule_271616']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dcredit'
default['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Line'] = 'dcredit = -1'

# R-271617 OL09-00-001025
default['ol9STIG']['stigrule_271617']['Manage'] = true
default['ol9STIG']['stigrule_271617']['Title'] = "OL 9 must require the change of at least eight characters when passwords are changed."
default['ol9STIG']['stigrule_271617']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*difok'
default['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Line'] = 'difok = 8'

# R-271618 OL09-00-001030
default['ol9STIG']['stigrule_271618']['Manage'] = true
default['ol9STIG']['stigrule_271618']['Title'] = "OL 9 must require the maximum number of repeating characters of the same character class be limited to four when passwords are changed."
default['ol9STIG']['stigrule_271618']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*maxclassrepeat'
default['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Line'] = 'maxclassrepeat = 4'

# R-271619 OL09-00-001035
default['ol9STIG']['stigrule_271619']['Manage'] = true
default['ol9STIG']['stigrule_271619']['Title'] = "OL 9 must require the maximum number of repeating characters be limited to three when passwords are changed."
default['ol9STIG']['stigrule_271619']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*maxrepeat'
default['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Line'] = 'maxrepeat = 3'

# R-271620 OL09-00-001040
default['ol9STIG']['stigrule_271620']['Manage'] = true
default['ol9STIG']['stigrule_271620']['Title'] = "OL 9 must require the change of at least four character classes when passwords are changed."
default['ol9STIG']['stigrule_271620']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*minclass'
default['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Line'] = 'minclass = 4'

# R-271621 OL09-00-001045
default['ol9STIG']['stigrule_271621']['Manage'] = true
default['ol9STIG']['stigrule_271621']['Title'] = "OL 9 must enforce password complexity rules for the root account."
default['ol9STIG']['stigrule_271621']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*enforce_for_root'
default['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Line'] = 'enforce_for_root'

# R-271622 OL09-00-001050
default['ol9STIG']['stigrule_271622']['Manage'] = true
default['ol9STIG']['stigrule_271622']['Title'] = "OL 9 must be configured so that user and group account administration utilities are configured to store only encrypted representations of passwords."
default['ol9STIG']['stigrule_271622']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Path'] = '/etc/libuser.conf'
default['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Section'] = 'defaults'
default['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Option'] = 'crypt_style'
default['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Value'] = "sha512"

# R-271623 OL09-00-001055
default['ol9STIG']['stigrule_271623']['Manage'] = true
default['ol9STIG']['stigrule_271623']['Title'] = "OL 9 must be configured to use the shadow file to store only encrypted representations of passwords."
default['ol9STIG']['stigrule_271623']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Regexp'] = '^ENCRYPT_METHOD'
default['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Line'] = 'ENCRYPT_METHOD SHA512'

# R-271627 OL09-00-001075
default['ol9STIG']['stigrule_271627']['Manage'] = true
default['ol9STIG']['stigrule_271627']['Title'] = "OL 9 shadow password suite must be configured to use a sufficient number of hashing rounds."
default['ol9STIG']['stigrule_271627']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Regexp'] = '^SHA_CRYPT_MIN_ROUNDS'
default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Line'] = 'SHA_CRYPT_MIN_ROUNDS 10000'

default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Regexp'] = '^SHA_CRYPT_MAX_ROUNDS'
default['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Line'] = 'SHA_CRYPT_MAX_ROUNDS 10000'

# R-271629 OL09-00-001085
default['ol9STIG']['stigrule_271629']['Manage'] = true
default['ol9STIG']['stigrule_271629']['Title'] = "OL 9 passwords for new users or password changes must have a 24-hour minimum password lifetime restriction in /etc/login.defs."
default['ol9STIG']['stigrule_271629']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MIN_DAYS'
default['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Line'] = 'PASS_MIN_DAYS 1'

# R-271631 OL09-00-001095
default['ol9STIG']['stigrule_271631']['Manage'] = true
default['ol9STIG']['stigrule_271631']['Title'] = "OL 9 user account passwords for new users or password changes must have a 60-day maximum password lifetime restriction in /etc/login.defs."
default['ol9STIG']['stigrule_271631']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Regexp'] = '^PASS_MAX_DAYS'
default['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Line'] = 'PASS_MAX_DAYS 60'

# R-271633 OL09-00-001105
default['ol9STIG']['stigrule_271633']['Manage'] = true
default['ol9STIG']['stigrule_271633']['Title'] = "OL 9 passwords must be created with a minimum of 15 characters."
default['ol9STIG']['stigrule_271633']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*minlen'
default['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Line'] = 'minlen = 15'

# R-271636 OL09-00-001120
default['ol9STIG']['stigrule_271636']['Manage'] = true
default['ol9STIG']['stigrule_271636']['Title'] = "OL 9 must enforce password complexity by requiring that at least one special character be used."
default['ol9STIG']['stigrule_271636']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*ocredit'
default['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Line'] = 'ocredit = -1'

# R-271637 OL09-00-001125
default['ol9STIG']['stigrule_271637']['Manage'] = true
default['ol9STIG']['stigrule_271637']['Title'] = "OL 9 must prevent the use of dictionary words for passwords."
default['ol9STIG']['stigrule_271637']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Path'] = '/etc/security/pwquality.conf'
default['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Regexp'] = '^\s*dictcheck'
default['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Line'] = 'dictcheck = 1'

# R-271639 OL09-00-002000
default['ol9STIG']['stigrule_271639']['Manage'] = true
default['ol9STIG']['stigrule_271639']['Title'] = "OL 9 file system automount function must be disabled unless required."
default['ol9STIG']['stigrule_271639']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271639']['Setting']['autofs_service_disable_UnitName'] = 'autofs.service'
default['ol9STIG']['stigrule_271639']['Setting']['autofs_service_disable_Action'] = :disable

default['ol9STIG']['stigrule_271639']['Setting']['autofs_service_mask_UnitName'] = 'autofs.service'
default['ol9STIG']['stigrule_271639']['Setting']['autofs_service_mask_Action'] = [:mask, :stop]

# R-271670 OL09-00-002100
default['ol9STIG']['stigrule_271670']['Manage'] = true
default['ol9STIG']['stigrule_271670']['Title'] = "OL 9 must disable the graphical user interface automount function unless required."
default['ol9STIG']['stigrule_271670']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path'] = '/etc/dconf/db/local.d/00-security-settings'
default['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section'] = 'org/gnome/desktop/media-handling'
default['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option'] = 'automount-open'
default['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value'] = "false"
default['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if'] = "rpm -q dconf"

# R-271671 OL09-00-002101
default['ol9STIG']['stigrule_271671']['Manage'] = true
default['ol9STIG']['stigrule_271671']['Title'] = "OL 9 must disable the graphical user interface autorun function unless required."
default['ol9STIG']['stigrule_271671']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path'] = '/etc/dconf/db/local.d/00-security-settings'
default['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section'] = 'org/gnome/desktop/media-handling'
default['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option'] = 'autorun-never'
default['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value'] = "true"
default['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if'] = "rpm -q dconf"

# R-271672 OL09-00-002102
default['ol9STIG']['stigrule_271672']['Manage'] = true
default['ol9STIG']['stigrule_271672']['Title'] = "OL 9 must disable the user list at logon for graphical user interfaces."
default['ol9STIG']['stigrule_271672']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Path'] = '/etc/dconf/db/local.d/02-login-screen'
default['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Section'] = 'org/gnome/login-screen'
default['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Option'] = 'disable-user-list'
default['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Value'] = "true"
default['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Only_if'] = "rpm -q dconf"

# R-271673 OL09-00-002103
default['ol9STIG']['stigrule_271673']['Manage'] = true
default['ol9STIG']['stigrule_271673']['Title'] = "OL 9 must initiate a session lock for graphical user interfaces when the screensaver is activated."
default['ol9STIG']['stigrule_271673']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Section'] = 'org/gnome/desktop/screensaver'
default['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Option'] = 'lock-delay'
default['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Value'] = "uint32 5"
default['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Only_if'] = "rpm -q dconf"

# R-271674 OL09-00-002104
default['ol9STIG']['stigrule_271674']['Manage'] = true
default['ol9STIG']['stigrule_271674']['Title'] = "OL 9 must automatically lock graphical user sessions after 15 minutes of inactivity."
default['ol9STIG']['stigrule_271674']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Path'] = '/etc/dconf/db/local.d/00-screensaver'
default['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Section'] = 'org/gnome/desktop/session'
default['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Option'] = 'idle-delay'
default['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Value'] = "uint32 600"
default['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Only_if'] = "rpm -q dconf"

# R-271676 OL09-00-002106
default['ol9STIG']['stigrule_271676']['Manage'] = true
default['ol9STIG']['stigrule_271676']['Title'] = "OL 9 must conceal, via the session lock, information previously visible on the display with a publicly viewable image."
default['ol9STIG']['stigrule_271676']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path'] = '/etc/dconf/db/local.d/00-security-settings'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section'] = 'org/gnome/desktop/screensaver'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option'] = 'picture-uri'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value'] = "''"
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if'] = "rpm -q dconf"

default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path'] = '/etc/dconf/db/local.d/locks/00-security-settings-lock'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Line'] = '/org/gnome/desktop/screensaver/picture-uri'
default['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Only_if'] = "rpm -q dconf"

# R-271677 OL09-00-002107
default['ol9STIG']['stigrule_271677']['Manage'] = true
default['ol9STIG']['stigrule_271677']['Title'] = "OL 9 must disable the ability of a user to accidentally press Ctrl-Alt-Del and cause a system to shut down or reboot."
default['ol9STIG']['stigrule_271677']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path'] = '/etc/dconf/db/local.d/00-security-settings'
default['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section'] = 'org/gnome/settings-daemon/plugins/media-keys'
default['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option'] = 'logout'
default['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value'] = "['']"
default['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if'] = "rpm -q dconf"

# R-271678 OL09-00-002120
default['ol9STIG']['stigrule_271678']['Manage'] = true
default['ol9STIG']['stigrule_271678']['Title'] = "OL 9 must prevent a user from overriding the disabling of the graphical user interface automount function."
default['ol9STIG']['stigrule_271678']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path'] = '/etc/dconf/db/local.d/locks/00-security-settings-lock'
default['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Line'] = '/org/gnome/desktop/media-handling/automount-open'
default['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Only_if'] = "rpm -q dconf"

# R-271679 OL09-00-002121
default['ol9STIG']['stigrule_271679']['Manage'] = true
default['ol9STIG']['stigrule_271679']['Title'] = "OL 9 must prevent a user from overriding the disabling of the graphical user interface autorun function."
default['ol9STIG']['stigrule_271679']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path'] = '/etc/dconf/db/local.d/locks/00-security-settings-lock'
default['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Line'] = '/org/gnome/desktop/media-handling/autorun-never'
default['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Only_if'] = "rpm -q dconf"

# R-271680 OL09-00-002122
default['ol9STIG']['stigrule_271680']['Manage'] = true
default['ol9STIG']['stigrule_271680']['Title'] = "OL 9 must prevent a user from overriding the banner-message-enable setting for the graphical user interface."
default['ol9STIG']['stigrule_271680']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Line'] = '/org/gnome/login-screen/banner-message-enable'
default['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Only_if'] = "rpm -q dconf"

# R-271681 OL09-00-002123
default['ol9STIG']['stigrule_271681']['Manage'] = true
default['ol9STIG']['stigrule_271681']['Title'] = "OL 9 must prevent a user from overriding the screensaver lock-enabled setting for the graphical user interface."
default['ol9STIG']['stigrule_271681']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Line'] = '/org/gnome/desktop/screensaver/lock-enabled'
default['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Only_if'] = "rpm -q dconf"

# R-271682 OL09-00-002124
default['ol9STIG']['stigrule_271682']['Manage'] = true
default['ol9STIG']['stigrule_271682']['Title'] = "OL 9 must prevent a user from overriding the session idle-delay setting for the graphical user interface."
default['ol9STIG']['stigrule_271682']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271682']['Setting']['_etc_dconf_db_local_d_locks_session_idle_delay_Path'] = '/etc/dconf/db/local.d/locks/session idle-delay'
default['ol9STIG']['stigrule_271682']['Setting']['_etc_dconf_db_local_d_locks_session_idle_delay_Line'] = '/org/gnome/desktop/session/idle-delay'

# R-271683 OL09-00-002125
default['ol9STIG']['stigrule_271683']['Manage'] = true
default['ol9STIG']['stigrule_271683']['Title'] = "OL 9 must prevent a user from overriding the session lock-delay setting for the graphical user interface."
default['ol9STIG']['stigrule_271683']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Line'] = '/org/gnome/desktop/screensaver/lock-delay'
default['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Only_if'] = "rpm -q dconf"

# R-271684 OL09-00-002126
default['ol9STIG']['stigrule_271684']['Manage'] = true
default['ol9STIG']['stigrule_271684']['Title'] = "OL 9 must prevent a user from overriding the disabling of the graphical user smart card removal action."
default['ol9STIG']['stigrule_271684']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path'] = '/etc/dconf/db/local.d/locks/00-security-settings-lock'
default['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Line'] = '/org/gnome/settings-daemon/peripherals/smartcard/removal-action'
default['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Only_if'] = "rpm -q dconf"

# R-271685 OL09-00-002127
default['ol9STIG']['stigrule_271685']['Manage'] = true
default['ol9STIG']['stigrule_271685']['Title'] = "OL 9 must disable the ability of a user to restart the system from the login screen."
default['ol9STIG']['stigrule_271685']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Line'] = '/org/gnome/login-screen/disable-restart-buttons'
default['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Only_if'] = "rpm -q dconf"

# R-271686 OL09-00-002128
default['ol9STIG']['stigrule_271686']['Manage'] = true
default['ol9STIG']['stigrule_271686']['Title'] = "OL 9 must prevent a user from overriding the disable-restart-buttons setting for the graphical user interface."
default['ol9STIG']['stigrule_271686']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Line'] = '/org/gnome/login-screen/disable-restart-buttons'
default['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Only_if'] = "rpm -q dconf"

# R-271687 OL09-00-002129
default['ol9STIG']['stigrule_271687']['Manage'] = true
default['ol9STIG']['stigrule_271687']['Title'] = "OL 9 must prevent a user from overriding the Ctrl-Alt-Del sequence settings for the graphical user interface."
default['ol9STIG']['stigrule_271687']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Path'] = '/etc/dconf/db/local.d/locks/session'
default['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Line'] = '/org/gnome/settings-daemon/plugins/media-keys/logout'
default['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Only_if'] = "rpm -q dconf"

# R-271688 OL09-00-002150
default['ol9STIG']['stigrule_271688']['Manage'] = true
default['ol9STIG']['stigrule_271688']['Title'] = "OL 9 must be configured to enable the display of the Standard Mandatory DOD Notice and Consent Banner before granting local or remote access to the system via a graphical user logon."
default['ol9STIG']['stigrule_271688']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Path'] = '/etc/dconf/db/local.d/01-banner-message'
default['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Section'] = 'org/gnome/login-screen'
default['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Option'] = 'banner-message-enable'
default['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Value'] = "true"
default['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Only_if'] = "rpm -q dconf"

# R-271689 OL09-00-002151
default['ol9STIG']['stigrule_271689']['Manage'] = true
default['ol9STIG']['stigrule_271689']['Title'] = "OL 9 must display the Standard Mandatory DOD Notice and Consent Banner before granting local or remote access to the system via a graphical user logon."
default['ol9STIG']['stigrule_271689']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Path'] = '/etc/dconf/db/local.d/01-banner-message'
default['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Section'] = 'org/gnome/login-screen'
default['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Option'] = 'banner-message-text'
default['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Value'] = "'You are accessing a U.S. Government (USG) Information System (IS) that is provided for USG-authorized use only.\\nBy using this IS (which includes any device attached to this IS), you consent to the following conditions:\\n-The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.\\n-At any time, the USG may inspect and seize data stored on this IS.\\n-Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG-authorized purpose.\\n-This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.\\n-Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy, and their assistants. Such communications and work product are private and confidential. See User Agreement for details.'"
default['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Only_if'] = "rpm -q dconf"

# R-271690 OL09-00-002160
default['ol9STIG']['stigrule_271690']['Manage'] = true
default['ol9STIG']['stigrule_271690']['Title'] = "OL 9 must be able to directly initiate a session lock for all connection types using smart card when the smart card is removed."
default['ol9STIG']['stigrule_271690']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path'] = '/etc/dconf/db/local.d/00-security-settings'
default['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section'] = 'org/gnome/settings-daemon/peripherals/smartcard'
default['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option'] = 'removal-action'
default['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value'] = "'lock-screen'"
default['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if'] = "rpm -q dconf"

# R-271691 OL09-00-002161
default['ol9STIG']['stigrule_271691']['Manage'] = true
default['ol9STIG']['stigrule_271691']['Title'] = "OL 9 must not allow unattended or automatic logon via the graphical user interface."
default['ol9STIG']['stigrule_271691']['Severity'] = 'high'
default['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Path'] = '/etc/gdm/custom.conf'
default['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Section'] = 'daemon'
default['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Option'] = 'AutomaticLoginEnable'
default['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Value'] = "false"
default['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Only_if'] = "rpm -q gdm"

# R-271693 OL09-00-002301
default['ol9STIG']['stigrule_271693']['Manage'] = true
default['ol9STIG']['stigrule_271693']['Title'] = "OL 9 must define default permissions for the bash shell."
default['ol9STIG']['stigrule_271693']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Path'] = '/etc/bashrc'
default['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Regexp'] = '^umask\s+\d+'
default['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Line'] = 'umask 077'

# R-271694 OL09-00-002302
default['ol9STIG']['stigrule_271694']['Manage'] = true
default['ol9STIG']['stigrule_271694']['Title'] = "OL 9 must define default permissions for the c shell."
default['ol9STIG']['stigrule_271694']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Path'] = '/etc/csh.cshrc'
default['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Regexp'] = '^umask\s+\d+'
default['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Line'] = 'umask 077'

# R-271695 OL09-00-002303
default['ol9STIG']['stigrule_271695']['Manage'] = true
default['ol9STIG']['stigrule_271695']['Title'] = "OL 9 must define default permissions for the system default profile."
default['ol9STIG']['stigrule_271695']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Path'] = '/etc/profile'
default['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Regexp'] = '^umask\s+\d+'
default['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Line'] = 'umask 077'

# R-271696 OL09-00-002304
default['ol9STIG']['stigrule_271696']['Manage'] = true
default['ol9STIG']['stigrule_271696']['Title'] = "OL 9 must define default permissions for all authenticated users in such a way that the user can only read and modify their own files."
default['ol9STIG']['stigrule_271696']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Regexp'] = '^UMASK'
default['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Line'] = 'UMASK 077'

# R-271697 OL09-00-002320
default['ol9STIG']['stigrule_271697']['Manage'] = true
default['ol9STIG']['stigrule_271697']['Title'] = "OL 9 must disable the chrony daemon from acting as a server."
default['ol9STIG']['stigrule_271697']['Severity'] = 'low'
default['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Path'] = '/etc/chrony.conf'
default['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Regexp'] = '^\s*port\s+\d+'
default['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Line'] = 'port 0'

# R-271698 OL09-00-002321
default['ol9STIG']['stigrule_271698']['Manage'] = true
default['ol9STIG']['stigrule_271698']['Title'] = "OL 9 must disable network management of the chrony daemon."
default['ol9STIG']['stigrule_271698']['Severity'] = 'low'
default['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Path'] = '/etc/chrony.conf'
default['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Regexp'] = '^\s*cmdport\s+\d+'
default['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Line'] = 'cmdport 0'

# R-271700 OL09-00-002330
default['ol9STIG']['stigrule_271700']['Manage'] = true
default['ol9STIG']['stigrule_271700']['Title'] = "OL 9 must enable Linux audit logging for the USBGuard daemon."
default['ol9STIG']['stigrule_271700']['Severity'] = 'low'
default['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Path'] = '/etc/usbguard/usbguard-daemon.conf'
default['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Regexp'] = '^\s*AuditBackend\s*='
default['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Line'] = 'AuditBackend=LinuxAudit'

# R-271703 OL09-00-002340
default['ol9STIG']['stigrule_271703']['Manage'] = true
default['ol9STIG']['stigrule_271703']['Title'] = "OL 9 must log SSH connection attempts and failures to the server."
default['ol9STIG']['stigrule_271703']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Regexp'] = '^\s*(?i)LogLevel\s+'
default['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Line'] = 'LogLevel VERBOSE'

# R-271704 OL09-00-002341
default['ol9STIG']['stigrule_271704']['Manage'] = true
default['ol9STIG']['stigrule_271704']['Title'] = "OL 9 SSH daemon must not allow Generic Security Service Application Program Interface (GSSAPI) authentication."
default['ol9STIG']['stigrule_271704']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Regexp'] = '^\s*(?i)GSSAPIAuthentication\s+'
default['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Line'] = 'GSSAPIAuthentication no'

# R-271705 OL09-00-002342
default['ol9STIG']['stigrule_271705']['Manage'] = true
default['ol9STIG']['stigrule_271705']['Title'] = "OL 9 must force a frequent session key renegotiation for SSH connections to the server."
default['ol9STIG']['stigrule_271705']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Regexp'] = '^\s*(?i)RekeyLimit\s+'
default['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Line'] = 'RekeyLimit 1G 1h'

# R-271706 OL09-00-002343
default['ol9STIG']['stigrule_271706']['Manage'] = true
default['ol9STIG']['stigrule_271706']['Title'] = "OL 9 SSHD must not allow blank passwords."
default['ol9STIG']['stigrule_271706']['Severity'] = 'high'
default['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Regexp'] = '^\s*(?i)PermitEmptyPasswords\s+'
default['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Line'] = 'PermitEmptyPasswords no'

# R-271707 OL09-00-002344
default['ol9STIG']['stigrule_271707']['Manage'] = true
default['ol9STIG']['stigrule_271707']['Title'] = "OL 9 must enable the Pluggable Authentication Module (PAM) interface for SSHD."
default['ol9STIG']['stigrule_271707']['Severity'] = 'high'
default['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Regexp'] = '^\s*(?i)UsePAM\s+'
default['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Line'] = 'UsePAM yes'

# R-271708 OL09-00-002345
default['ol9STIG']['stigrule_271708']['Manage'] = true
default['ol9STIG']['stigrule_271708']['Title'] = "OL 9 must not permit direct logons to the root account using remote access via SSH."
default['ol9STIG']['stigrule_271708']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Regexp'] = '^\s*(?i)PermitRootLogin\s+'
default['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Line'] = 'PermitRootLogin no'

# R-271709 OL09-00-002346
default['ol9STIG']['stigrule_271709']['Manage'] = true
default['ol9STIG']['stigrule_271709']['Title'] = "OL 9 must be configured so that all network connections associated with SSH traffic terminate after becoming unresponsive."
default['ol9STIG']['stigrule_271709']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Regexp'] = '^\s*(?i)ClientAliveCountMax\s+'
default['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Line'] = 'ClientAliveCountMax 1'

# R-271710 OL09-00-002347
default['ol9STIG']['stigrule_271710']['Manage'] = true
default['ol9STIG']['stigrule_271710']['Title'] = "OL 9 must be configured so that all network connections associated with SSH traffic are terminated after 10 minutes of becoming unresponsive."
default['ol9STIG']['stigrule_271710']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Regexp'] = '^\s*(?i)ClientAliveInterval\s+'
default['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Line'] = 'ClientAliveInterval 600'

# R-271711 OL09-00-002348
default['ol9STIG']['stigrule_271711']['Manage'] = true
default['ol9STIG']['stigrule_271711']['Title'] = "OL 9 SSH daemon must not allow rhosts authentication."
default['ol9STIG']['stigrule_271711']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Regexp'] = '^\s*(?i)IgnoreRhosts\s+'
default['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Line'] = 'IgnoreRhosts yes'

# R-271712 OL09-00-002349
default['ol9STIG']['stigrule_271712']['Manage'] = true
default['ol9STIG']['stigrule_271712']['Title'] = "OL 9 SSH daemon must not allow known hosts authentication."
default['ol9STIG']['stigrule_271712']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Regexp'] = '^\s*(?i)IgnoreUserKnownHosts\s+'
default['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Line'] = 'IgnoreUserKnownHosts yes'

# R-271713 OL09-00-002350
default['ol9STIG']['stigrule_271713']['Manage'] = true
default['ol9STIG']['stigrule_271713']['Title'] = "OL 9 SSH daemon must disable remote X connections for interactive users."
default['ol9STIG']['stigrule_271713']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Regexp'] = '^\s*(?i)X11Forwarding\s+'
default['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Line'] = 'X11Forwarding no'

# R-271714 OL09-00-002351
default['ol9STIG']['stigrule_271714']['Manage'] = true
default['ol9STIG']['stigrule_271714']['Title'] = "OL 9 SSH daemon must perform strict mode checking of home directory configuration files."
default['ol9STIG']['stigrule_271714']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Regexp'] = '^\s*(?i)StrictModes\s+'
default['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Line'] = 'StrictModes yes'

# R-271715 OL09-00-002352
default['ol9STIG']['stigrule_271715']['Manage'] = true
default['ol9STIG']['stigrule_271715']['Title'] = "OL 9 SSH daemon must display the date and time of the last successful account logon upon an SSH logon."
default['ol9STIG']['stigrule_271715']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Regexp'] = '^\s*(?i)PrintLastLog\s+'
default['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Line'] = 'PrintLastLog yes'

# R-271716 OL09-00-002354
default['ol9STIG']['stigrule_271716']['Manage'] = true
default['ol9STIG']['stigrule_271716']['Title'] = "OL 9 SSH daemon must prevent remote hosts from connecting to the proxy display."
default['ol9STIG']['stigrule_271716']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Regexp'] = '^\s*(?i)X11UseLocalhost\s+'
default['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Line'] = 'X11UseLocalhost yes'

# R-271717 OL09-00-002355
default['ol9STIG']['stigrule_271717']['Manage'] = true
default['ol9STIG']['stigrule_271717']['Title'] = "OL 9 SSH daemon must not allow compression or must only allow compression after successful authentication."
default['ol9STIG']['stigrule_271717']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271717']['Setting']['Compression_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271717']['Setting']['Compression_Regexp'] = '^\s*(?i)Compression\s+'
default['ol9STIG']['stigrule_271717']['Setting']['Compression_Line'] = 'Compression no'

# R-271718 OL09-00-002356
default['ol9STIG']['stigrule_271718']['Manage'] = true
default['ol9STIG']['stigrule_271718']['Title'] = "OL 9 SSH daemon must not allow Kerberos authentication."
default['ol9STIG']['stigrule_271718']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Regexp'] = '^\s*(?i)KerberosAuthentication\s+'
default['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Line'] = 'KerberosAuthentication no'

# R-271719 OL09-00-002357
default['ol9STIG']['stigrule_271719']['Manage'] = true
default['ol9STIG']['stigrule_271719']['Title'] = "OL 9 must not allow a noncertificate trusted host SSH logon to the system."
default['ol9STIG']['stigrule_271719']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Regexp'] = '^\s*(?i)HostbasedAuthentication\s+'
default['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Line'] = 'HostbasedAuthentication no'

# R-271720 OL09-00-002358
default['ol9STIG']['stigrule_271720']['Manage'] = true
default['ol9STIG']['stigrule_271720']['Title'] = "OL 9 must not allow users to override SSH environment variables."
default['ol9STIG']['stigrule_271720']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Regexp'] = '^\s*(?i)PermitUserEnvironment\s+'
default['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Line'] = 'PermitUserEnvironment no'

# R-271721 OL09-00-002359
default['ol9STIG']['stigrule_271721']['Manage'] = true
default['ol9STIG']['stigrule_271721']['Title'] = "OL 9 SSHD must accept public key authentication."
default['ol9STIG']['stigrule_271721']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Path'] = '/etc/ssh/sshd_config'
default['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Regexp'] = '^\s*(?i)PubkeyAuthentication\s+'
default['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Line'] = 'PubkeyAuthentication yes'

# R-271722 OL09-00-002360
default['ol9STIG']['stigrule_271722']['Manage'] = true
default['ol9STIG']['stigrule_271722']['Title'] = "OL 9 must require reauthentication when using the \"sudo\" command."
default['ol9STIG']['stigrule_271722']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Path'] = '/etc/sudoers'
default['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Regexp'] = '^\s*Defaults\s+timestamp_timeout\s*='
default['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Line'] = 'Defaults timestamp_timeout=0'

# R-271727 OL09-00-002370
default['ol9STIG']['stigrule_271727']['Manage'] = true
default['ol9STIG']['stigrule_271727']['Title'] = "OL 9 must disable the use of user namespaces."
default['ol9STIG']['stigrule_271727']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271727']['Setting']['user_max_user_namespaces_Key'] = 'user.max_user_namespaces'
default['ol9STIG']['stigrule_271727']['Setting']['user_max_user_namespaces_Value'] = 0

# R-271728 OL09-00-002380
default['ol9STIG']['stigrule_271728']['Manage'] = true
default['ol9STIG']['stigrule_271728']['Title'] = "OL 9 must disable the kernel.core_pattern."
default['ol9STIG']['stigrule_271728']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271728']['Setting']['kernel_core_pattern_Key'] = 'kernel.core_pattern'
default['ol9STIG']['stigrule_271728']['Setting']['kernel_core_pattern_Value'] = '|/bin/false'

# R-271729 OL09-00-002381
default['ol9STIG']['stigrule_271729']['Manage'] = true
default['ol9STIG']['stigrule_271729']['Title'] = "OL 9 must disable core dump backtraces."
default['ol9STIG']['stigrule_271729']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Path'] = '/etc/systemd/coredump.conf'
default['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Regexp'] = '^ProcessSizeMax='
default['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Line'] = 'ProcessSizeMax=0'

# R-271730 OL09-00-002382
default['ol9STIG']['stigrule_271730']['Manage'] = true
default['ol9STIG']['stigrule_271730']['Title'] = "OL 9 must disable storing core dumps."
default['ol9STIG']['stigrule_271730']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Path'] = '/etc/systemd/coredump.conf'
default['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Regexp'] = '^Storage='
default['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Line'] = 'Storage=none'

# R-271731 OL09-00-002383
default['ol9STIG']['stigrule_271731']['Manage'] = true
default['ol9STIG']['stigrule_271731']['Title'] = "OL 9 must disable core dumps for all users."
default['ol9STIG']['stigrule_271731']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Path'] = '/etc/security/limits.conf'
default['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Regexp'] = '^\* hard core'
default['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Line'] = '* hard core 0'

# R-271732 OL09-00-002384
default['ol9STIG']['stigrule_271732']['Manage'] = true
default['ol9STIG']['stigrule_271732']['Title'] = "OL 9 must disable acquiring, saving, and processing core dumps."
default['ol9STIG']['stigrule_271732']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_disable_UnitName'] = 'systemd-coredump.socket'
default['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_disable_Action'] = :disable

default['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_mask_UnitName'] = 'systemd-coredump.socket'
default['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_mask_Action'] = [:mask, :stop]

# R-271733 OL09-00-002385
default['ol9STIG']['stigrule_271733']['Manage'] = true
default['ol9STIG']['stigrule_271733']['Title'] = "OL 9 must be configured so that the kdump service is disabled."
default['ol9STIG']['stigrule_271733']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271733']['Setting']['kdump_disable_UnitName'] = 'kdump'
default['ol9STIG']['stigrule_271733']['Setting']['kdump_disable_Action'] = :disable

default['ol9STIG']['stigrule_271733']['Setting']['kdump_mask_UnitName'] = 'kdump'
default['ol9STIG']['stigrule_271733']['Setting']['kdump_mask_Action'] = [:mask, :stop]

# R-271739 OL09-00-002400
default['ol9STIG']['stigrule_271739']['Manage'] = true
default['ol9STIG']['stigrule_271739']['Title'] = "OL 9 systemd-journald service must be enabled."
default['ol9STIG']['stigrule_271739']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_enable_ServiceName'] = 'systemd-journald'
default['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_enable_Action'] = :enable

default['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_start_ServiceName'] = 'systemd-journald'
default['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_start_Action'] = :start

# R-271740 OL09-00-002401
default['ol9STIG']['stigrule_271740']['Manage'] = true
default['ol9STIG']['stigrule_271740']['Title'] = "OL 9 must enable kernel parameters to enforce discretionary access control on hardlinks."
default['ol9STIG']['stigrule_271740']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271740']['Setting']['fs_protected_hardlinks_Key'] = 'fs.protected_hardlinks'
default['ol9STIG']['stigrule_271740']['Setting']['fs_protected_hardlinks_Value'] = 1

# R-271741 OL09-00-002402
default['ol9STIG']['stigrule_271741']['Manage'] = true
default['ol9STIG']['stigrule_271741']['Title'] = "OL 9 must enable kernel parameters to enforce discretionary access control on symlinks."
default['ol9STIG']['stigrule_271741']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271741']['Setting']['fs_protected_symlinks_Key'] = 'fs.protected_symlinks'
default['ol9STIG']['stigrule_271741']['Setting']['fs_protected_symlinks_Value'] = 1

# R-271742 OL09-00-002403
default['ol9STIG']['stigrule_271742']['Manage'] = true
default['ol9STIG']['stigrule_271742']['Title'] = "OL 9 debug-shell systemd service must be disabled."
default['ol9STIG']['stigrule_271742']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_disable_UnitName'] = 'debug-shell.service'
default['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_disable_Action'] = :disable

default['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_mask_UnitName'] = 'debug-shell.service'
default['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_mask_Action'] = [:mask, :stop]

# R-271744 OL09-00-002405
default['ol9STIG']['stigrule_271744']['Manage'] = true
default['ol9STIG']['stigrule_271744']['Title'] = "OL 9 must have mail aliases to notify the information system security officer (ISSO) and system administrator (SA) (at a minimum) in the event of an audit processing failure."
default['ol9STIG']['stigrule_271744']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Path'] = '/etc/aliases'
default['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Regexp'] = '^root:'
default['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Line'] = 'root: ISSO'

# R-271745 OL09-00-002406
default['ol9STIG']['stigrule_271745']['Manage'] = true
default['ol9STIG']['stigrule_271745']['Title'] = "OL 9 must restrict access to the kernel message buffer."
default['ol9STIG']['stigrule_271745']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271745']['Setting']['kernel_dmesg_restrict_Key'] = 'kernel.dmesg_restrict'
default['ol9STIG']['stigrule_271745']['Setting']['kernel_dmesg_restrict_Value'] = 1

# R-271746 OL09-00-002407
default['ol9STIG']['stigrule_271746']['Manage'] = true
default['ol9STIG']['stigrule_271746']['Title'] = "OL 9 must prevent kernel profiling by nonprivileged users."
default['ol9STIG']['stigrule_271746']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271746']['Setting']['kernel_perf_event_paranoid_Key'] = 'kernel.perf_event_paranoid'
default['ol9STIG']['stigrule_271746']['Setting']['kernel_perf_event_paranoid_Value'] = 2

# R-271747 OL09-00-002408
default['ol9STIG']['stigrule_271747']['Manage'] = true
default['ol9STIG']['stigrule_271747']['Title'] = "OL 9 must restrict exposed kernel pointer addresses access."
default['ol9STIG']['stigrule_271747']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271747']['Setting']['kernel_kptr_restrict_Key'] = 'kernel.kptr_restrict'
default['ol9STIG']['stigrule_271747']['Setting']['kernel_kptr_restrict_Value'] = 1

# R-271748 OL09-00-002409
default['ol9STIG']['stigrule_271748']['Manage'] = true
default['ol9STIG']['stigrule_271748']['Title'] = "OL 9 must disable access to network bpf system call from nonprivileged processes."
default['ol9STIG']['stigrule_271748']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271748']['Setting']['kernel_unprivileged_bpf_disabled_Key'] = 'kernel.unprivileged_bpf_disabled'
default['ol9STIG']['stigrule_271748']['Setting']['kernel_unprivileged_bpf_disabled_Value'] = 1

# R-271749 OL09-00-002410
default['ol9STIG']['stigrule_271749']['Manage'] = true
default['ol9STIG']['stigrule_271749']['Title'] = "OL 9 must restrict usage of ptrace to descendant processes."
default['ol9STIG']['stigrule_271749']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271749']['Setting']['kernel_yama_ptrace_scope_Key'] = 'kernel.yama.ptrace_scope'
default['ol9STIG']['stigrule_271749']['Setting']['kernel_yama_ptrace_scope_Value'] = 1

# R-271750 OL09-00-002411
default['ol9STIG']['stigrule_271750']['Manage'] = true
default['ol9STIG']['stigrule_271750']['Title'] = "OL 9 must automatically exit interactive command shell user sessions after 15 minutes of inactivity."
default['ol9STIG']['stigrule_271750']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271750']['Setting']['_etc_profile_d_tmout_sh_Path'] = '/etc/profile.d/tmout.sh'
default['ol9STIG']['stigrule_271750']['Setting']['_etc_profile_d_tmout_sh_Content'] = '#!/bin/bash

declare -xr TMOUT=900'

# R-271751 OL09-00-002412
default['ol9STIG']['stigrule_271751']['Manage'] = true
default['ol9STIG']['stigrule_271751']['Title'] = "OL 9 must be configured so that the systemd Ctrl-Alt-Delete burst key sequence is disabled."
default['ol9STIG']['stigrule_271751']['Severity'] = 'high'
default['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path'] = '/etc/systemd/system.conf.d/55-CtrlAltDel-BurstAction'
default['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Section'] = 'Manager'
default['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Option'] = 'CtrlAltDelBurstAction'
default['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Value'] = "none"
default['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Only_if'] = "rpm -q dconf"

# R-271752 OL09-00-002413
default['ol9STIG']['stigrule_271752']['Manage'] = true
default['ol9STIG']['stigrule_271752']['Title'] = "OL 9 must be configured so that the x86 Ctrl-Alt-Delete key sequence is disabled."
default['ol9STIG']['stigrule_271752']['Severity'] = 'high'
default['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_disable_UnitName'] = 'ctrl-alt-del.target'
default['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_disable_Action'] = :disable

default['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_mask_UnitName'] = 'ctrl-alt-del.target'
default['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_mask_Action'] = [:mask, :stop]

# R-271753 OL09-00-002415
default['ol9STIG']['stigrule_271753']['Manage'] = true
default['ol9STIG']['stigrule_271753']['Title'] = "OL 9 must limit the number of concurrent sessions to ten for all accounts and/or account types."
default['ol9STIG']['stigrule_271753']['Severity'] = 'low'
default['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Path'] = '/etc/security/limits.conf'
default['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Regexp'] = '^\* hard maxlogins'
default['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Line'] = '* hard maxlogins 10'

# R-271761 OL09-00-002423
default['ol9STIG']['stigrule_271761']['Manage'] = true
default['ol9STIG']['stigrule_271761']['Title'] = "OL 9 must implement address space layout randomization (ASLR) to protect its memory from unauthorized code execution."
default['ol9STIG']['stigrule_271761']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271761']['Setting']['kernel_randomize_va_space_Key'] = 'kernel.randomize_va_space'
default['ol9STIG']['stigrule_271761']['Setting']['kernel_randomize_va_space_Value'] = 2

# R-271766 OL09-00-002428
default['ol9STIG']['stigrule_271766']['Manage'] = true
default['ol9STIG']['stigrule_271766']['Title'] = "OL 9 must prevent the loading of a new kernel for later execution."
default['ol9STIG']['stigrule_271766']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271766']['Setting']['kernel_kexec_load_disabled_Key'] = 'kernel.kexec_load_disabled'
default['ol9STIG']['stigrule_271766']['Setting']['kernel_kexec_load_disabled_Value'] = 1

# R-271768 OL09-00-002430
default['ol9STIG']['stigrule_271768']['Manage'] = true
default['ol9STIG']['stigrule_271768']['Title'] = "OL 9 must enable hardening for the Berkeley Packet Filter (BPF) just-in-time compiler."
default['ol9STIG']['stigrule_271768']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271768']['Setting']['net_core_bpf_jit_harden_Key'] = 'net.core.bpf_jit_harden'
default['ol9STIG']['stigrule_271768']['Setting']['net_core_bpf_jit_harden_Value'] = 2

# R-271846 OL09-00-003052
default['ol9STIG']['stigrule_271846']['Manage'] = true
default['ol9STIG']['stigrule_271846']['Title'] = "OL 9 local interactive user accounts must be assigned a home directory upon creation."
default['ol9STIG']['stigrule_271846']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Regexp'] = '^CREATE_HOME'
default['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Line'] = 'CREATE_HOME yes'

# R-271849 OL09-00-003065
default['ol9STIG']['stigrule_271849']['Manage'] = true
default['ol9STIG']['stigrule_271849']['Title'] = "OL 9 must disable account identifiers (individuals, groups, roles, and devices) after 35 days of inactivity."
default['ol9STIG']['stigrule_271849']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271849']['Setting']['sudo_useradd__D__f_35_Command'] = "sudo useradd -D -f 35"
default['ol9STIG']['stigrule_271849']['Setting']['sudo_useradd__D__f_35_Only_if'] = "[[ $(sudo grep -i inactive /etc/default/useradd) != 'INACTIVE=35' ]]"

# R-271850 OL09-00-003070
default['ol9STIG']['stigrule_271850']['Manage'] = true
default['ol9STIG']['stigrule_271850']['Title'] = "OL 9 must enforce a delay of at least four seconds between logon prompts following a failed logon attempt."
default['ol9STIG']['stigrule_271850']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Path'] = '/etc/login.defs'
default['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Regexp'] = '^[#\s]*FAIL_DELAY\s*\d+\s*$'
default['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Line'] = 'FAIL_DELAY 4'

# R-271851 OL09-00-005000
default['ol9STIG']['stigrule_271851']['Manage'] = true
default['ol9STIG']['stigrule_271851']['Title'] = "OL 9 remote access methods must be monitored."
default['ol9STIG']['stigrule_271851']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271851']['Setting']['_etc_rsyslog_conf_Path'] = '/etc/rsyslog.conf'
default['ol9STIG']['stigrule_271851']['Setting']['_etc_rsyslog_conf_Line'] = 'auth.*;authpriv.*;daemon.* /var/log/secure'

# R-271853 OL09-00-005010
default['ol9STIG']['stigrule_271853']['Manage'] = true
default['ol9STIG']['stigrule_271853']['Title'] = "OL 9 must use cron logging."
default['ol9STIG']['stigrule_271853']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271853']['Setting']['_etc_rsyslog_conf_Path'] = '/etc/rsyslog.conf'
default['ol9STIG']['stigrule_271853']['Setting']['_etc_rsyslog_conf_Line'] = 'cron.* /var/log/cron'

# R-271854 OL09-00-005015
default['ol9STIG']['stigrule_271854']['Manage'] = true
default['ol9STIG']['stigrule_271854']['Title'] = "OL 9 must authenticate the remote logging server for offloading audit logs via rsyslog."
default['ol9STIG']['stigrule_271854']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271854']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Path'] = '/etc/rsyslog.conf DefaultNetstreamDriver'
default['ol9STIG']['stigrule_271854']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Line'] = '$ActionSendStreamDriverAuthMode x509/name'

# R-271855 OL09-00-005020
default['ol9STIG']['stigrule_271855']['Manage'] = true
default['ol9STIG']['stigrule_271855']['Title'] = "OL 9 must encrypt the transfer of audit records offloaded onto a different system or media from the system being audited via rsyslog."
default['ol9STIG']['stigrule_271855']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271855']['Setting']['_etc_rsyslog_conf_ActionSendStreamDriverMode_Path'] = '/etc/rsyslog.conf ActionSendStreamDriverMode'
default['ol9STIG']['stigrule_271855']['Setting']['_etc_rsyslog_conf_ActionSendStreamDriverMode_Line'] = '$ActionSendStreamDriverMode 1'

# R-271856 OL09-00-005025
default['ol9STIG']['stigrule_271856']['Manage'] = true
default['ol9STIG']['stigrule_271856']['Title'] = "OL 9 must encrypt via the gtls driver the transfer of audit records offloaded onto a different system or media from the system being audited via rsyslog."
default['ol9STIG']['stigrule_271856']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271856']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Path'] = '/etc/rsyslog.conf DefaultNetstreamDriver'
default['ol9STIG']['stigrule_271856']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Line'] = '$DefaultNetstreamDriver gtls'

# R-271858 OL09-00-006000
default['ol9STIG']['stigrule_271858']['Manage'] = true
default['ol9STIG']['stigrule_271858']['Title'] = "OL 9 must protect against or limit the effects of denial-of-service (DoS) attacks by ensuring rate-limiting measures on impacted network interfaces are implemented."
default['ol9STIG']['stigrule_271858']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Path'] = '/etc/firewalld/firewalld.conf'
default['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Regexp'] = '^\s*FirewallBackend\s*='
default['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Line'] = 'FirewallBackend=nftables'

# R-271859 OL09-00-006001
default['ol9STIG']['stigrule_271859']['Manage'] = true
default['ol9STIG']['stigrule_271859']['Title'] = "OL 9 wireless network adapters must be disabled."
default['ol9STIG']['stigrule_271859']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271859']['Setting']['nmcli_radio_wifi_off_Command'] = "nmcli radio wifi off"
default['ol9STIG']['stigrule_271859']['Setting']['nmcli_radio_wifi_off_Only_if'] = "[[ $(nmcli radio wifi) == 'enabled' ]]"

# R-271860 OL09-00-006002
default['ol9STIG']['stigrule_271860']['Manage'] = true
default['ol9STIG']['stigrule_271860']['Title'] = "OL 9 must configure a DNS processing mode set be Network Manager."
default['ol9STIG']['stigrule_271860']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Path'] = '/etc/NetworkManager/NetworkManager.conf'
default['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Section'] = 'main'
default['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Option'] = 'dns'
default['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Value'] = "none"

# R-271864 OL09-00-006020
default['ol9STIG']['stigrule_271864']['Manage'] = true
default['ol9STIG']['stigrule_271864']['Title'] = "OL 9 must ignore Internet Protocol version 4 (IPv4) Internet Control Message Protocol (ICMP) redirect messages."
default['ol9STIG']['stigrule_271864']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271864']['Setting']['net_ipv4_conf_all_accept_redirects_Key'] = 'net.ipv4.conf.all.accept_redirects'
default['ol9STIG']['stigrule_271864']['Setting']['net_ipv4_conf_all_accept_redirects_Value'] = 0

# R-271865 OL09-00-006021
default['ol9STIG']['stigrule_271865']['Manage'] = true
default['ol9STIG']['stigrule_271865']['Title'] = "OL 9 must not forward Internet Protocol version 4 (IPv4) source-routed packets."
default['ol9STIG']['stigrule_271865']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271865']['Setting']['net_ipv4_conf_all_accept_source_route_Key'] = 'net.ipv4.conf.all.accept_source_route'
default['ol9STIG']['stigrule_271865']['Setting']['net_ipv4_conf_all_accept_source_route_Value'] = 0

# R-271866 OL09-00-006022
default['ol9STIG']['stigrule_271866']['Manage'] = true
default['ol9STIG']['stigrule_271866']['Title'] = "OL 9 must log IPv4 packets with impossible addresses."
default['ol9STIG']['stigrule_271866']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271866']['Setting']['net_ipv4_conf_all_log_martians_Key'] = 'net.ipv4.conf.all.log_martians'
default['ol9STIG']['stigrule_271866']['Setting']['net_ipv4_conf_all_log_martians_Value'] = 1

# R-271867 OL09-00-006023
default['ol9STIG']['stigrule_271867']['Manage'] = true
default['ol9STIG']['stigrule_271867']['Title'] = "OL 9 must log IPv4 packets with impossible addresses by default."
default['ol9STIG']['stigrule_271867']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271867']['Setting']['net_ipv4_conf_default_log_martians_Key'] = 'net.ipv4.conf.default.log_martians'
default['ol9STIG']['stigrule_271867']['Setting']['net_ipv4_conf_default_log_martians_Value'] = 1

# R-271868 OL09-00-006024
default['ol9STIG']['stigrule_271868']['Manage'] = true
default['ol9STIG']['stigrule_271868']['Title'] = "OL 9 must use reverse path filtering on all IPv4 interfaces."
default['ol9STIG']['stigrule_271868']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271868']['Setting']['net_ipv4_conf_all_rp_filter_Key'] = 'net.ipv4.conf.all.rp_filter'
default['ol9STIG']['stigrule_271868']['Setting']['net_ipv4_conf_all_rp_filter_Value'] = 1

# R-271869 OL09-00-006025
default['ol9STIG']['stigrule_271869']['Manage'] = true
default['ol9STIG']['stigrule_271869']['Title'] = "OL 9 must prevent IPv4 Internet Control Message Protocol (ICMP) redirect messages from being accepted."
default['ol9STIG']['stigrule_271869']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271869']['Setting']['net_ipv4_conf_default_accept_redirects_Key'] = 'net.ipv4.conf.default.accept_redirects'
default['ol9STIG']['stigrule_271869']['Setting']['net_ipv4_conf_default_accept_redirects_Value'] = 0

# R-271870 OL09-00-006026
default['ol9STIG']['stigrule_271870']['Manage'] = true
default['ol9STIG']['stigrule_271870']['Title'] = "OL 9 must not forward IPv4 source-routed packets by default."
default['ol9STIG']['stigrule_271870']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271870']['Setting']['net_ipv4_conf_default_accept_source_route_Key'] = 'net.ipv4.conf.default.accept_source_route'
default['ol9STIG']['stigrule_271870']['Setting']['net_ipv4_conf_default_accept_source_route_Value'] = 0

# R-271871 OL09-00-006027
default['ol9STIG']['stigrule_271871']['Manage'] = true
default['ol9STIG']['stigrule_271871']['Title'] = "OL 9 must use a reverse-path filter for IPv4 network traffic, when possible, by default."
default['ol9STIG']['stigrule_271871']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271871']['Setting']['net_ipv4_conf_default_rp_filter_Key'] = 'net.ipv4.conf.default.rp_filter'
default['ol9STIG']['stigrule_271871']['Setting']['net_ipv4_conf_default_rp_filter_Value'] = 1

# R-271872 OL09-00-006028
default['ol9STIG']['stigrule_271872']['Manage'] = true
default['ol9STIG']['stigrule_271872']['Title'] = "OL 9 must not enable IPv4 packet forwarding unless the system is a router."
default['ol9STIG']['stigrule_271872']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271872']['Setting']['net_ipv4_conf_all_forwarding_Key'] = 'net.ipv4.conf.all.forwarding'
default['ol9STIG']['stigrule_271872']['Setting']['net_ipv4_conf_all_forwarding_Value'] = 0

# R-271873 OL09-00-006030
default['ol9STIG']['stigrule_271873']['Manage'] = true
default['ol9STIG']['stigrule_271873']['Title'] = "OL 9 must not respond to Internet Control Message Protocol (ICMP) echoes sent to a broadcast address."
default['ol9STIG']['stigrule_271873']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271873']['Setting']['net_ipv4_icmp_echo_ignore_broadcasts_Key'] = 'net.ipv4.icmp_echo_ignore_broadcasts'
default['ol9STIG']['stigrule_271873']['Setting']['net_ipv4_icmp_echo_ignore_broadcasts_Value'] = 1

# R-271874 OL09-00-006031
default['ol9STIG']['stigrule_271874']['Manage'] = true
default['ol9STIG']['stigrule_271874']['Title'] = "OL 9 must limit the number of bogus Internet Control Message Protocol (ICMP) response errors logs."
default['ol9STIG']['stigrule_271874']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271874']['Setting']['net_ipv4_icmp_ignore_bogus_error_responses_Key'] = 'net.ipv4.icmp_ignore_bogus_error_responses'
default['ol9STIG']['stigrule_271874']['Setting']['net_ipv4_icmp_ignore_bogus_error_responses_Value'] = 1

# R-271875 OL09-00-006032
default['ol9STIG']['stigrule_271875']['Manage'] = true
default['ol9STIG']['stigrule_271875']['Title'] = "OL 9 must not send Internet Control Message Protocol (ICMP) redirects."
default['ol9STIG']['stigrule_271875']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271875']['Setting']['net_ipv4_conf_all_send_redirects_Key'] = 'net.ipv4.conf.all.send_redirects'
default['ol9STIG']['stigrule_271875']['Setting']['net_ipv4_conf_all_send_redirects_Value'] = 0

# R-271876 OL09-00-006033
default['ol9STIG']['stigrule_271876']['Manage'] = true
default['ol9STIG']['stigrule_271876']['Title'] = "OL 9 must not allow interfaces to perform Internet Control Message Protocol (ICMP) redirects by default."
default['ol9STIG']['stigrule_271876']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271876']['Setting']['net_ipv4_conf_default_send_redirects_Key'] = 'net.ipv4.conf.default.send_redirects'
default['ol9STIG']['stigrule_271876']['Setting']['net_ipv4_conf_default_send_redirects_Value'] = 0

# R-271877 OL09-00-006040
default['ol9STIG']['stigrule_271877']['Manage'] = true
default['ol9STIG']['stigrule_271877']['Title'] = "OL 9 must not accept router advertisements on all IPv6 interfaces."
default['ol9STIG']['stigrule_271877']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271877']['Setting']['net_ipv6_conf_all_accept_ra_Key'] = 'net.ipv6.conf.all.accept_ra'
default['ol9STIG']['stigrule_271877']['Setting']['net_ipv6_conf_all_accept_ra_Value'] = 0

# R-271878 OL09-00-006041
default['ol9STIG']['stigrule_271878']['Manage'] = true
default['ol9STIG']['stigrule_271878']['Title'] = "OL 9 must ignore IPv6 Internet Control Message Protocol (ICMP) redirect messages."
default['ol9STIG']['stigrule_271878']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271878']['Setting']['net_ipv6_conf_all_accept_redirects_Key'] = 'net.ipv6.conf.all.accept_redirects'
default['ol9STIG']['stigrule_271878']['Setting']['net_ipv6_conf_all_accept_redirects_Value'] = 0

# R-271879 OL09-00-006042
default['ol9STIG']['stigrule_271879']['Manage'] = true
default['ol9STIG']['stigrule_271879']['Title'] = "OL 9 must not forward IPv6 source-routed packets."
default['ol9STIG']['stigrule_271879']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271879']['Setting']['net_ipv6_conf_all_accept_source_route_Key'] = 'net.ipv6.conf.all.accept_source_route'
default['ol9STIG']['stigrule_271879']['Setting']['net_ipv6_conf_all_accept_source_route_Value'] = 0

# R-271880 OL09-00-006043
default['ol9STIG']['stigrule_271880']['Manage'] = true
default['ol9STIG']['stigrule_271880']['Title'] = "OL 9 must not enable IPv6 packet forwarding unless the system is a router."
default['ol9STIG']['stigrule_271880']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271880']['Setting']['net_ipv6_conf_all_forwarding_Key'] = 'net.ipv6.conf.all.forwarding'
default['ol9STIG']['stigrule_271880']['Setting']['net_ipv6_conf_all_forwarding_Value'] = 0

# R-271881 OL09-00-006044
default['ol9STIG']['stigrule_271881']['Manage'] = true
default['ol9STIG']['stigrule_271881']['Title'] = "OL 9 must not accept router advertisements on all IPv6 interfaces by default."
default['ol9STIG']['stigrule_271881']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271881']['Setting']['net_ipv6_conf_default_accept_ra_Key'] = 'net.ipv6.conf.default.accept_ra'
default['ol9STIG']['stigrule_271881']['Setting']['net_ipv6_conf_default_accept_ra_Value'] = 0

# R-271882 OL09-00-006045
default['ol9STIG']['stigrule_271882']['Manage'] = true
default['ol9STIG']['stigrule_271882']['Title'] = "OL 9 must prevent IPv6 Internet Control Message Protocol (ICMP) redirect messages from being accepted."
default['ol9STIG']['stigrule_271882']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271882']['Setting']['net_ipv6_conf_default_accept_redirects_Key'] = 'net.ipv6.conf.default.accept_redirects'
default['ol9STIG']['stigrule_271882']['Setting']['net_ipv6_conf_default_accept_redirects_Value'] = 0

# R-271883 OL09-00-006046
default['ol9STIG']['stigrule_271883']['Manage'] = true
default['ol9STIG']['stigrule_271883']['Title'] = "OL 9 must not forward IPv6 source-routed packets by default."
default['ol9STIG']['stigrule_271883']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271883']['Setting']['net_ipv6_conf_default_accept_source_route_Key'] = 'net.ipv6.conf.default.accept_source_route'
default['ol9STIG']['stigrule_271883']['Setting']['net_ipv6_conf_default_accept_source_route_Value'] = 0

# R-271884 OL09-00-006050
default['ol9STIG']['stigrule_271884']['Manage'] = true
default['ol9STIG']['stigrule_271884']['Title'] = "OL 9 must be configured to use TCP syncookies."
default['ol9STIG']['stigrule_271884']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271884']['Setting']['net_ipv4_tcp_syncookies_Key'] = 'net.ipv4.tcp_syncookies'
default['ol9STIG']['stigrule_271884']['Setting']['net_ipv4_tcp_syncookies_Value'] = 1

# R-271885 OL09-00-008000
default['ol9STIG']['stigrule_271885']['Manage'] = true
default['ol9STIG']['stigrule_271885']['Title'] = "OL 9 audit system must protect logon UIDs from unauthorized change."
default['ol9STIG']['stigrule_271885']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Regexp'] = '^--loginuid-immutable$'
default['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Line'] = '--loginuid-immutable'

# R-271886 OL09-00-008005
default['ol9STIG']['stigrule_271886']['Manage'] = true
default['ol9STIG']['stigrule_271886']['Title'] = "OL 9 audit system must protect auditing rules from unauthorized change."
default['ol9STIG']['stigrule_271886']['Severity'] = 'medium'
default['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Regexp'] = '^-e 2$'
default['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Line'] = '-e 2'

# R-278952 OL09-00-002584
default['ol9STIG']['stigrule_278952']['Manage'] = true
default['ol9STIG']['stigrule_278952']['Title'] = "OL 9 must audit any script or executable called by cron as root or by any privileged user."
default['ol9STIG']['stigrule_278952']['Severity'] = 'medium'
default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Regexp'] = '^-w /etc/cron.d/ -p wa -k cronjobs$'
default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Line'] = '-w /etc/cron.d/ -p wa -k cronjobs'

default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Path'] = '/etc/audit/rules.d/audit.rules'
default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Regexp'] = '^-w /var/spool/cron/ -p wa -k cronjobs$'
default['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Line'] = '-w /var/spool/cron/ -p wa -k cronjobs'

