execute 'dconf_update' do
  command 'dconf update'
  action :nothing
end
service 'ssh_restart' do
  service_name 'sshd'
  action :nothing
end
execute 'auditd_restart' do
  command 'service auditd restart'
  action :nothing
end
execute 'do_reboot' do
  command 'shutdown -r 1'
  action :nothing
end
execute 'daemon_reload' do
  command 'systemctl daemon-reload'
  action :nothing
end
execute 'networkmanager_reload' do
  command 'systemctl restart NetworkManager'
  action :run
end
execute 'rsyslog_restart' do
  command 'systemctl restart rsyslog'
  action :run
end
if node['ol9STIG']['XCCDF_result']['Manage']
  cookbook_file "#{Chef::Config[:file_cache_path]}/stig_xml.rb" do
    source 'stig_xml.rb'
  end
  cookbook_file "#{Chef::Config[:file_cache_path]}/U_Oracle_Linux_9_STIG_V1R4_Manual-xccdf.xml" do
    source 'U_Oracle_Linux_9_STIG_V1R4_Manual-xccdf.xml'
  end
  chef_handler 'Chef::Handler::StigXml' do
    source "#{Chef::Config[:file_cache_path]}/stig_xml.rb"
    arguments :stigName => 'U_Oracle_Linux_9_STIG_V1R4_Manual-xccdf.xml'
  end
end
if node['ol9STIG']['stigrule_271441']['Manage']
  _usr_lib_systemd_system_emergency_service_Path = node['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Path']
  _usr_lib_systemd_system_emergency_service_Dir = ::File.dirname(_usr_lib_systemd_system_emergency_service_Path)
  directory _usr_lib_systemd_system_emergency_service_Dir do
    recursive true
  end
  file _usr_lib_systemd_system_emergency_service_Path do
    action :create
    not_if { ::File.exist?(_usr_lib_systemd_system_emergency_service_Path) }
  end
  ini_setting '_usr_lib_systemd_system_emergency_service_271441' do
    path _usr_lib_systemd_system_emergency_service_Path
    section node['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Section']
    setting node['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Option']
    value node['ol9STIG']['stigrule_271441']['Setting']['_usr_lib_systemd_system_emergency_service_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271442']['Manage']
  _usr_lib_systemd_system_rescue_service_Path = node['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Path']
  _usr_lib_systemd_system_rescue_service_Dir = ::File.dirname(_usr_lib_systemd_system_rescue_service_Path)
  directory _usr_lib_systemd_system_rescue_service_Dir do
    recursive true
  end
  file _usr_lib_systemd_system_rescue_service_Path do
    action :create
    not_if { ::File.exist?(_usr_lib_systemd_system_rescue_service_Path) }
  end
  ini_setting '_usr_lib_systemd_system_rescue_service_271442' do
    path _usr_lib_systemd_system_rescue_service_Path
    section node['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Section']
    setting node['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Option']
    value node['ol9STIG']['stigrule_271442']['Setting']['_usr_lib_systemd_system_rescue_service_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271443']['Manage']
  _etc_modprobe_d_atm_conf_install_atm__bin_false_Path = node['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_install_atm__bin_false_Path']
  file _etc_modprobe_d_atm_conf_install_atm__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_atm_conf_install_atm__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_atm_conf_install_atm__bin_false_271443' do
    path _etc_modprobe_d_atm_conf_install_atm__bin_false_Path
    line node['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_install_atm__bin_false_Line']
  end
end
if node['ol9STIG']['stigrule_271443']['Manage']
  _etc_modprobe_d_atm_conf_blacklist_atm_Path = node['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_blacklist_atm_Path']
  file _etc_modprobe_d_atm_conf_blacklist_atm_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_atm_conf_blacklist_atm_Path) }
  end
  file_line '_etc_modprobe_d_atm_conf_blacklist_atm_271443' do
    path _etc_modprobe_d_atm_conf_blacklist_atm_Path
    line node['ol9STIG']['stigrule_271443']['Setting']['_etc_modprobe_d_atm_conf_blacklist_atm_Line']
  end
end
if node['ol9STIG']['stigrule_271444']['Manage']
  _etc_modprobe_d_can_conf_install_can__bin_false_Path = node['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_install_can__bin_false_Path']
  file _etc_modprobe_d_can_conf_install_can__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_can_conf_install_can__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_can_conf_install_can__bin_false_271444' do
    path _etc_modprobe_d_can_conf_install_can__bin_false_Path
    line node['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_install_can__bin_false_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271444']['Manage']
  _etc_modprobe_d_can_conf_blacklist_can_Path = node['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_blacklist_can_Path']
  file _etc_modprobe_d_can_conf_blacklist_can_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_can_conf_blacklist_can_Path) }
  end
  file_line '_etc_modprobe_d_can_conf_blacklist_can_271444' do
    path _etc_modprobe_d_can_conf_blacklist_can_Path
    line node['ol9STIG']['stigrule_271444']['Setting']['_etc_modprobe_d_can_conf_blacklist_can_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271445']['Manage']
  _etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path = node['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path']
  file _etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_271445' do
    path _etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Path
    line node['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_install_firewire_core__bin_false_Line']
  end
end
if node['ol9STIG']['stigrule_271445']['Manage']
  _etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path = node['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path']
  file _etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path) }
  end
  file_line '_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_271445' do
    path _etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Path
    line node['ol9STIG']['stigrule_271445']['Setting']['_etc_modprobe_d_firewire_core_conf_blacklist_firewire_core_Line']
  end
end
if node['ol9STIG']['stigrule_271446']['Manage']
  _etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path = node['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path']
  file _etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_sctp_conf_install_sctp__bin_false_271446' do
    path _etc_modprobe_d_sctp_conf_install_sctp__bin_false_Path
    line node['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_install_sctp__bin_false_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271446']['Manage']
  _etc_modprobe_d_sctp_conf_blacklist_sctp_Path = node['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_blacklist_sctp_Path']
  file _etc_modprobe_d_sctp_conf_blacklist_sctp_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_sctp_conf_blacklist_sctp_Path) }
  end
  file_line '_etc_modprobe_d_sctp_conf_blacklist_sctp_271446' do
    path _etc_modprobe_d_sctp_conf_blacklist_sctp_Path
    line node['ol9STIG']['stigrule_271446']['Setting']['_etc_modprobe_d_sctp_conf_blacklist_sctp_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271447']['Manage']
  _etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path = node['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path']
  file _etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_tipc_conf_install_tipc__bin_false_271447' do
    path _etc_modprobe_d_tipc_conf_install_tipc__bin_false_Path
    line node['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_install_tipc__bin_false_Line']
  end
end
if node['ol9STIG']['stigrule_271447']['Manage']
  _etc_modprobe_d_tipc_conf_blacklist_tipc_Path = node['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_blacklist_tipc_Path']
  file _etc_modprobe_d_tipc_conf_blacklist_tipc_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_tipc_conf_blacklist_tipc_Path) }
  end
  file_line '_etc_modprobe_d_tipc_conf_blacklist_tipc_271447' do
    path _etc_modprobe_d_tipc_conf_blacklist_tipc_Path
    line node['ol9STIG']['stigrule_271447']['Setting']['_etc_modprobe_d_tipc_conf_blacklist_tipc_Line']
  end
end
if node['ol9STIG']['stigrule_271448']['Manage']
  _etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path = node['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path']
  file _etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_271448' do
    path _etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Path
    line node['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_install_cramfs__bin_false_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271448']['Manage']
  _etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path = node['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path']
  file _etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path) }
  end
  file_line '_etc_modprobe_d_cramfs_conf_blacklist_cramfs_271448' do
    path _etc_modprobe_d_cramfs_conf_blacklist_cramfs_Path
    line node['ol9STIG']['stigrule_271448']['Setting']['_etc_modprobe_d_cramfs_conf_blacklist_cramfs_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271449']['Manage']
  _etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path = node['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path']
  file _etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_271449' do
    path _etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Path
    line node['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_install_bluetooth__bin_false_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271449']['Manage']
  _etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path = node['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path']
  file _etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path) }
  end
  file_line '_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_271449' do
    path _etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Path
    line node['ol9STIG']['stigrule_271449']['Setting']['_etc_modprobe_d_bluetooth_conf_blacklist_bluetooth_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271450']['Manage']
  _etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path = node['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path']
  file _etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path) }
  end
  file_line '_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_271450' do
    path _etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Path
    line node['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_install_usb_storage__bin_false_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271450']['Manage']
  _etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path = node['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path']
  file _etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path do
    action :create
    not_if { ::File.exist?(_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path) }
  end
  file_line '_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_271450' do
    path _etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Path
    line node['ol9STIG']['stigrule_271450']['Setting']['_etc_modprobe_d_usb_storage_conf_blacklist_usb_storage_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271452']['Manage']
  _etc_selinux_config_Path = node['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Path']
  file _etc_selinux_config_Path do
    action :create
    not_if { ::File.exist?(_etc_selinux_config_Path) }
  end
  file_line '_etc_selinux_config_271452' do
    path _etc_selinux_config_Path
    match node['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Regexp']
    line node['ol9STIG']['stigrule_271452']['Setting']['_etc_selinux_config_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271453']['Manage']
  _etc_selinux_config_Path = node['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Path']
  file _etc_selinux_config_Path do
    action :create
    not_if { ::File.exist?(_etc_selinux_config_Path) }
  end
  file_line '_etc_selinux_config_271453' do
    path _etc_selinux_config_Path
    match node['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Regexp']
    line node['ol9STIG']['stigrule_271453']['Setting']['_etc_selinux_config_Line']
    notifies :run, 'execute[do_reboot]', :delayed
  end
end
if node['ol9STIG']['stigrule_271455']['Manage']
  file '_etc_issue_271455' do
    path node['ol9STIG']['stigrule_271455']['Setting']['_etc_issue_Path']
    content node['ol9STIG']['stigrule_271455']['Setting']['_etc_issue_Content']
  end
end
if node['ol9STIG']['stigrule_271456']['Manage']
  dnf_package 'nfs_utils_271456' do
    package_name node['ol9STIG']['stigrule_271456']['Setting']['nfs_utils_PackageName']
    action node['ol9STIG']['stigrule_271456']['Setting']['nfs_utils_Action']
  end
end
if node['ol9STIG']['stigrule_271457']['Manage']
  dnf_package 'epel_release_271457' do
    package_name node['ol9STIG']['stigrule_271457']['Setting']['epel_release_PackageName']
    action node['ol9STIG']['stigrule_271457']['Setting']['epel_release_Action']
  end
end
if node['ol9STIG']['stigrule_271458']['Manage']
  dnf_package 'telnet_server_271458' do
    package_name node['ol9STIG']['stigrule_271458']['Setting']['telnet_server_PackageName']
    action node['ol9STIG']['stigrule_271458']['Setting']['telnet_server_Action']
  end
end
if node['ol9STIG']['stigrule_271459']['Manage']
  dnf_package 'gssproxy_271459' do
    package_name node['ol9STIG']['stigrule_271459']['Setting']['gssproxy_PackageName']
    action node['ol9STIG']['stigrule_271459']['Setting']['gssproxy_Action']
  end
end
if node['ol9STIG']['stigrule_271460']['Manage']
  dnf_package 'iprutils_271460' do
    package_name node['ol9STIG']['stigrule_271460']['Setting']['iprutils_PackageName']
    action node['ol9STIG']['stigrule_271460']['Setting']['iprutils_Action']
  end
end
if node['ol9STIG']['stigrule_271461']['Manage']
  dnf_package 'tuned_271461' do
    package_name node['ol9STIG']['stigrule_271461']['Setting']['tuned_PackageName']
    action node['ol9STIG']['stigrule_271461']['Setting']['tuned_Action']
  end
end
if node['ol9STIG']['stigrule_271462']['Manage']
  dnf_package 'vsftpd_271462' do
    package_name node['ol9STIG']['stigrule_271462']['Setting']['vsftpd_PackageName']
    action node['ol9STIG']['stigrule_271462']['Setting']['vsftpd_Action']
  end
end
if node['ol9STIG']['stigrule_271463']['Manage']
  dnf_package 'tftp_271463' do
    package_name node['ol9STIG']['stigrule_271463']['Setting']['tftp_PackageName']
    action node['ol9STIG']['stigrule_271463']['Setting']['tftp_Action']
  end
end
if node['ol9STIG']['stigrule_271464']['Manage']
  dnf_package 'quagga_271464' do
    package_name node['ol9STIG']['stigrule_271464']['Setting']['quagga_PackageName']
    action node['ol9STIG']['stigrule_271464']['Setting']['quagga_Action']
  end
end
if node['ol9STIG']['stigrule_271466']['Manage']
  dnf_package 'sendmail_271466' do
    package_name node['ol9STIG']['stigrule_271466']['Setting']['sendmail_PackageName']
    action node['ol9STIG']['stigrule_271466']['Setting']['sendmail_Action']
  end
end
if node['ol9STIG']['stigrule_271467']['Manage']
  dnf_package 'policycoreutils_271467' do
    package_name node['ol9STIG']['stigrule_271467']['Setting']['policycoreutils_PackageName']
    action node['ol9STIG']['stigrule_271467']['Setting']['policycoreutils_Action']
  end
end
if node['ol9STIG']['stigrule_271468']['Manage']
  dnf_package 'policycoreutils_python_utils_271468' do
    package_name node['ol9STIG']['stigrule_271468']['Setting']['policycoreutils_python_utils_PackageName']
    action node['ol9STIG']['stigrule_271468']['Setting']['policycoreutils_python_utils_Action']
  end
end
if node['ol9STIG']['stigrule_271469']['Manage']
  dnf_package 'firewalld_271469' do
    package_name node['ol9STIG']['stigrule_271469']['Setting']['firewalld_PackageName']
    action node['ol9STIG']['stigrule_271469']['Setting']['firewalld_Action']
  end
end
if node['ol9STIG']['stigrule_271470']['Manage']
  service 'firewalld_enable_271470' do
    service_name node['ol9STIG']['stigrule_271470']['Setting']['firewalld_enable_ServiceName']
    action node['ol9STIG']['stigrule_271470']['Setting']['firewalld_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271470']['Manage']
  service 'firewalld_start_271470' do
    service_name node['ol9STIG']['stigrule_271470']['Setting']['firewalld_start_ServiceName']
    action node['ol9STIG']['stigrule_271470']['Setting']['firewalld_start_Action']
  end
end
if node['ol9STIG']['stigrule_271474']['Manage']
  dnf_package 'sudo_271474' do
    package_name node['ol9STIG']['stigrule_271474']['Setting']['sudo_PackageName']
    action node['ol9STIG']['stigrule_271474']['Setting']['sudo_Action']
  end
end
if node['ol9STIG']['stigrule_271477']['Manage']
  dnf_package 'crypto_policies_271477' do
    package_name node['ol9STIG']['stigrule_271477']['Setting']['crypto_policies_PackageName']
    action node['ol9STIG']['stigrule_271477']['Setting']['crypto_policies_Action']
  end
end
if node['ol9STIG']['stigrule_271482']['Manage']
  dnf_package 'openssh_server_271482' do
    package_name node['ol9STIG']['stigrule_271482']['Setting']['openssh_server_PackageName']
    action node['ol9STIG']['stigrule_271482']['Setting']['openssh_server_Action']
  end
end
if node['ol9STIG']['stigrule_271483']['Manage']
  service 'sshd_enable_271483' do
    service_name node['ol9STIG']['stigrule_271483']['Setting']['sshd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271483']['Setting']['sshd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271487']['Manage']
  file_line 'banner_271487' do
    path node['ol9STIG']['stigrule_271487']['Setting']['banner_Path']
    match node['ol9STIG']['stigrule_271487']['Setting']['banner_Regexp']
    line node['ol9STIG']['stigrule_271487']['Setting']['banner_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271487']['Setting']['banner_Only_if']
  end
end
if node['ol9STIG']['stigrule_271488']['Manage']
  dnf_package 'openssh_clients_271488' do
    package_name node['ol9STIG']['stigrule_271488']['Setting']['openssh_clients_PackageName']
    action node['ol9STIG']['stigrule_271488']['Setting']['openssh_clients_Action']
  end
end
if node['ol9STIG']['stigrule_271491']['Manage']
  dnf_package 'openssl_pkcs11_271491' do
    package_name node['ol9STIG']['stigrule_271491']['Setting']['openssl_pkcs11_PackageName']
    action node['ol9STIG']['stigrule_271491']['Setting']['openssl_pkcs11_Action']
  end
end
if node['ol9STIG']['stigrule_271493']['Manage']
  dnf_package 'sssd_271493' do
    package_name node['ol9STIG']['stigrule_271493']['Setting']['sssd_PackageName']
    action node['ol9STIG']['stigrule_271493']['Setting']['sssd_Action']
  end
end
if node['ol9STIG']['stigrule_271494']['Manage']
  service 'sssd_enable_271494' do
    service_name node['ol9STIG']['stigrule_271494']['Setting']['sssd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271494']['Setting']['sssd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271494']['Manage']
  service 'sssd_start_271494' do
    service_name node['ol9STIG']['stigrule_271494']['Setting']['sssd_start_ServiceName']
    action node['ol9STIG']['stigrule_271494']['Setting']['sssd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271495']['Manage']
  dnf_package 's_nail_271495' do
    package_name node['ol9STIG']['stigrule_271495']['Setting']['s_nail_PackageName']
    action node['ol9STIG']['stigrule_271495']['Setting']['s_nail_Action']
  end
end
if node['ol9STIG']['stigrule_271501']['Manage']
  dnf_package 'chrony_271501' do
    package_name node['ol9STIG']['stigrule_271501']['Setting']['chrony_PackageName']
    action node['ol9STIG']['stigrule_271501']['Setting']['chrony_Action']
  end
end
if node['ol9STIG']['stigrule_271502']['Manage']
  service 'chronyd_enable_271502' do
    service_name node['ol9STIG']['stigrule_271502']['Setting']['chronyd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271502']['Setting']['chronyd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271502']['Manage']
  service 'chronyd_start_271502' do
    service_name node['ol9STIG']['stigrule_271502']['Setting']['chronyd_start_ServiceName']
    action node['ol9STIG']['stigrule_271502']['Setting']['chronyd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271503']['Manage']
  dnf_package 'usbguard_271503' do
    package_name node['ol9STIG']['stigrule_271503']['Setting']['usbguard_PackageName']
    action node['ol9STIG']['stigrule_271503']['Setting']['usbguard_Action']
  end
end
if node['ol9STIG']['stigrule_271504']['Manage']
  service 'usbguard_enable_271504' do
    service_name node['ol9STIG']['stigrule_271504']['Setting']['usbguard_enable_ServiceName']
    action node['ol9STIG']['stigrule_271504']['Setting']['usbguard_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271504']['Manage']
  service 'usbguard_start_271504' do
    service_name node['ol9STIG']['stigrule_271504']['Setting']['usbguard_start_ServiceName']
    action node['ol9STIG']['stigrule_271504']['Setting']['usbguard_start_Action']
  end
end
if node['ol9STIG']['stigrule_271506']['Manage']
  dnf_package 'fapolicyd_271506' do
    package_name node['ol9STIG']['stigrule_271506']['Setting']['fapolicyd_PackageName']
    action node['ol9STIG']['stigrule_271506']['Setting']['fapolicyd_Action']
  end
end
if node['ol9STIG']['stigrule_271507']['Manage']
  service 'fapolicyd_enable_271507' do
    service_name node['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271507']['Manage']
  service 'fapolicyd_start_271507' do
    service_name node['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_start_ServiceName']
    action node['ol9STIG']['stigrule_271507']['Setting']['fapolicyd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271508']['Manage']
  dnf_package 'rsyslog_271508' do
    package_name node['ol9STIG']['stigrule_271508']['Setting']['rsyslog_PackageName']
    action node['ol9STIG']['stigrule_271508']['Setting']['rsyslog_Action']
  end
end
if node['ol9STIG']['stigrule_271509']['Manage']
  service 'rsyslog_enable_271509' do
    service_name node['ol9STIG']['stigrule_271509']['Setting']['rsyslog_enable_ServiceName']
    action node['ol9STIG']['stigrule_271509']['Setting']['rsyslog_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271509']['Manage']
  service 'rsyslog_start_271509' do
    service_name node['ol9STIG']['stigrule_271509']['Setting']['rsyslog_start_ServiceName']
    action node['ol9STIG']['stigrule_271509']['Setting']['rsyslog_start_Action']
  end
end
if node['ol9STIG']['stigrule_271510']['Manage']
  dnf_package 'rsyslog_gnutls_271510' do
    package_name node['ol9STIG']['stigrule_271510']['Setting']['rsyslog_gnutls_PackageName']
    action node['ol9STIG']['stigrule_271510']['Setting']['rsyslog_gnutls_Action']
  end
end
if node['ol9STIG']['stigrule_271511']['Manage']
  dnf_package 'rng_tools_271511' do
    package_name node['ol9STIG']['stigrule_271511']['Setting']['rng_tools_PackageName']
    action node['ol9STIG']['stigrule_271511']['Setting']['rng_tools_Action']
  end
end
if node['ol9STIG']['stigrule_271511']['Manage']
  service 'rngd_enable_271511' do
    service_name node['ol9STIG']['stigrule_271511']['Setting']['rngd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271511']['Setting']['rngd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271511']['Manage']
  service 'rngd_start_271511' do
    service_name node['ol9STIG']['stigrule_271511']['Setting']['rngd_start_ServiceName']
    action node['ol9STIG']['stigrule_271511']['Setting']['rngd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271512']['Manage']
  dnf_package 'rng_tools_271512' do
    package_name node['ol9STIG']['stigrule_271512']['Setting']['rng_tools_PackageName']
    action node['ol9STIG']['stigrule_271512']['Setting']['rng_tools_Action']
  end
end
if node['ol9STIG']['stigrule_271513']['Manage']
  dnf_package 'nss_tools_271513' do
    package_name node['ol9STIG']['stigrule_271513']['Setting']['nss_tools_PackageName']
    action node['ol9STIG']['stigrule_271513']['Setting']['nss_tools_Action']
  end
end
if node['ol9STIG']['stigrule_271514']['Manage']
  dnf_package 'pcsc_lite_271514' do
    package_name node['ol9STIG']['stigrule_271514']['Setting']['pcsc_lite_PackageName']
    action node['ol9STIG']['stigrule_271514']['Setting']['pcsc_lite_Action']
  end
end
if node['ol9STIG']['stigrule_271515']['Manage']
  dnf_package 'opensc_271515' do
    package_name node['ol9STIG']['stigrule_271515']['Setting']['opensc_PackageName']
    action node['ol9STIG']['stigrule_271515']['Setting']['opensc_Action']
  end
end
if node['ol9STIG']['stigrule_271516']['Manage']
  service 'pcscd_enable_271516' do
    service_name node['ol9STIG']['stigrule_271516']['Setting']['pcscd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271516']['Setting']['pcscd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271516']['Manage']
  service 'pcscd_start_271516' do
    service_name node['ol9STIG']['stigrule_271516']['Setting']['pcscd_start_ServiceName']
    action node['ol9STIG']['stigrule_271516']['Setting']['pcscd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271517']['Manage']
  dnf_package 'libreswan_271517' do
    package_name node['ol9STIG']['stigrule_271517']['Setting']['libreswan_PackageName']
    action node['ol9STIG']['stigrule_271517']['Setting']['libreswan_Action']
  end
end
if node['ol9STIG']['stigrule_271518']['Manage']
  dnf_package 'gnutls_utils_271518' do
    package_name node['ol9STIG']['stigrule_271518']['Setting']['gnutls_utils_PackageName']
    action node['ol9STIG']['stigrule_271518']['Setting']['gnutls_utils_Action']
  end
end
if node['ol9STIG']['stigrule_271519']['Manage']
  dnf_package 'audit_271519' do
    package_name node['ol9STIG']['stigrule_271519']['Setting']['audit_PackageName']
    action node['ol9STIG']['stigrule_271519']['Setting']['audit_Action']
  end
end
if node['ol9STIG']['stigrule_271520']['Manage']
  service 'auditd_enable_271520' do
    service_name node['ol9STIG']['stigrule_271520']['Setting']['auditd_enable_ServiceName']
    action node['ol9STIG']['stigrule_271520']['Setting']['auditd_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271520']['Manage']
  service 'auditd_start_271520' do
    service_name node['ol9STIG']['stigrule_271520']['Setting']['auditd_start_ServiceName']
    action node['ol9STIG']['stigrule_271520']['Setting']['auditd_start_Action']
  end
end
if node['ol9STIG']['stigrule_271521']['Manage']
  dnf_package 'audispd_plugins_271521' do
    package_name node['ol9STIG']['stigrule_271521']['Setting']['audispd_plugins_PackageName']
    action node['ol9STIG']['stigrule_271521']['Setting']['audispd_plugins_Action']
  end
end
if node['ol9STIG']['stigrule_271522']['Manage']
  _etc_dnf_dnf_conf_Path = node['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Path']
  _etc_dnf_dnf_conf_Dir = ::File.dirname(_etc_dnf_dnf_conf_Path)
  directory _etc_dnf_dnf_conf_Dir do
    recursive true
  end
  file _etc_dnf_dnf_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_dnf_dnf_conf_Path) }
  end
  ini_setting '_etc_dnf_dnf_conf_271522' do
    path _etc_dnf_dnf_conf_Path
    section node['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Section']
    setting node['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Option']
    value node['ol9STIG']['stigrule_271522']['Setting']['_etc_dnf_dnf_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271523']['Manage']
  _etc_dnf_dnf_conf_Path = node['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Path']
  _etc_dnf_dnf_conf_Dir = ::File.dirname(_etc_dnf_dnf_conf_Path)
  directory _etc_dnf_dnf_conf_Dir do
    recursive true
  end
  file _etc_dnf_dnf_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_dnf_dnf_conf_Path) }
  end
  ini_setting '_etc_dnf_dnf_conf_271523' do
    path _etc_dnf_dnf_conf_Path
    section node['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Section']
    setting node['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Option']
    value node['ol9STIG']['stigrule_271523']['Setting']['_etc_dnf_dnf_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271524']['Manage']
  _etc_dnf_dnf_conf_Path = node['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Path']
  _etc_dnf_dnf_conf_Dir = ::File.dirname(_etc_dnf_dnf_conf_Path)
  directory _etc_dnf_dnf_conf_Dir do
    recursive true
  end
  file _etc_dnf_dnf_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_dnf_dnf_conf_Path) }
  end
  ini_setting '_etc_dnf_dnf_conf_271524' do
    path _etc_dnf_dnf_conf_Path
    section node['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Section']
    setting node['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Option']
    value node['ol9STIG']['stigrule_271524']['Setting']['_etc_dnf_dnf_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271527']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_sudoers_271527' do
    path node['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Path']
    match node['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Regexp']
    line node['ol9STIG']['stigrule_271527']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271528']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_sudoers_d__271528' do
    path node['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Path']
    match node['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Regexp']
    line node['ol9STIG']['stigrule_271528']['Setting']['_etc_audit_rules_d_audit_rules__etc_sudoers_d__Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271529']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_group_271529' do
    path node['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Path']
    match node['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Regexp']
    line node['ol9STIG']['stigrule_271529']['Setting']['_etc_audit_rules_d_audit_rules__etc_group_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271530']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_gshadow_271530' do
    path node['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Path']
    match node['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Regexp']
    line node['ol9STIG']['stigrule_271530']['Setting']['_etc_audit_rules_d_audit_rules__etc_gshadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271531']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_security_opasswd_271531' do
    path node['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Path']
    match node['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Regexp']
    line node['ol9STIG']['stigrule_271531']['Setting']['_etc_audit_rules_d_audit_rules__etc_security_opasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271532']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_passwd_271532' do
    path node['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Path']
    match node['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Regexp']
    line node['ol9STIG']['stigrule_271532']['Setting']['_etc_audit_rules_d_audit_rules__etc_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271533']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_shadow_271533' do
    path node['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Path']
    match node['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Regexp']
    line node['ol9STIG']['stigrule_271533']['Setting']['_etc_audit_rules_d_audit_rules__etc_shadow_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271534']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_271534' do
    path node['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Path']
    match node['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Regexp']
    line node['ol9STIG']['stigrule_271534']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_update_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271535']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_su_271535' do
    path node['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Path']
    match node['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Regexp']
    line node['ol9STIG']['stigrule_271535']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_su_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271536']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_271536' do
    path node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Path']
    match node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Regexp']
    line node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_unset_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271536']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_271536' do
    path node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Path']
    match node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Regexp']
    line node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_unset_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271536']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_lremovexattr_b32_271536' do
    path node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Path']
    match node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Regexp']
    line node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271536']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_lremovexattr_b64_271536' do
    path node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Path']
    match node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Regexp']
    line node['ol9STIG']['stigrule_271536']['Setting']['_etc_audit_rules_d_audit_rules_lremovexattr_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271537']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_chage_271537' do
    path node['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Path']
    match node['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Regexp']
    line node['ol9STIG']['stigrule_271537']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chage_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271538']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_chcon_271538' do
    path node['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Path']
    match node['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Regexp']
    line node['ol9STIG']['stigrule_271538']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chcon_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271539']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_setfacl_271539' do
    path node['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Path']
    match node['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Regexp']
    line node['ol9STIG']['stigrule_271539']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_setfacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271540']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_chsh_271540' do
    path node['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Path']
    match node['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Regexp']
    line node['ol9STIG']['stigrule_271540']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chsh_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271541']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_crontab_271541' do
    path node['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Path']
    match node['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Regexp']
    line node['ol9STIG']['stigrule_271541']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_crontab_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271542']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_271542' do
    path node['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Path']
    match node['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Regexp']
    line node['ol9STIG']['stigrule_271542']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_gpasswd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271543']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_newgrp_271543' do
    path node['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Path']
    match node['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Regexp']
    line node['ol9STIG']['stigrule_271543']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_newgrp_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271544']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_271544' do
    path node['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Path']
    match node['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Regexp']
    line node['ol9STIG']['stigrule_271544']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_pam_timestamp_check_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271545']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_passwd_271545' do
    path node['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Path']
    match node['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Regexp']
    line node['ol9STIG']['stigrule_271545']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_passwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271546']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_271546' do
    path node['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Path']
    match node['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Regexp']
    line node['ol9STIG']['stigrule_271546']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postdrop_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271547']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_271547' do
    path node['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Path']
    match node['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Regexp']
    line node['ol9STIG']['stigrule_271547']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_postqueue_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271548']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_271548' do
    path node['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Path']
    match node['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Regexp']
    line node['ol9STIG']['stigrule_271548']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_ssh_agent_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271549']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_271549' do
    path node['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Path']
    match node['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Regexp']
    line node['ol9STIG']['stigrule_271549']['Setting']['_etc_audit_rules_d_audit_rules__usr_libexec_openssh_ssh_keysign_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271550']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_271550' do
    path node['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Path']
    match node['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Regexp']
    line node['ol9STIG']['stigrule_271550']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudoedit_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271551']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_271551' do
    path node['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Path']
    match node['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Regexp']
    line node['ol9STIG']['stigrule_271551']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_unix_chkpwd_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271552']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_271552' do
    path node['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Path']
    match node['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Regexp']
    line node['ol9STIG']['stigrule_271552']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_userhelper_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271553']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_mount_271553' do
    path node['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Path']
    match node['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Regexp']
    line node['ol9STIG']['stigrule_271553']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_mount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271554']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_271554' do
    path node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Path']
    match node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Regexp']
    line node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271554']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_271554' do
    path node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Path']
    match node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Regexp']
    line node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EPERM_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271554']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_271554' do
    path node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Path']
    match node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Regexp']
    line node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271554']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_271554' do
    path node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Path']
    match node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Regexp']
    line node['ol9STIG']['stigrule_271554']['Setting']['_etc_audit_rules_d_audit_rules_truncate_EACCES_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271555']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_chmod_b32_271555' do
    path node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Path']
    match node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Regexp']
    line node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271555']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_chmod_b64_271555' do
    path node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Path']
    match node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Regexp']
    line node['ol9STIG']['stigrule_271555']['Setting']['_etc_audit_rules_d_audit_rules_chmod_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271556']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_chown_b32_271556' do
    path node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Path']
    match node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Regexp']
    line node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271556']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_chown_b64_271556' do
    path node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Path']
    match node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Regexp']
    line node['ol9STIG']['stigrule_271556']['Setting']['_etc_audit_rules_d_audit_rules_chown_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271557']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_semanage_271557' do
    path node['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Path']
    match node['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Regexp']
    line node['ol9STIG']['stigrule_271557']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_semanage_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271558']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_271558' do
    path node['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Path']
    match node['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Regexp']
    line node['ol9STIG']['stigrule_271558']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setfiles_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271559']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_271559' do
    path node['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Path']
    match node['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Regexp']
    line node['ol9STIG']['stigrule_271559']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_setsebool_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271560']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_chacl_271560' do
    path node['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Path']
    match node['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Regexp']
    line node['ol9STIG']['stigrule_271560']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_chacl_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271561']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_sudo_271561' do
    path node['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Path']
    match node['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Regexp']
    line node['ol9STIG']['stigrule_271561']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_sudo_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271562']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_usermod_271562' do
    path node['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Path']
    match node['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Regexp']
    line node['ol9STIG']['stigrule_271562']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_usermod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271563']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_rename_b32_271563' do
    path node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Path']
    match node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Regexp']
    line node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271563']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_rename_b64_271563' do
    path node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Path']
    match node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Regexp']
    line node['ol9STIG']['stigrule_271563']['Setting']['_etc_audit_rules_d_audit_rules_rename_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271564']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_delete_module_b32_271564' do
    path node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Path']
    match node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Regexp']
    line node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271564']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_delete_module_b64_271564' do
    path node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Path']
    match node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Regexp']
    line node['ol9STIG']['stigrule_271564']['Setting']['_etc_audit_rules_d_audit_rules_delete_module_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271565']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_init_module_b32_271565' do
    path node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Path']
    match node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Regexp']
    line node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271565']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_init_module_b64_271565' do
    path node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Path']
    match node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Regexp']
    line node['ol9STIG']['stigrule_271565']['Setting']['_etc_audit_rules_d_audit_rules_init_module_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271566']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_kmod_271566' do
    path node['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Path']
    match node['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Regexp']
    line node['ol9STIG']['stigrule_271566']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_kmod_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271567']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__var_log_lastlog_271567' do
    path node['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Path']
    match node['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Regexp']
    line node['ol9STIG']['stigrule_271567']['Setting']['_etc_audit_rules_d_audit_rules__var_log_lastlog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271568']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_bin_umount_271568' do
    path node['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Path']
    match node['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Regexp']
    line node['ol9STIG']['stigrule_271568']['Setting']['_etc_audit_rules_d_audit_rules__usr_bin_umount_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271570']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_execve_uid_b32_271570' do
    path node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Path']
    match node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Regexp']
    line node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271570']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_execve_uid_b64_271570' do
    path node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Path']
    match node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Regexp']
    line node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_uid_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271570']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_execve_gid_b32_271570' do
    path node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Path']
    match node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Regexp']
    line node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271570']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_execve_gid_b64_271570' do
    path node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Path']
    match node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Regexp']
    line node['ol9STIG']['stigrule_271570']['Setting']['_etc_audit_rules_d_audit_rules_execve_gid_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271571']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__var_log_faillock_271571' do
    path node['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Path']
    match node['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Regexp']
    line node['ol9STIG']['stigrule_271571']['Setting']['_etc_audit_rules_d_audit_rules__var_log_faillock_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271572']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__var_log_tallylog_271572' do
    path node['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Path']
    match node['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Regexp']
    line node['ol9STIG']['stigrule_271572']['Setting']['_etc_audit_rules_d_audit_rules__var_log_tallylog_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271573']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_init_271573' do
    path node['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Path']
    match node['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Regexp']
    line node['ol9STIG']['stigrule_271573']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_init_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271574']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_271574' do
    path node['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Path']
    match node['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Regexp']
    line node['ol9STIG']['stigrule_271574']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_poweroff_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271575']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_reboot_271575' do
    path node['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Path']
    match node['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Regexp']
    line node['ol9STIG']['stigrule_271575']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_reboot_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271576']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_271576' do
    path node['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Path']
    match node['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Regexp']
    line node['ol9STIG']['stigrule_271576']['Setting']['_etc_audit_rules_d_audit_rules__usr_sbin_shutdown_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271578']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271578' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271578']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271579']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271579' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271579']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271580']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271580' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271580']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271581']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271581' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271581']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271582']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271582' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271582']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271586']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271586' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271586']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271589']['Manage']
  _etc_aliases_Path = node['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Path']
  file _etc_aliases_Path do
    action :create
    not_if { ::File.exist?(_etc_aliases_Path) }
  end
  file_line '_etc_aliases_271589' do
    path _etc_aliases_Path
    match node['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Regexp']
    line node['ol9STIG']['stigrule_271589']['Setting']['_etc_aliases_Line']
  end
end
if node['ol9STIG']['stigrule_271590']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_f2_271590' do
    path node['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Path']
    match node['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Regexp']
    line node['ol9STIG']['stigrule_271590']['Setting']['_etc_audit_rules_d_audit_rules_f2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271591']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271591' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271591']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271593']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271593' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271593']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271594']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_umount_b32_271594' do
    path node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Path']
    match node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Regexp']
    line node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271594']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_umount_b64_271594' do
    path node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Path']
    match node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Regexp']
    line node['ol9STIG']['stigrule_271594']['Setting']['_etc_audit_rules_d_audit_rules_umount_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271595']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_umount2_b32_271595' do
    path node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Path']
    match node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Regexp']
    line node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b32_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271595']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_umount2_b64_271595' do
    path node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Path']
    match node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Regexp']
    line node['ol9STIG']['stigrule_271595']['Setting']['_etc_audit_rules_d_audit_rules_umount2_b64_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271597']['Manage']
  _etc_audit_plugins_d_syslog_conf_active_Path = node['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Path']
  file _etc_audit_plugins_d_syslog_conf_active_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_plugins_d_syslog_conf_active_Path) }
  end
  file_line '_etc_audit_plugins_d_syslog_conf_active_271597' do
    path _etc_audit_plugins_d_syslog_conf_active_Path
    match node['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Regexp']
    line node['ol9STIG']['stigrule_271597']['Setting']['_etc_audit_plugins_d_syslog_conf_active_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271598']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271598' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271598']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271599']['Manage']
  _etc_audit_auditd_conf_space_left_Path = node['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Path']
  file _etc_audit_auditd_conf_space_left_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_space_left_Path) }
  end
  file_line '_etc_audit_auditd_conf_space_left_271599' do
    path _etc_audit_auditd_conf_space_left_Path
    match node['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Regexp']
    line node['ol9STIG']['stigrule_271599']['Setting']['_etc_audit_auditd_conf_space_left_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271600']['Manage']
  _etc_audit_auditd_conf_space_left_action_Path = node['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Path']
  file _etc_audit_auditd_conf_space_left_action_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_space_left_action_Path) }
  end
  file_line '_etc_audit_auditd_conf_space_left_action_271600' do
    path _etc_audit_auditd_conf_space_left_action_Path
    match node['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Regexp']
    line node['ol9STIG']['stigrule_271600']['Setting']['_etc_audit_auditd_conf_space_left_action_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271601']['Manage']
  _etc_audit_auditd_conf_admin_space_left_Path = node['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Path']
  file _etc_audit_auditd_conf_admin_space_left_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_admin_space_left_Path) }
  end
  file_line '_etc_audit_auditd_conf_admin_space_left_271601' do
    path _etc_audit_auditd_conf_admin_space_left_Path
    match node['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Regexp']
    line node['ol9STIG']['stigrule_271601']['Setting']['_etc_audit_auditd_conf_admin_space_left_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271602']['Manage']
  _etc_audit_auditd_conf_Path = node['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Path']
  file _etc_audit_auditd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_Path) }
  end
  file_line '_etc_audit_auditd_conf_271602' do
    path _etc_audit_auditd_conf_Path
    match node['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Regexp']
    line node['ol9STIG']['stigrule_271602']['Setting']['_etc_audit_auditd_conf_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271603']['Manage']
  _etc_audit_auditd_conf_admin_space_left_action_Path = node['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Path']
  file _etc_audit_auditd_conf_admin_space_left_action_Path do
    action :create
    not_if { ::File.exist?(_etc_audit_auditd_conf_admin_space_left_action_Path) }
  end
  file_line '_etc_audit_auditd_conf_admin_space_left_action_271603' do
    path _etc_audit_auditd_conf_admin_space_left_action_Path
    match node['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Regexp']
    line node['ol9STIG']['stigrule_271603']['Setting']['_etc_audit_auditd_conf_admin_space_left_action_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271607']['Manage']
  _etc_sssd_sssd_conf_Path = node['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Path']
  _etc_sssd_sssd_conf_Dir = ::File.dirname(_etc_sssd_sssd_conf_Path)
  directory _etc_sssd_sssd_conf_Dir do
    recursive true
  end
  file _etc_sssd_sssd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_sssd_sssd_conf_Path) }
  end
  ini_setting '_etc_sssd_sssd_conf_271607' do
    path _etc_sssd_sssd_conf_Path
    section node['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Section']
    setting node['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Option']
    value node['ol9STIG']['stigrule_271607']['Setting']['_etc_sssd_sssd_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271609']['Manage']
  _etc_sssd_sssd_conf_Path = node['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Path']
  _etc_sssd_sssd_conf_Dir = ::File.dirname(_etc_sssd_sssd_conf_Path)
  directory _etc_sssd_sssd_conf_Dir do
    recursive true
  end
  file _etc_sssd_sssd_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_sssd_sssd_conf_Path) }
  end
  ini_setting '_etc_sssd_sssd_conf_271609' do
    path _etc_sssd_sssd_conf_Path
    section node['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Section']
    setting node['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Option']
    value node['ol9STIG']['stigrule_271609']['Setting']['_etc_sssd_sssd_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271610']['Manage']
  _etc_opensc_conf_Path = node['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Path']
  file _etc_opensc_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_opensc_conf_Path) }
  end
  file_line '_etc_opensc_conf_271610' do
    path _etc_opensc_conf_Path
    match node['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Regexp']
    line node['ol9STIG']['stigrule_271610']['Setting']['_etc_opensc_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271613']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271613' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271613']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271615']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271615' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271615']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271616']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271616' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271616']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271617']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271617' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271617']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271618']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271618' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271618']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271619']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271619' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271619']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271620']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271620' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271620']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271621']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271621' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271621']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271622']['Manage']
  _etc_libuser_conf_Path = node['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Path']
  _etc_libuser_conf_Dir = ::File.dirname(_etc_libuser_conf_Path)
  directory _etc_libuser_conf_Dir do
    recursive true
  end
  file _etc_libuser_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_libuser_conf_Path) }
  end
  ini_setting '_etc_libuser_conf_271622' do
    path _etc_libuser_conf_Path
    section node['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Section']
    setting node['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Option']
    value node['ol9STIG']['stigrule_271622']['Setting']['_etc_libuser_conf_Value']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271623']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271623' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271623']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271627']['Manage']
  _etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path = node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path']
  file _etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path) }
  end
  file_line '_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_271627' do
    path _etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Path
    match node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Regexp']
    line node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MIN_ROUNDS_Line']
  end
end
if node['ol9STIG']['stigrule_271627']['Manage']
  _etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path = node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path']
  file _etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path) }
  end
  file_line '_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_271627' do
    path _etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Path
    match node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Regexp']
    line node['ol9STIG']['stigrule_271627']['Setting']['_etc_login_defs_SHA_CRYPT_MAX_ROUNDS_Line']
  end
end
if node['ol9STIG']['stigrule_271629']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271629' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271629']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271631']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271631' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271631']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271633']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271633' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271633']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271636']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271636' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271636']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271637']['Manage']
  _etc_security_pwquality_conf_Path = node['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Path']
  file _etc_security_pwquality_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_pwquality_conf_Path) }
  end
  file_line '_etc_security_pwquality_conf_271637' do
    path _etc_security_pwquality_conf_Path
    match node['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Regexp']
    line node['ol9STIG']['stigrule_271637']['Setting']['_etc_security_pwquality_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271639']['Manage']
  systemd_unit 'autofs_service_disable_271639' do
    unit_name node['ol9STIG']['stigrule_271639']['Setting']['autofs_service_disable_UnitName']
    action node['ol9STIG']['stigrule_271639']['Setting']['autofs_service_disable_Action']
  end
end
if node['ol9STIG']['stigrule_271639']['Manage']
  systemd_unit 'autofs_service_mask_271639' do
    unit_name node['ol9STIG']['stigrule_271639']['Setting']['autofs_service_mask_UnitName']
    action node['ol9STIG']['stigrule_271639']['Setting']['autofs_service_mask_Action']
  end
end
if node['ol9STIG']['stigrule_271670']['Manage']
  _etc_dconf_db_local_d_00_security_settings_Path = node['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path']
  _etc_dconf_db_local_d_00_security_settings_Dir = ::File.dirname(_etc_dconf_db_local_d_00_security_settings_Path)
  directory _etc_dconf_db_local_d_00_security_settings_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_security_settings_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_security_settings_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_security_settings_271670' do
    path _etc_dconf_db_local_d_00_security_settings_Path
    section node['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section']
    setting node['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option']
    value node['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271670']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271671']['Manage']
  _etc_dconf_db_local_d_00_security_settings_Path = node['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path']
  _etc_dconf_db_local_d_00_security_settings_Dir = ::File.dirname(_etc_dconf_db_local_d_00_security_settings_Path)
  directory _etc_dconf_db_local_d_00_security_settings_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_security_settings_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_security_settings_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_security_settings_271671' do
    path _etc_dconf_db_local_d_00_security_settings_Path
    section node['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section']
    setting node['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option']
    value node['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271671']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271672']['Manage']
  _etc_dconf_db_local_d_02_login_screen_Path = node['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Path']
  _etc_dconf_db_local_d_02_login_screen_Dir = ::File.dirname(_etc_dconf_db_local_d_02_login_screen_Path)
  directory _etc_dconf_db_local_d_02_login_screen_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_02_login_screen_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_02_login_screen_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_02_login_screen_271672' do
    path _etc_dconf_db_local_d_02_login_screen_Path
    section node['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Section']
    setting node['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Option']
    value node['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271672']['Setting']['_etc_dconf_db_local_d_02_login_screen_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271673']['Manage']
  _etc_dconf_db_local_d_00_screensaver_Path = node['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Path']
  _etc_dconf_db_local_d_00_screensaver_Dir = ::File.dirname(_etc_dconf_db_local_d_00_screensaver_Path)
  directory _etc_dconf_db_local_d_00_screensaver_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_screensaver_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_271673' do
    path _etc_dconf_db_local_d_00_screensaver_Path
    section node['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Section']
    setting node['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Option']
    value node['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271673']['Setting']['_etc_dconf_db_local_d_00_screensaver_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271674']['Manage']
  _etc_dconf_db_local_d_00_screensaver_Path = node['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Path']
  _etc_dconf_db_local_d_00_screensaver_Dir = ::File.dirname(_etc_dconf_db_local_d_00_screensaver_Path)
  directory _etc_dconf_db_local_d_00_screensaver_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_screensaver_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_screensaver_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_screensaver_271674' do
    path _etc_dconf_db_local_d_00_screensaver_Path
    section node['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Section']
    setting node['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Option']
    value node['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271674']['Setting']['_etc_dconf_db_local_d_00_screensaver_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271676']['Manage']
  _etc_dconf_db_local_d_00_security_settings_Path = node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path']
  _etc_dconf_db_local_d_00_security_settings_Dir = ::File.dirname(_etc_dconf_db_local_d_00_security_settings_Path)
  directory _etc_dconf_db_local_d_00_security_settings_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_security_settings_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_security_settings_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_security_settings_271676' do
    path _etc_dconf_db_local_d_00_security_settings_Path
    section node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section']
    setting node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option']
    value node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271676']['Manage']
  _etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path = node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path']
  file _etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_271676' do
    path _etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Path
    line node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271676']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_picture_uri_Only_if']
  end
end
if node['ol9STIG']['stigrule_271677']['Manage']
  _etc_dconf_db_local_d_00_security_settings_Path = node['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path']
  _etc_dconf_db_local_d_00_security_settings_Dir = ::File.dirname(_etc_dconf_db_local_d_00_security_settings_Path)
  directory _etc_dconf_db_local_d_00_security_settings_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_security_settings_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_security_settings_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_security_settings_271677' do
    path _etc_dconf_db_local_d_00_security_settings_Path
    section node['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section']
    setting node['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option']
    value node['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271677']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271678']['Manage']
  _etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path = node['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path']
  file _etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_271678' do
    path _etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Path
    line node['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271678']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_automount_open_Only_if']
  end
end
if node['ol9STIG']['stigrule_271679']['Manage']
  _etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path = node['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path']
  file _etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_271679' do
    path _etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Path
    line node['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271679']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_autorun_never_Only_if']
  end
end
if node['ol9STIG']['stigrule_271680']['Manage']
  _etc_dconf_db_local_d_locks_session_banner_message_enable_Path = node['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Path']
  file _etc_dconf_db_local_d_locks_session_banner_message_enable_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_banner_message_enable_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_banner_message_enable_271680' do
    path _etc_dconf_db_local_d_locks_session_banner_message_enable_Path
    line node['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271680']['Setting']['_etc_dconf_db_local_d_locks_session_banner_message_enable_Only_if']
  end
end
if node['ol9STIG']['stigrule_271681']['Manage']
  _etc_dconf_db_local_d_locks_session_lock_enabled_Path = node['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Path']
  file _etc_dconf_db_local_d_locks_session_lock_enabled_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_lock_enabled_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_lock_enabled_271681' do
    path _etc_dconf_db_local_d_locks_session_lock_enabled_Path
    line node['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271681']['Setting']['_etc_dconf_db_local_d_locks_session_lock_enabled_Only_if']
  end
end
if node['ol9STIG']['stigrule_271682']['Manage']
  _etc_dconf_db_local_d_locks_session_idle_delay_Path = node['ol9STIG']['stigrule_271682']['Setting']['_etc_dconf_db_local_d_locks_session_idle_delay_Path']
  file _etc_dconf_db_local_d_locks_session_idle_delay_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_idle_delay_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_idle_delay_271682' do
    path _etc_dconf_db_local_d_locks_session_idle_delay_Path
    line node['ol9STIG']['stigrule_271682']['Setting']['_etc_dconf_db_local_d_locks_session_idle_delay_Line']
  end
end
if node['ol9STIG']['stigrule_271683']['Manage']
  _etc_dconf_db_local_d_locks_session_lock_delay_Path = node['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Path']
  file _etc_dconf_db_local_d_locks_session_lock_delay_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_lock_delay_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_lock_delay_271683' do
    path _etc_dconf_db_local_d_locks_session_lock_delay_Path
    line node['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271683']['Setting']['_etc_dconf_db_local_d_locks_session_lock_delay_Only_if']
  end
end
if node['ol9STIG']['stigrule_271684']['Manage']
  _etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path = node['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path']
  file _etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_271684' do
    path _etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Path
    line node['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271684']['Setting']['_etc_dconf_db_local_d_locks_00_security_settings_lock_removal_action_Only_if']
  end
end
if node['ol9STIG']['stigrule_271685']['Manage']
  _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path = node['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path']
  file _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_disable_restart_buttons_271685' do
    path _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path
    line node['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271685']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Only_if']
  end
end
if node['ol9STIG']['stigrule_271686']['Manage']
  _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path = node['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path']
  file _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_disable_restart_buttons_271686' do
    path _etc_dconf_db_local_d_locks_session_disable_restart_buttons_Path
    line node['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271686']['Setting']['_etc_dconf_db_local_d_locks_session_disable_restart_buttons_Only_if']
  end
end
if node['ol9STIG']['stigrule_271687']['Manage']
  _etc_dconf_db_local_d_locks_session_logout_Path = node['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Path']
  file _etc_dconf_db_local_d_locks_session_logout_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_locks_session_logout_Path) }
  end
  file_line '_etc_dconf_db_local_d_locks_session_logout_271687' do
    path _etc_dconf_db_local_d_locks_session_logout_Path
    line node['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Line']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271687']['Setting']['_etc_dconf_db_local_d_locks_session_logout_Only_if']
  end
end
if node['ol9STIG']['stigrule_271688']['Manage']
  _etc_dconf_db_local_d_01_banner_message_Path = node['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Path']
  _etc_dconf_db_local_d_01_banner_message_Dir = ::File.dirname(_etc_dconf_db_local_d_01_banner_message_Path)
  directory _etc_dconf_db_local_d_01_banner_message_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_01_banner_message_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_01_banner_message_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_01_banner_message_271688' do
    path _etc_dconf_db_local_d_01_banner_message_Path
    section node['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Section']
    setting node['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Option']
    value node['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271688']['Setting']['_etc_dconf_db_local_d_01_banner_message_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271689']['Manage']
  _etc_dconf_db_local_d_01_banner_message_Path = node['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Path']
  _etc_dconf_db_local_d_01_banner_message_Dir = ::File.dirname(_etc_dconf_db_local_d_01_banner_message_Path)
  directory _etc_dconf_db_local_d_01_banner_message_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_01_banner_message_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_01_banner_message_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_01_banner_message_271689' do
    path _etc_dconf_db_local_d_01_banner_message_Path
    section node['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Section']
    setting node['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Option']
    value node['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271689']['Setting']['_etc_dconf_db_local_d_01_banner_message_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271690']['Manage']
  _etc_dconf_db_local_d_00_security_settings_Path = node['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Path']
  _etc_dconf_db_local_d_00_security_settings_Dir = ::File.dirname(_etc_dconf_db_local_d_00_security_settings_Path)
  directory _etc_dconf_db_local_d_00_security_settings_Dir do
    recursive true
  end
  file _etc_dconf_db_local_d_00_security_settings_Path do
    action :create
    not_if { ::File.exist?(_etc_dconf_db_local_d_00_security_settings_Path) }
  end
  ini_setting '_etc_dconf_db_local_d_00_security_settings_271690' do
    path _etc_dconf_db_local_d_00_security_settings_Path
    section node['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Section']
    setting node['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Option']
    value node['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271690']['Setting']['_etc_dconf_db_local_d_00_security_settings_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271691']['Manage']
  _etc_gdm_custom_conf_Path = node['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Path']
  _etc_gdm_custom_conf_Dir = ::File.dirname(_etc_gdm_custom_conf_Path)
  directory _etc_gdm_custom_conf_Dir do
    recursive true
  end
  file _etc_gdm_custom_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_gdm_custom_conf_Path) }
  end
  ini_setting '_etc_gdm_custom_conf_271691' do
    path _etc_gdm_custom_conf_Path
    section node['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Section']
    setting node['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Option']
    value node['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Value']
    only_if node['ol9STIG']['stigrule_271691']['Setting']['_etc_gdm_custom_conf_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271693']['Manage']
  _etc_bashrc_Path = node['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Path']
  file _etc_bashrc_Path do
    action :create
    not_if { ::File.exist?(_etc_bashrc_Path) }
  end
  file_line '_etc_bashrc_271693' do
    path _etc_bashrc_Path
    match node['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Regexp']
    line node['ol9STIG']['stigrule_271693']['Setting']['_etc_bashrc_Line']
  end
end
if node['ol9STIG']['stigrule_271694']['Manage']
  _etc_csh_cshrc_Path = node['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Path']
  file _etc_csh_cshrc_Path do
    action :create
    not_if { ::File.exist?(_etc_csh_cshrc_Path) }
  end
  file_line '_etc_csh_cshrc_271694' do
    path _etc_csh_cshrc_Path
    match node['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Regexp']
    line node['ol9STIG']['stigrule_271694']['Setting']['_etc_csh_cshrc_Line']
  end
end
if node['ol9STIG']['stigrule_271695']['Manage']
  _etc_profile_Path = node['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Path']
  file _etc_profile_Path do
    action :create
    not_if { ::File.exist?(_etc_profile_Path) }
  end
  file_line '_etc_profile_271695' do
    path _etc_profile_Path
    match node['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Regexp']
    line node['ol9STIG']['stigrule_271695']['Setting']['_etc_profile_Line']
  end
end
if node['ol9STIG']['stigrule_271696']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271696' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271696']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271697']['Manage']
  _etc_chrony_conf_Path = node['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Path']
  file _etc_chrony_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_chrony_conf_Path) }
  end
  file_line '_etc_chrony_conf_271697' do
    path _etc_chrony_conf_Path
    match node['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Regexp']
    line node['ol9STIG']['stigrule_271697']['Setting']['_etc_chrony_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271698']['Manage']
  _etc_chrony_conf_Path = node['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Path']
  file _etc_chrony_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_chrony_conf_Path) }
  end
  file_line '_etc_chrony_conf_271698' do
    path _etc_chrony_conf_Path
    match node['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Regexp']
    line node['ol9STIG']['stigrule_271698']['Setting']['_etc_chrony_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271700']['Manage']
  _etc_usbguard_usbguard_daemon_conf_Path = node['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Path']
  file _etc_usbguard_usbguard_daemon_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_usbguard_usbguard_daemon_conf_Path) }
  end
  file_line '_etc_usbguard_usbguard_daemon_conf_271700' do
    path _etc_usbguard_usbguard_daemon_conf_Path
    match node['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Regexp']
    line node['ol9STIG']['stigrule_271700']['Setting']['_etc_usbguard_usbguard_daemon_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271703']['Manage']
  file_line 'LogLevel_271703' do
    path node['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Path']
    match node['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Regexp']
    line node['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271703']['Setting']['LogLevel_Only_if']
  end
end
if node['ol9STIG']['stigrule_271704']['Manage']
  file_line 'GSSAPIAuthentication_271704' do
    path node['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Path']
    match node['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Regexp']
    line node['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271704']['Setting']['GSSAPIAuthentication_Only_if']
  end
end
if node['ol9STIG']['stigrule_271705']['Manage']
  file_line 'RekeyLimit_271705' do
    path node['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Path']
    match node['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Regexp']
    line node['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271705']['Setting']['RekeyLimit_Only_if']
  end
end
if node['ol9STIG']['stigrule_271706']['Manage']
  file_line 'PermitEmptyPasswords_271706' do
    path node['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Path']
    match node['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Regexp']
    line node['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271706']['Setting']['PermitEmptyPasswords_Only_if']
  end
end
if node['ol9STIG']['stigrule_271707']['Manage']
  file_line 'UsePAM_271707' do
    path node['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Path']
    match node['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Regexp']
    line node['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271707']['Setting']['UsePAM_Only_if']
  end
end
if node['ol9STIG']['stigrule_271708']['Manage']
  file_line 'PermitRootLogin_271708' do
    path node['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Path']
    match node['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Regexp']
    line node['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271708']['Setting']['PermitRootLogin_Only_if']
  end
end
if node['ol9STIG']['stigrule_271709']['Manage']
  file_line 'ClientAliveCountMax_271709' do
    path node['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Path']
    match node['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Regexp']
    line node['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271709']['Setting']['ClientAliveCountMax_Only_if']
  end
end
if node['ol9STIG']['stigrule_271710']['Manage']
  file_line 'ClientAliveInterval_271710' do
    path node['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Path']
    match node['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Regexp']
    line node['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271710']['Setting']['ClientAliveInterval_Only_if']
  end
end
if node['ol9STIG']['stigrule_271711']['Manage']
  file_line 'IgnoreRhosts_271711' do
    path node['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Path']
    match node['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Regexp']
    line node['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271711']['Setting']['IgnoreRhosts_Only_if']
  end
end
if node['ol9STIG']['stigrule_271712']['Manage']
  file_line 'IgnoreUserKnownHosts_271712' do
    path node['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Path']
    match node['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Regexp']
    line node['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271712']['Setting']['IgnoreUserKnownHosts_Only_if']
  end
end
if node['ol9STIG']['stigrule_271713']['Manage']
  file_line 'X11Forwarding_271713' do
    path node['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Path']
    match node['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Regexp']
    line node['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271713']['Setting']['X11Forwarding_Only_if']
  end
end
if node['ol9STIG']['stigrule_271714']['Manage']
  file_line 'StrictModes_271714' do
    path node['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Path']
    match node['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Regexp']
    line node['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271714']['Setting']['StrictModes_Only_if']
  end
end
if node['ol9STIG']['stigrule_271715']['Manage']
  file_line 'PrintLastLog_271715' do
    path node['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Path']
    match node['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Regexp']
    line node['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271715']['Setting']['PrintLastLog_Only_if']
  end
end
if node['ol9STIG']['stigrule_271716']['Manage']
  file_line 'X11UseLocalhost_271716' do
    path node['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Path']
    match node['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Regexp']
    line node['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271716']['Setting']['X11UseLocalhost_Only_if']
  end
end
if node['ol9STIG']['stigrule_271717']['Manage']
  file_line 'Compression_271717' do
    path node['ol9STIG']['stigrule_271717']['Setting']['Compression_Path']
    match node['ol9STIG']['stigrule_271717']['Setting']['Compression_Regexp']
    line node['ol9STIG']['stigrule_271717']['Setting']['Compression_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271717']['Setting']['Compression_Only_if']
  end
end
if node['ol9STIG']['stigrule_271718']['Manage']
  file_line 'KerberosAuthentication_271718' do
    path node['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Path']
    match node['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Regexp']
    line node['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271718']['Setting']['KerberosAuthentication_Only_if']
  end
end
if node['ol9STIG']['stigrule_271719']['Manage']
  file_line 'HostbasedAuthentication_271719' do
    path node['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Path']
    match node['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Regexp']
    line node['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271719']['Setting']['HostbasedAuthentication_Only_if']
  end
end
if node['ol9STIG']['stigrule_271720']['Manage']
  file_line 'PermitUserEnvironment_271720' do
    path node['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Path']
    match node['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Regexp']
    line node['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271720']['Setting']['PermitUserEnvironment_Only_if']
  end
end
if node['ol9STIG']['stigrule_271721']['Manage']
  file_line 'PubkeyAuthentication_271721' do
    path node['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Path']
    match node['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Regexp']
    line node['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Line']
    notifies :restart, 'service[ssh_restart]', :delayed
    only_if node['ol9STIG']['stigrule_271721']['Setting']['PubkeyAuthentication_Only_if']
  end
end
if node['ol9STIG']['stigrule_271722']['Manage']
  _etc_sudoers_Path = node['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Path']
  file _etc_sudoers_Path do
    action :create
    not_if { ::File.exist?(_etc_sudoers_Path) }
  end
  file_line '_etc_sudoers_271722' do
    path _etc_sudoers_Path
    match node['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Regexp']
    line node['ol9STIG']['stigrule_271722']['Setting']['_etc_sudoers_Line']
  end
end
if node['ol9STIG']['stigrule_271727']['Manage']
  sysctl 'user_max_user_namespaces_271727' do
    key node['ol9STIG']['stigrule_271727']['Setting']['user_max_user_namespaces_Key']
    value node['ol9STIG']['stigrule_271727']['Setting']['user_max_user_namespaces_Value']
  end
end
if node['ol9STIG']['stigrule_271728']['Manage']
  sysctl 'kernel_core_pattern_271728' do
    key node['ol9STIG']['stigrule_271728']['Setting']['kernel_core_pattern_Key']
    value node['ol9STIG']['stigrule_271728']['Setting']['kernel_core_pattern_Value']
  end
end
if node['ol9STIG']['stigrule_271729']['Manage']
  _etc_systemd_coredump_conf_Path = node['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Path']
  file _etc_systemd_coredump_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_systemd_coredump_conf_Path) }
  end
  file_line '_etc_systemd_coredump_conf_271729' do
    path _etc_systemd_coredump_conf_Path
    match node['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Regexp']
    line node['ol9STIG']['stigrule_271729']['Setting']['_etc_systemd_coredump_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271730']['Manage']
  _etc_systemd_coredump_conf_Path = node['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Path']
  file _etc_systemd_coredump_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_systemd_coredump_conf_Path) }
  end
  file_line '_etc_systemd_coredump_conf_271730' do
    path _etc_systemd_coredump_conf_Path
    match node['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Regexp']
    line node['ol9STIG']['stigrule_271730']['Setting']['_etc_systemd_coredump_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271731']['Manage']
  _etc_security_limits_conf_Path = node['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Path']
  file _etc_security_limits_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_limits_conf_Path) }
  end
  file_line '_etc_security_limits_conf_271731' do
    path _etc_security_limits_conf_Path
    match node['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Regexp']
    line node['ol9STIG']['stigrule_271731']['Setting']['_etc_security_limits_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271732']['Manage']
  systemd_unit 'systemd_coredump_socket_disable_271732' do
    unit_name node['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_disable_UnitName']
    action node['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_disable_Action']
  end
end
if node['ol9STIG']['stigrule_271732']['Manage']
  systemd_unit 'systemd_coredump_socket_mask_271732' do
    unit_name node['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_mask_UnitName']
    action node['ol9STIG']['stigrule_271732']['Setting']['systemd_coredump_socket_mask_Action']
    notifies :run, 'execute[daemon_reload]', :immediately
  end
end
if node['ol9STIG']['stigrule_271733']['Manage']
  systemd_unit 'kdump_disable_271733' do
    unit_name node['ol9STIG']['stigrule_271733']['Setting']['kdump_disable_UnitName']
    action node['ol9STIG']['stigrule_271733']['Setting']['kdump_disable_Action']
  end
end
if node['ol9STIG']['stigrule_271733']['Manage']
  systemd_unit 'kdump_mask_271733' do
    unit_name node['ol9STIG']['stigrule_271733']['Setting']['kdump_mask_UnitName']
    action node['ol9STIG']['stigrule_271733']['Setting']['kdump_mask_Action']
  end
end
if node['ol9STIG']['stigrule_271739']['Manage']
  service 'systemd_journald_enable_271739' do
    service_name node['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_enable_ServiceName']
    action node['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_enable_Action']
  end
end
if node['ol9STIG']['stigrule_271739']['Manage']
  service 'systemd_journald_start_271739' do
    service_name node['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_start_ServiceName']
    action node['ol9STIG']['stigrule_271739']['Setting']['systemd_journald_start_Action']
  end
end
if node['ol9STIG']['stigrule_271740']['Manage']
  sysctl 'fs_protected_hardlinks_271740' do
    key node['ol9STIG']['stigrule_271740']['Setting']['fs_protected_hardlinks_Key']
    value node['ol9STIG']['stigrule_271740']['Setting']['fs_protected_hardlinks_Value']
  end
end
if node['ol9STIG']['stigrule_271741']['Manage']
  sysctl 'fs_protected_symlinks_271741' do
    key node['ol9STIG']['stigrule_271741']['Setting']['fs_protected_symlinks_Key']
    value node['ol9STIG']['stigrule_271741']['Setting']['fs_protected_symlinks_Value']
  end
end
if node['ol9STIG']['stigrule_271742']['Manage']
  systemd_unit 'debug_shell_service_disable_271742' do
    unit_name node['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_disable_UnitName']
    action node['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_disable_Action']
  end
end
if node['ol9STIG']['stigrule_271742']['Manage']
  systemd_unit 'debug_shell_service_mask_271742' do
    unit_name node['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_mask_UnitName']
    action node['ol9STIG']['stigrule_271742']['Setting']['debug_shell_service_mask_Action']
  end
end
if node['ol9STIG']['stigrule_271744']['Manage']
  _etc_aliases_Path = node['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Path']
  file _etc_aliases_Path do
    action :create
    not_if { ::File.exist?(_etc_aliases_Path) }
  end
  file_line '_etc_aliases_271744' do
    path _etc_aliases_Path
    match node['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Regexp']
    line node['ol9STIG']['stigrule_271744']['Setting']['_etc_aliases_Line']
  end
end
if node['ol9STIG']['stigrule_271745']['Manage']
  sysctl 'kernel_dmesg_restrict_271745' do
    key node['ol9STIG']['stigrule_271745']['Setting']['kernel_dmesg_restrict_Key']
    value node['ol9STIG']['stigrule_271745']['Setting']['kernel_dmesg_restrict_Value']
  end
end
if node['ol9STIG']['stigrule_271746']['Manage']
  sysctl 'kernel_perf_event_paranoid_271746' do
    key node['ol9STIG']['stigrule_271746']['Setting']['kernel_perf_event_paranoid_Key']
    value node['ol9STIG']['stigrule_271746']['Setting']['kernel_perf_event_paranoid_Value']
  end
end
if node['ol9STIG']['stigrule_271747']['Manage']
  sysctl 'kernel_kptr_restrict_271747' do
    key node['ol9STIG']['stigrule_271747']['Setting']['kernel_kptr_restrict_Key']
    value node['ol9STIG']['stigrule_271747']['Setting']['kernel_kptr_restrict_Value']
  end
end
if node['ol9STIG']['stigrule_271748']['Manage']
  sysctl 'kernel_unprivileged_bpf_disabled_271748' do
    key node['ol9STIG']['stigrule_271748']['Setting']['kernel_unprivileged_bpf_disabled_Key']
    value node['ol9STIG']['stigrule_271748']['Setting']['kernel_unprivileged_bpf_disabled_Value']
  end
end
if node['ol9STIG']['stigrule_271749']['Manage']
  sysctl 'kernel_yama_ptrace_scope_271749' do
    key node['ol9STIG']['stigrule_271749']['Setting']['kernel_yama_ptrace_scope_Key']
    value node['ol9STIG']['stigrule_271749']['Setting']['kernel_yama_ptrace_scope_Value']
  end
end
if node['ol9STIG']['stigrule_271750']['Manage']
  file '_etc_profile_d_tmout_sh_271750' do
    path node['ol9STIG']['stigrule_271750']['Setting']['_etc_profile_d_tmout_sh_Path']
    content node['ol9STIG']['stigrule_271750']['Setting']['_etc_profile_d_tmout_sh_Content']
  end
end
if node['ol9STIG']['stigrule_271751']['Manage']
  _etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path = node['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path']
  _etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Dir = ::File.dirname(_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path)
  directory _etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Dir do
    recursive true
  end
  file _etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path do
    action :create
    not_if { ::File.exist?(_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path) }
  end
  ini_setting '_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_271751' do
    path _etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Path
    section node['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Section']
    setting node['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Option']
    value node['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Value']
    notifies :run, 'execute[dconf_update]', :delayed
    only_if node['ol9STIG']['stigrule_271751']['Setting']['_etc_systemd_system_conf_d_55_CtrlAltDel_BurstAction_Only_if']
    separator '='
  end
end
if node['ol9STIG']['stigrule_271752']['Manage']
  systemd_unit 'ctrl_alt_del_target_disable_271752' do
    unit_name node['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_disable_UnitName']
    action node['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_disable_Action']
  end
end
if node['ol9STIG']['stigrule_271752']['Manage']
  systemd_unit 'ctrl_alt_del_target_mask_271752' do
    unit_name node['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_mask_UnitName']
    action node['ol9STIG']['stigrule_271752']['Setting']['ctrl_alt_del_target_mask_Action']
  end
end
if node['ol9STIG']['stigrule_271753']['Manage']
  _etc_security_limits_conf_Path = node['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Path']
  file _etc_security_limits_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_security_limits_conf_Path) }
  end
  file_line '_etc_security_limits_conf_271753' do
    path _etc_security_limits_conf_Path
    match node['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Regexp']
    line node['ol9STIG']['stigrule_271753']['Setting']['_etc_security_limits_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271761']['Manage']
  sysctl 'kernel_randomize_va_space_271761' do
    key node['ol9STIG']['stigrule_271761']['Setting']['kernel_randomize_va_space_Key']
    value node['ol9STIG']['stigrule_271761']['Setting']['kernel_randomize_va_space_Value']
  end
end
if node['ol9STIG']['stigrule_271766']['Manage']
  sysctl 'kernel_kexec_load_disabled_271766' do
    key node['ol9STIG']['stigrule_271766']['Setting']['kernel_kexec_load_disabled_Key']
    value node['ol9STIG']['stigrule_271766']['Setting']['kernel_kexec_load_disabled_Value']
  end
end
if node['ol9STIG']['stigrule_271768']['Manage']
  sysctl 'net_core_bpf_jit_harden_271768' do
    key node['ol9STIG']['stigrule_271768']['Setting']['net_core_bpf_jit_harden_Key']
    value node['ol9STIG']['stigrule_271768']['Setting']['net_core_bpf_jit_harden_Value']
  end
end
if node['ol9STIG']['stigrule_271846']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271846' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271846']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271849']['Manage']
  execute 'sudo_useradd__D__f_35_271849' do
    command node['ol9STIG']['stigrule_271849']['Setting']['sudo_useradd__D__f_35_Command']
    only_if node['ol9STIG']['stigrule_271849']['Setting']['sudo_useradd__D__f_35_Only_if']
  end
end
if node['ol9STIG']['stigrule_271850']['Manage']
  _etc_login_defs_Path = node['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Path']
  file _etc_login_defs_Path do
    action :create
    not_if { ::File.exist?(_etc_login_defs_Path) }
  end
  file_line '_etc_login_defs_271850' do
    path _etc_login_defs_Path
    match node['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Regexp']
    line node['ol9STIG']['stigrule_271850']['Setting']['_etc_login_defs_Line']
  end
end
if node['ol9STIG']['stigrule_271851']['Manage']
  _etc_rsyslog_conf_Path = node['ol9STIG']['stigrule_271851']['Setting']['_etc_rsyslog_conf_Path']
  file _etc_rsyslog_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_rsyslog_conf_Path) }
  end
  file_line '_etc_rsyslog_conf_271851' do
    path _etc_rsyslog_conf_Path
    line node['ol9STIG']['stigrule_271851']['Setting']['_etc_rsyslog_conf_Line']
    notifies :run, 'execute[rsyslog_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271853']['Manage']
  _etc_rsyslog_conf_Path = node['ol9STIG']['stigrule_271853']['Setting']['_etc_rsyslog_conf_Path']
  file _etc_rsyslog_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_rsyslog_conf_Path) }
  end
  file_line '_etc_rsyslog_conf_271853' do
    path _etc_rsyslog_conf_Path
    line node['ol9STIG']['stigrule_271853']['Setting']['_etc_rsyslog_conf_Line']
    notifies :run, 'execute[rsyslog_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271854']['Manage']
  _etc_rsyslog_conf_DefaultNetstreamDriver_Path = node['ol9STIG']['stigrule_271854']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Path']
  file _etc_rsyslog_conf_DefaultNetstreamDriver_Path do
    action :create
    not_if { ::File.exist?(_etc_rsyslog_conf_DefaultNetstreamDriver_Path) }
  end
  file_line '_etc_rsyslog_conf_DefaultNetstreamDriver_271854' do
    path _etc_rsyslog_conf_DefaultNetstreamDriver_Path
    line node['ol9STIG']['stigrule_271854']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Line']
  end
end
if node['ol9STIG']['stigrule_271855']['Manage']
  _etc_rsyslog_conf_ActionSendStreamDriverMode_Path = node['ol9STIG']['stigrule_271855']['Setting']['_etc_rsyslog_conf_ActionSendStreamDriverMode_Path']
  file _etc_rsyslog_conf_ActionSendStreamDriverMode_Path do
    action :create
    not_if { ::File.exist?(_etc_rsyslog_conf_ActionSendStreamDriverMode_Path) }
  end
  file_line '_etc_rsyslog_conf_ActionSendStreamDriverMode_271855' do
    path _etc_rsyslog_conf_ActionSendStreamDriverMode_Path
    line node['ol9STIG']['stigrule_271855']['Setting']['_etc_rsyslog_conf_ActionSendStreamDriverMode_Line']
  end
end
if node['ol9STIG']['stigrule_271856']['Manage']
  _etc_rsyslog_conf_DefaultNetstreamDriver_Path = node['ol9STIG']['stigrule_271856']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Path']
  file _etc_rsyslog_conf_DefaultNetstreamDriver_Path do
    action :create
    not_if { ::File.exist?(_etc_rsyslog_conf_DefaultNetstreamDriver_Path) }
  end
  file_line '_etc_rsyslog_conf_DefaultNetstreamDriver_271856' do
    path _etc_rsyslog_conf_DefaultNetstreamDriver_Path
    line node['ol9STIG']['stigrule_271856']['Setting']['_etc_rsyslog_conf_DefaultNetstreamDriver_Line']
  end
end
if node['ol9STIG']['stigrule_271858']['Manage']
  _etc_firewalld_firewalld_conf_Path = node['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Path']
  file _etc_firewalld_firewalld_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_firewalld_firewalld_conf_Path) }
  end
  file_line '_etc_firewalld_firewalld_conf_271858' do
    path _etc_firewalld_firewalld_conf_Path
    match node['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Regexp']
    line node['ol9STIG']['stigrule_271858']['Setting']['_etc_firewalld_firewalld_conf_Line']
  end
end
if node['ol9STIG']['stigrule_271859']['Manage']
  execute 'nmcli_radio_wifi_off_271859' do
    command node['ol9STIG']['stigrule_271859']['Setting']['nmcli_radio_wifi_off_Command']
    only_if node['ol9STIG']['stigrule_271859']['Setting']['nmcli_radio_wifi_off_Only_if']
  end
end
if node['ol9STIG']['stigrule_271860']['Manage']
  _etc_NetworkManager_NetworkManager_conf_Path = node['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Path']
  _etc_NetworkManager_NetworkManager_conf_Dir = ::File.dirname(_etc_NetworkManager_NetworkManager_conf_Path)
  directory _etc_NetworkManager_NetworkManager_conf_Dir do
    recursive true
  end
  file _etc_NetworkManager_NetworkManager_conf_Path do
    action :create
    not_if { ::File.exist?(_etc_NetworkManager_NetworkManager_conf_Path) }
  end
  ini_setting '_etc_NetworkManager_NetworkManager_conf_271860' do
    path _etc_NetworkManager_NetworkManager_conf_Path
    section node['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Section']
    setting node['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Option']
    value node['ol9STIG']['stigrule_271860']['Setting']['_etc_NetworkManager_NetworkManager_conf_Value']
    notifies :run, 'execute[networkmanager_reload]', :delayed
    separator '='
  end
end
if node['ol9STIG']['stigrule_271864']['Manage']
  sysctl 'net_ipv4_conf_all_accept_redirects_271864' do
    key node['ol9STIG']['stigrule_271864']['Setting']['net_ipv4_conf_all_accept_redirects_Key']
    value node['ol9STIG']['stigrule_271864']['Setting']['net_ipv4_conf_all_accept_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271865']['Manage']
  sysctl 'net_ipv4_conf_all_accept_source_route_271865' do
    key node['ol9STIG']['stigrule_271865']['Setting']['net_ipv4_conf_all_accept_source_route_Key']
    value node['ol9STIG']['stigrule_271865']['Setting']['net_ipv4_conf_all_accept_source_route_Value']
  end
end
if node['ol9STIG']['stigrule_271866']['Manage']
  sysctl 'net_ipv4_conf_all_log_martians_271866' do
    key node['ol9STIG']['stigrule_271866']['Setting']['net_ipv4_conf_all_log_martians_Key']
    value node['ol9STIG']['stigrule_271866']['Setting']['net_ipv4_conf_all_log_martians_Value']
  end
end
if node['ol9STIG']['stigrule_271867']['Manage']
  sysctl 'net_ipv4_conf_default_log_martians_271867' do
    key node['ol9STIG']['stigrule_271867']['Setting']['net_ipv4_conf_default_log_martians_Key']
    value node['ol9STIG']['stigrule_271867']['Setting']['net_ipv4_conf_default_log_martians_Value']
  end
end
if node['ol9STIG']['stigrule_271868']['Manage']
  sysctl 'net_ipv4_conf_all_rp_filter_271868' do
    key node['ol9STIG']['stigrule_271868']['Setting']['net_ipv4_conf_all_rp_filter_Key']
    value node['ol9STIG']['stigrule_271868']['Setting']['net_ipv4_conf_all_rp_filter_Value']
  end
end
if node['ol9STIG']['stigrule_271869']['Manage']
  sysctl 'net_ipv4_conf_default_accept_redirects_271869' do
    key node['ol9STIG']['stigrule_271869']['Setting']['net_ipv4_conf_default_accept_redirects_Key']
    value node['ol9STIG']['stigrule_271869']['Setting']['net_ipv4_conf_default_accept_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271870']['Manage']
  sysctl 'net_ipv4_conf_default_accept_source_route_271870' do
    key node['ol9STIG']['stigrule_271870']['Setting']['net_ipv4_conf_default_accept_source_route_Key']
    value node['ol9STIG']['stigrule_271870']['Setting']['net_ipv4_conf_default_accept_source_route_Value']
  end
end
if node['ol9STIG']['stigrule_271871']['Manage']
  sysctl 'net_ipv4_conf_default_rp_filter_271871' do
    key node['ol9STIG']['stigrule_271871']['Setting']['net_ipv4_conf_default_rp_filter_Key']
    value node['ol9STIG']['stigrule_271871']['Setting']['net_ipv4_conf_default_rp_filter_Value']
  end
end
if node['ol9STIG']['stigrule_271872']['Manage']
  sysctl 'net_ipv4_conf_all_forwarding_271872' do
    key node['ol9STIG']['stigrule_271872']['Setting']['net_ipv4_conf_all_forwarding_Key']
    value node['ol9STIG']['stigrule_271872']['Setting']['net_ipv4_conf_all_forwarding_Value']
  end
end
if node['ol9STIG']['stigrule_271873']['Manage']
  sysctl 'net_ipv4_icmp_echo_ignore_broadcasts_271873' do
    key node['ol9STIG']['stigrule_271873']['Setting']['net_ipv4_icmp_echo_ignore_broadcasts_Key']
    value node['ol9STIG']['stigrule_271873']['Setting']['net_ipv4_icmp_echo_ignore_broadcasts_Value']
  end
end
if node['ol9STIG']['stigrule_271874']['Manage']
  sysctl 'net_ipv4_icmp_ignore_bogus_error_responses_271874' do
    key node['ol9STIG']['stigrule_271874']['Setting']['net_ipv4_icmp_ignore_bogus_error_responses_Key']
    value node['ol9STIG']['stigrule_271874']['Setting']['net_ipv4_icmp_ignore_bogus_error_responses_Value']
  end
end
if node['ol9STIG']['stigrule_271875']['Manage']
  sysctl 'net_ipv4_conf_all_send_redirects_271875' do
    key node['ol9STIG']['stigrule_271875']['Setting']['net_ipv4_conf_all_send_redirects_Key']
    value node['ol9STIG']['stigrule_271875']['Setting']['net_ipv4_conf_all_send_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271876']['Manage']
  sysctl 'net_ipv4_conf_default_send_redirects_271876' do
    key node['ol9STIG']['stigrule_271876']['Setting']['net_ipv4_conf_default_send_redirects_Key']
    value node['ol9STIG']['stigrule_271876']['Setting']['net_ipv4_conf_default_send_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271877']['Manage']
  sysctl 'net_ipv6_conf_all_accept_ra_271877' do
    key node['ol9STIG']['stigrule_271877']['Setting']['net_ipv6_conf_all_accept_ra_Key']
    value node['ol9STIG']['stigrule_271877']['Setting']['net_ipv6_conf_all_accept_ra_Value']
  end
end
if node['ol9STIG']['stigrule_271878']['Manage']
  sysctl 'net_ipv6_conf_all_accept_redirects_271878' do
    key node['ol9STIG']['stigrule_271878']['Setting']['net_ipv6_conf_all_accept_redirects_Key']
    value node['ol9STIG']['stigrule_271878']['Setting']['net_ipv6_conf_all_accept_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271879']['Manage']
  sysctl 'net_ipv6_conf_all_accept_source_route_271879' do
    key node['ol9STIG']['stigrule_271879']['Setting']['net_ipv6_conf_all_accept_source_route_Key']
    value node['ol9STIG']['stigrule_271879']['Setting']['net_ipv6_conf_all_accept_source_route_Value']
  end
end
if node['ol9STIG']['stigrule_271880']['Manage']
  sysctl 'net_ipv6_conf_all_forwarding_271880' do
    key node['ol9STIG']['stigrule_271880']['Setting']['net_ipv6_conf_all_forwarding_Key']
    value node['ol9STIG']['stigrule_271880']['Setting']['net_ipv6_conf_all_forwarding_Value']
  end
end
if node['ol9STIG']['stigrule_271881']['Manage']
  sysctl 'net_ipv6_conf_default_accept_ra_271881' do
    key node['ol9STIG']['stigrule_271881']['Setting']['net_ipv6_conf_default_accept_ra_Key']
    value node['ol9STIG']['stigrule_271881']['Setting']['net_ipv6_conf_default_accept_ra_Value']
  end
end
if node['ol9STIG']['stigrule_271882']['Manage']
  sysctl 'net_ipv6_conf_default_accept_redirects_271882' do
    key node['ol9STIG']['stigrule_271882']['Setting']['net_ipv6_conf_default_accept_redirects_Key']
    value node['ol9STIG']['stigrule_271882']['Setting']['net_ipv6_conf_default_accept_redirects_Value']
  end
end
if node['ol9STIG']['stigrule_271883']['Manage']
  sysctl 'net_ipv6_conf_default_accept_source_route_271883' do
    key node['ol9STIG']['stigrule_271883']['Setting']['net_ipv6_conf_default_accept_source_route_Key']
    value node['ol9STIG']['stigrule_271883']['Setting']['net_ipv6_conf_default_accept_source_route_Value']
  end
end
if node['ol9STIG']['stigrule_271884']['Manage']
  sysctl 'net_ipv4_tcp_syncookies_271884' do
    key node['ol9STIG']['stigrule_271884']['Setting']['net_ipv4_tcp_syncookies_Key']
    value node['ol9STIG']['stigrule_271884']['Setting']['net_ipv4_tcp_syncookies_Value']
  end
end
if node['ol9STIG']['stigrule_271885']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_loginuid_immutable_271885' do
    path node['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Path']
    match node['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Regexp']
    line node['ol9STIG']['stigrule_271885']['Setting']['_etc_audit_rules_d_audit_rules_loginuid_immutable_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_271886']['Manage']
  file_line '_etc_audit_rules_d_audit_rules_e2_271886' do
    path node['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Path']
    match node['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Regexp']
    line node['ol9STIG']['stigrule_271886']['Setting']['_etc_audit_rules_d_audit_rules_e2_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_278952']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_278952' do
    path node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Path']
    match node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Regexp']
    line node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__etc_cron_d__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
if node['ol9STIG']['stigrule_278952']['Manage']
  file_line '_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_278952' do
    path node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Path']
    match node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Regexp']
    line node['ol9STIG']['stigrule_278952']['Setting']['_etc_audit_rules_d_audit_rules__var_spool_cron__cronjobs_Line']
    notifies :run, 'execute[auditd_restart]', :delayed
  end
end
